/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Unions                               */
/*                          Section - 2.4.1.2                                */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/15/84                                          */
/*  Source File :           source/decl.2412.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/01/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Addition of basic types short int, long int,  */
/*                             unsigned int, unsigned long, unsigned short,  */
/*                             unsigned char, long float.  Unsigned char     */
/*                             is only for UTX-32 .                          */
/*                                                                           */
/*  Description :           Verify that the basic types of int, long int,    */
/*                          short int, unsigned int, unsigned long, unsigned */
/*                          short, unsigned char, char, float and double     */
/*                          can be declared as a member of a union.          */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/* Test 1
        verify the syntax    union { type-specifier declarator; }
*/
 
#include <stdio.h>
 
typedef  char  *typedef_name;
typedef  int   def_bit;
union  key {
             char          *keyword;
             int            key1;
             short          key2;
             long           key3;
             short int      key4;
             long int       key5;
             unsigned       key6;
             unsigned int   key7;
             unsigned long  key8;
             unsigned short key9;
             unsigned char  key10;
             float          key11;
             long float     key12;
             double         key13;
             typedef_name   keyline;
             struct field {
                           def_bit bit : 1;
                           def_bit     : 1;
                          };
           };
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
            fprintf(fp,"  .. declaration, unions 2.4.1.2 class 1 pass\n");
            printf("  .. declaration, unions 2.4.1.2 class 1 pass\n");
            fclose(fp);
}
