/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3                                   */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.235.c                                */
/*  Revisions :             10/20/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/01/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added equivalent unsigned's (unsigned short,  */
/*                             unsigned long, unsigned char( UTX-32 only) ). */
/*                          -- Added comment on test portability.            */
/*                                                                           */
/*  Date :                  3/15/84                                          */
/*  Descriptions :          Verify that  a field references are treated an   */
/*                          unsigned integers or, equivalent unsigned's      */
/*                          (whose size is the number of bits in the field.  */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*       NOTE:  This test may NOT be portable because some processors        */
/*              have signed bitfields.  For UTX-32 1.0 Release, bitfields    */
/*              are unsigned.                                                */
 
#include <stdio.h>
 
struct {
         unsigned         bit0    : 1;
         int              bit1    : 1;
         unsigned int     bit2    : 1;
         unsigned short   bit3    : 1;
         char             bit4    : 1;
         unsigned char    bit5    : 1;
         unsigned long    rest    : 26 ;
       } words;
#define TRUE 1;
 
int fail= 0;
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
 
   { /* Test 1 - declare local variables to be unsigned integers */
 
        unsigned field1,field2, bit0,bit1,bit2,bit3,bit4,bit5 ;
 
        /* turn on all the bits using size bigger than their width */
        words.bit0 = words.bit1 = words.bit2 = words.bit3 = words.bit4 =
        words.bit5 = 0xffffffff;
        bit0   = words.bit0 ;
        bit1   = words.bit1 << 1;
        bit2   = words.bit2 << 2;
        bit3   = words.bit3 << 3;
        bit4   = words.bit4 << 4;
        bit5   = words.bit5 << 5;
        field1 = bit0 & bit1 & bit2 & bit3 & bit4 & bit5 & words.rest;
        field2 = bit0 | bit1 | bit2 | bit3 | bit4 | bit5 | words.rest;
        if ( field1 != 0 || field2 != 0x3f )
        {       fail = TRUE;
                fprintf(fp,"  ** declaration, fields 2.3.5-1 class 2 fail exit return code : %d\n",field1);
                printf("  ** declaration, fields 2.3.5-1 class 2 fail exit return code : %d\n",field1);
        }
    }
   { /* Test 2 - declare local varaibles to be integers */
 
        int     field1,field2, bit0,bit1,bit2,bit3,bit4,bit5 ;
 
        /* turn on all the bits using size bigger than their width */
        words.bit0 = words.bit1 = words.bit2 = words.bit3 = words.bit4 =
        words.bit5 = 0xffffffff;
        bit0   = words.bit0 ;
        bit1   = words.bit1 << 1;
        bit2   = words.bit2 << 2;
        bit3   = words.bit3 << 3;
        bit4   = words.bit4 << 4;
        bit5   = words.bit5 << 5;
        field1 = bit0 & bit1 & bit2 & bit3 & bit4 & bit5 & words.rest;
        field2 = bit0 | bit1 | bit2 | bit3 | bit4 | bit5 | words.rest;
        if ( field1 != 0 || field2 != 0x3f )
        {       fail = TRUE;
                fprintf(fp,"  ** declaration, fields 2.3.5-2 class 2 fail exit return code : %d\n",field1);
                printf("  ** declaration, fields 2.3.5-2 class 2 fail exit return code : %d\n",field1);
        }
    }
   if (!fail) {
                fprintf(fp,"  .. declaration, fields 2.3.5   class 2 pass\n");
                printf("  .. declaration, fields 2.3.5   class 2 pass\n");
                }
                fclose(fp);
}
 
