/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3.3                                 */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.233.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  1.2                                              */
/*  Descriptions :          Verify that the unamed fields as a filler.       */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/* verify an unnamed field behaves as a filler.                              */
/* The compiler fails, if this program does not compiled.                    */
#include <stdio.h>
 
int    WSIZE = 4;
struct {
         unsigned  bit1    : 1;
         unsigned  bit4    : 4;
         unsigned  bit5    : 5;
         unsigned          : 22;       /* unnamed field 2.3.3           */
       } words;
 
 
 
main()
{
   FILE *fp;
 /* local variables used */
         int error;
         fp=fopen("decl_res bloc=y","a");
 
   /* Test 1 : verify that the size of the structure is 1 word as
               expected.
   */
   if ( (error = sizeof(words)) != WSIZE ) {
        fprintf(fp,"  ** declaration, fields 2.3.3-1 class 2 fail exit return code : %d\n",error);
        printf("  ** declaration, fields 2.3.3-1 class 2 fail exit return code : %d\n",error);
        }
   else
      {
        /* Test 2 : verify the fields are allocated correctly.
        */
        /* turn on all the named bit fields */
        words.bit1 = 0x11;              /* only one bit should be used   */
        words.bit4 = 0xff;              /* only four bits should be used */
        words.bit5 = 0xf1f;             /* only five bits should be used */
 
        /* expected value ffc00000 */
        if ( words.bit1 != 1 || words.bit4 != 0xf || words.bit5 != 0x1f ){
           fprintf(fp,"  ** declaration, fields 2.3.3-2 class 2 fail exit return code : %x\n",words);
           printf("  ** declaration, fields 2.3.3-2 class 2 fail exit return code : %x\n",words);
           }
        else
           {
           fprintf(fp,"  .. declaration, fields 2.3.3   class 2 pass\n");
           printf("  .. declaration, fields 2.3.3   class 2 pass\n");
           }
           fclose(fp);
      }
}
 
