/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3.2                                 */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.232.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          05/03/84    Tina Aleksa   UTX-32 1.0 Release     */
/*                          -- Added comment on test portability.            */
/*                                                                           */
/*  Date :                  5/18/84                                          */
/*  Descriptions :          Verify that fields are allocated from left to    */
/*                          right. This test reflects the nature of different*/
/*                          hardware.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      This test is machine dependent. */
 
#include <stdio.h>
 
main()
{
FILE *fp;
struct {
         unsigned  bit1    : 1;         /* bit1 occupies the left most 1 bit */
         unsigned  bit2    : 3;         /* bit2 occupies the next left most 3
                                                3 bits                       */
         unsigned  rest    : 28;
       } boundary;
      boundary.bit1 = 3;                /* only one bit should be set */
      boundary.bit2 = 8;                /* value bigger than 3 bits,
                                           no bit should be set */
      boundary.rest = 0;                /* turn off the rest of the bits*/
      /* expected value should be 80000000, with the left most bit on */
      fp=fopen("decl_res bloc=y","a");
      if ( boundary.bit1 != 1 || boundary.bit2 != 0 ||
                boundary.rest != 0x0 ){
        fprintf(fp,"  ** declaration, fields 2.3.2   class 3 fail exit return code : %x\n",boundary);
        printf("  ** declaration, fields 2.3.2   class 3 fail exit return code : %x\n",boundary);
        }
      else
      {
        fprintf(fp,"  .. declaration, fields 2.3.2   class 3 pass\n");
        printf("  .. declaration, fields 2.3.2   class 3 pass\n");
        }
        fclose(fp);
 
}
