/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.7                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  5/18/84                                                  */
/*  Source File :           source/decl.22173.c                              */
/*                                                                           */
/*  Revisions :             05/17/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          05/18/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Added internal static structure test.         */
/*                                                                           */
/*  Description :           For an array of structures, verify that members  */
/*                          of static and external structures that are       */
/*                          members of structures are initialized to zero    */
/*                          when they are not explicitly initialized in      */
/*                          the declaration.                                 */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*
     syntax     struct { type-specifier declarator;
                       struct { type-specifier declarator;
                              struct { type-specifier declarator;
                                     }
                              }
                       }
 
                struct { type-specifier declarator;
                       struct { type-specifier declarator;
                              }
                       }
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail =0;
 
        struct one1 {
                    int a1;
                    struct two2 {
                                int a2;
                                long b2;
                                struct three3 {
                                              int b3;
                                              long a3;
                                } three[3];
                                int c2;
                   } two[2];
                   int b1;
       } one[5];
 
static struct four4 {           /* external static structure */
                    int a4;
                    short b4;
                    struct five5 {
                                 unsigned a5;
                                 long b5;
                                 int c5;
                    } five[5];
                    short c4;
       } four[4];
main ()
{
 FILE *fp;
 
static struct six6 {            /* internal static structure */
                    int a6;
                    long b6;
                    struct seven {
                                 unsigned a7;
                                 long b7;
                    } seven[7];
                    short c6;
       } six[6];
 
 int a, b, c, d, e;
 fp=fopen("decl_res bloc=y","a");
 
/* Verify that all members of external struct one are initialized to zero */
 
 for ( a = 0; a < 5; a++ )      /* struct one */
 {
  if ( one[a].a1 != 0 || one[a].b1 != 0 )
     { fail = TRUE;
       fprintf(fp,"  ** declaration, structures 2.2.1.7.3-1 class 2 fail exit return code : %d %d %d\n",a, one[a].a1, one[a].b1 );
       printf("  ** declaration, structures 2.2.1.7.3-1 class 2 fail exit return code : %d %d %d\n",a, one[a].a1, one[a].b1 );
     }
     for ( b = 0; b < 2; b++ )  /* struct two */
     {
      if ( one[a].two[b].a2 != 0 || one[a].two[b].b2 != 0 ||
           one[a].two[b].c2 != 0 )
         { fail = TRUE;
           fprintf(fp,"  ** declaration, structures 2.2.1.7.3-2 class 2 fail exit return code : %d%d %d %d\n",a, b, one[a].two[b].a2,one[a].two[b].b2, one[a].two[b].c2 );
           printf("  ** declaration, structures 2.2.1.7.3-2 class 2 fail exit return code : %d%d %d %d\n",a, b, one[a].two[b].a2,one[a].two[b].b2, one[a].two[b].c2 );
         }
         for ( c = 0; c < 3; c++ )      /* struct three */
         {
          if ( one[a].two[b].three[c].b3 != 0 ||
               one[a].two[b].three[c].a3 != 0   )
             { fail = TRUE;
               fprintf(fp,"  ** declaration, structures 2.2.1.7.3-3 class 2 fail exit return code : %d%d%d %d %d\n", a, b, c,one[a].two[b].three[c].b3, one[a].two[b].three[c].a3 );
               printf("  ** declaration, structures 2.2.1.7.3-3 class 2 fail exit return code : %d%d%d %d %d\n", a, b, c,one[a].two[b].three[c].b3, one[a].two[b].three[c].a3 );
             }
         }
     }
 }
 
/* Verify that all members of external static struct four
   are initialized to zero. */
 
 for ( d = 0; d < 4; d++ )      /* struct four */
 {
     if ( four[d].a4 != 0 || four[d].b4 != 0 ||
          four[d].c4 != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.7.3-4 class 2 fail exit return code : %d %d %d %d\n", d, four[d].a4,four[d].b4, four[d].c4 );
          printf("  ** declaration, structures 2.2.1.7.3-4 class 2 fail exit return code : %d %d %d %d\n", d, four[d].a4,four[d].b4, four[d].c4 );
        }
        for ( e = 0; e < 5; e++ )       /* struct five */
        {
            if ( four[d].five[e].a5 != 0 || four[d].five[e].b5 != 0 ||
                 four[d].five[e].c5 != 0 )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.3-5 class 2 fail exit return code : %d%d %d %d %d\n", d, e,four[d].five[e].a5, four[d].five[e].b5,four[d].five[e].c5);
                 printf("  ** declaration, structures 2.2.1.7.3-5 class 2 fail exit return code : %d%d %d %d %d\n", d, e,four[d].five[e].a5, four[d].five[e].b5,four[d].five[e].c5);
               }
        }
 }
 
/* Verify that all members of internal static struct six
   are initialized to zero. */
 
 for ( d = 0; d < 6; d++ )      /* struct six */
 {
     if ( six[d].a6 != 0 || six[d].b6 != 0 ||
          six[d].c6 != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.7.3-6 class 2 fail exit return code : %d %d %d %d\n", d, six[d].a6,six[d].b6, six[d].c6 );
          printf("  ** declaration, structures 2.2.1.7.3-6 class 2 fail exit return code : %d %d %d %d\n", d, six[d].a6,six[d].b6, six[d].c6 );
        }
        for ( e = 0; e < 7; e++ )       /* struct seven */
        {
            if ( six[d].seven[e].a7 != 0 || six[d].seven[e].b7 != 0 )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.3-7 class 2 fail exit return code : %d%d %d %d\n", d, e,six[d].seven[e].a7, six[d].seven[e].b7 );
                 printf("  ** declaration, structures 2.2.1.7.3-7 class 2 fail exit return code : %d%d %d %d\n", d, e,six[d].seven[e].a7, six[d].seven[e].b7 );
               }
        }
 }
 
        if (!fail){
            fprintf(fp,"  .. declaration, structures 2.2.1.7.3 class 2 pass\n");
            printf("  .. declaration, structures 2.2.1.7.3 class 2 pass\n");
            }
            fclose(fp);
}
