/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.7.2                              */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  10/25/83                                                 */
/*  Source File :           source/decl.22172.c                              */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Description :           Verify external structures that their members    */
/*                          can be initialized and referenced.               */
/*                          The compiler fails if this program cannot compile*/
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/* This program verifies that external structure can be initialized and
   referenced, especially after passing to function.
*/
/* Test method : Two arrays TAB and keytab are initialized externally.
                 Then keytab is passed to  a function to verify its content
                 with TAB. They should match each other otherwise errors
                 occure.
                 The compiler fails if this program cannot be compiled.
*/
 
#include <stdio.h>
 
char   *TAB[]={"auto","break","case","char","continue"};
 
struct key {
             char *keyword;
             int  keycount;
           }  keytab[] = { {"auto",0},   /* initialize keyword and its  */
                           {"break",0},  /*  count                      */
                           {"case",0},
                           {"char",0},
                           {"continue",0}};
FILE *fp;
main()
{
 
fp=fopen("decl_res bloc=y","a");
         if( search (keytab) ){
            fprintf(fp,"  .. declaration, structures 2.2.1.7.2 class 2 pass\n");
            printf("  .. declaration, structures 2.2.1.7.2 class 2 pass\n");
            }
            fclose(fp);
}
 
search (keytab)
struct key keytab[];
{
    int n;
    for ( n=0 ; n < 5 ; n++ )
       {
          if ( compare(TAB[n] ,keytab[n].keyword))
 
             {
                fprintf(fp,"  ** declaration, structures 2.2.1.7.2 class 2 fail exit return code : %d\n",n);
                printf("  ** declaration, structures 2.2.1.7.2 class 2 fail exit return code : %d\n",n);
                return(0);/* not found */
             }
       }
    return (1);/* found */
}
 
/* COMPARE
        function - compare two given strings
        inputs   - two string s and t
        outputs  - =0, if s is equal to t
                   >0, if s is greater than t
                   <0, if s is less than t
*/
compare(s,t)
char s[],t[];
{
  int i;
  i = 0;
  while (s[i] == t[i])
     if (s[i++] == '\0' )
        return (0);
  return(s[i] - t[i]);
}
 
debug()
{
    int n;
         for ( n=0 ; n < 5 ; n++ )
             {
             fprintf(fp,"\t\t\t keyword[ %d ] = %s\n",n,keytab[n].keyword);
             printf("\t\t\t keyword[ %d ] = %s\n",n,keytab[n].keyword);
             }
}
