/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.5                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  8/15/85                                          */
/*  Source File :           source/decl.22153.c                              */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          05/15/84    T. Aleksa    UTX-32  1.0 Release     */
/*                          --  Added types short int, long int, unsigned    */
/*                              int, unsigned short, unsigned long, unsigned */
/*                              char and long float.                         */
/*                          08/15/85    T. Aleksa    UTX-32  1.2 Release     */
/*                          -- modified test due to protect bit violation    */
/*                                                                           */
/*  Description :           For structure members that are arrays of the     */
/*                          basic types : Verify that arrays members that    */
/*                          are not explicitly initialized are initialized   */
/*                          to zero.                                         */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*
                   syntax    struct { type-specifier declarator;
                                    }
                             struct { type-specifier declarator : const expr;
                                      type-specifier : const expr;
                                    }
*/
 
#include <stdio.h>
#define LINE 1
#define TRUE 1
 
int fail=0, i, j ;
typedef  char  *typedef_name;
typedef  int   def_bit;
 
 char buf[1000];
 static struct key {
             char *keyword[LINE];
             int   key1[1][2];
             short key2[2] ;
             long  key3[3] ;
             unsigned key4[4] ;
             float key5[1][5] ;
             double key6[1][6] ;
             typedef_name keyline[3] ;
             short int key7[1][7] ;
             long int key8[1][8] ;
             unsigned int key9[9] ;
             unsigned short key10[10] ;
             unsigned long key11[11][11] ;
             unsigned char *key12[LINE] ;
             long float key13[2][2] ;
             struct field {
                           def_bit bit : 1;     /* used typedef definition */
                           def_bit     : 1;
                          };
           } table[] = { "keyword",1,1,2,2,3,3,3,4,4,4,4,5,5,5,5,5,
                         6,6,6,6,6,6,"keyline" }   ;
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
 
    if ( table->key1[0][1] != 1 || table->key2[0] != 2 ||
                table->key2[1] != 2 || table->key3[2] != 3 ||
                table->key4[3] != 4 || table->key5[0][4] != 5 ||
                table->key6[0][5] != 6  )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.3-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
          printf("  ** declaration, structures 2.2.1.5.3-1 class 2 fail exit return code : %d\n",table->key1[0][1]);
        }
 
     if ( compare(table->keyword[0],"keyword") )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.3-2 class 2 fail exit return code : %s\n",table->keyword[0]);
          printf("  ** declaration, structures 2.2.1.5.3-2 class 2 fail exit return code : %s\n",table->keyword[0]);
        }
 
     if ( compare(table->keyline[0],"keyline"))
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.3-3 class 2 fail exit return code : %s\n",table->keyline[0]);
          printf("  ** declaration, structures 2.2.1.5.3-3 class 2 fail exit return code : %s\n",table->keyline[0]);
        }
 
     if ( table->keyline[1] != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.3-4 class 2 fail exit return code : %d\n",table->keyline[1]);
          printf("  ** declaration, structures 2.2.1.5.3-4 class 2 fail exit return code : %d\n",table->keyline[1]);
        }
 
     if ( table->keyline[2] != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** declaration, structures 2.2.1.5.3-5 class 2 fail exit return code : %d\n",table->keyline[2]);
          printf("  ** declaration, structures 2.2.1.5.3-5 class 2 fail exit return code : %d\n",table->keyline[2]);
        }
 
     for ( i = 0; i < 1; i++ )
         { for ( j = 0; j < 7; j++ )
             { if ( table->key7[i][j] != 0 )
                { fail = TRUE;
                  fprintf(fp,"  ** declaration, structures 2.2.1.5.3-6 class 2 fail exit return code : %d\n",table->key7[i][j] );
                  printf("  ** declaration, structures 2.2.1.5.3-6 class 2 fail exit return code : %d\n",table->key7[i][j] );
                  }
             }
         }
 
     for ( i = 0; i < 1; i++ )
         { for ( j = 0; j < 8; j++ )
             { if ( table->key8[i][j] != 0 )
                { fail = TRUE;
                  fprintf(fp,"  ** declaration, structures 2.2.1.5.3-7 class 2 fail exit return code : %d\n",table->key8[i][j] );
                  printf("  ** declaration, structures 2.2.1.5.3-7 class 2 fail exit return code : %d\n",table->key8[i][j] );
                }
             }
         }
 
     for ( i = 0; i < 9; i++ )
         { if ( table->key9[i] != 0 )
            { fail = TRUE;
              fprintf(fp,"  ** declaration, structures 2.2.1.5.3-8 class 2 fail exit return code : %d\n",table->key9[i] );
              printf("  ** declaration, structures 2.2.1.5.3-8 class 2 fail exit return code : %d\n",table->key9[i] );
            }
         }
 
     for ( i = 0; i < 10; i++ )
         { if ( table->key10[i] != 0 )
            { fail = TRUE;
              fprintf(fp,"  ** declaration, structures 2.2.1.5.3-9 class 2 fail exit return code : %d\n",table->key10[i] );
              printf("  ** declaration, structures 2.2.1.5.3-9 class 2 fail exit return code : %d\n",table->key10[i] );
            }
         }
 
     for ( i = 0; i < 11; i++ )
         { for ( j = 0; j < 11; j++ )
             { if ( table->key11[i][j] != 0 )
                { fail = TRUE;
                  fprintf(fp,"  ** declaration, structures 2.2.1.5.3-10 class 2 fail exit return code : %d\n",table->key11[i][j] );
                  printf("  ** declaration, structures 2.2.1.5.3-10 class 2 fail exit return code : %d\n",table->key11[i][j] );
                }
             }
         }
 
     for ( i = 0; i < LINE; i++ )
     {
      if ( table->key12[i] != 0 )
         { fail = TRUE;
           fprintf(fp,"  ** declaration, structures 2.2.1.5.3-11 class 2 fail exit return code : %d\n",table->key12[i]);
           printf("  ** declaration, structures 2.2.1.5.3-11 class 2 fail exit return code : %d\n",table->key12[i]);
         }
     }
 
     for ( i = 0; i < 2; i++ )
         { for ( j = 0; j < 2; j++ )
             { if ( table->key13[i][j] != 0 )
                { fail = TRUE;
                  fprintf(fp,"  ** declaration, structures 2.2.1.5.3-12 class 2 fail exit return code : %f\n",table->key13[i][j] );
                  printf("  ** declaration, structures 2.2.1.5.3-12 class 2 fail exit return code : %f\n",table->key13[i][j] );
                }
             }
         }
 
if (!fail){
        fprintf(fp,"  .. declaration, structures 2.2.1.5.3 class 2 pass\n");
        printf("  .. declaration, structures 2.2.1.5.3 class 2 pass\n");
        }
        fclose(fp);
 
}
 
compare(s1,s2)                  /* compare two strings, and return a zero
                                   if they are equal to each other
                                */
char *s1,*s2;
{       for ( ; *s1 == *s2 ; s1++,s2++ )
                if ( *s1 == '\0' )
                        return (0);
        return ( *s1 - *s2 );
}
