/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section - 2.2.1.4                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/decl.2214.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/09/84    T. Aleksa    UTX-32 1.0 Release      */
/*                          -- Modified test description to verify that      */
/*                             automatic structures can be referenced.       */
/*                          -- Modified comparison test and added variables  */
/*                             of type unsigned int, unsigned char, unsigned */
/*                             long, unsigned short, and long float.         */
/*                                                                           */
/*  Description :           Verify that the basic types of int, short int,   */
/*                          long int, unsigned int, unsigned short, unsigned */
/*                          long, unsigned char, char, float and double can  */
/*                          be referenced in an automatic structure.         */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
#define FALSE 0
int fail ;
 
typedef  char  *typedef_name;
 
main()
{
        FILE *fp;
        auto struct key {
                char *keyword ;
                int   key1;
                short key2 ;
                long  key3 ;
                unsigned key4 ;
                float key5 ;
                double key6 ;
                unsigned int key7 ;
                unsigned long key8 ;
                unsigned char key9 ;
                unsigned short key10 ;
                long float key11 ;
                typedef_name keyline ;  /*  type char  */
        }
        table;
 
        /*   assign values to structure members    */
 
        table.key1 = 1;
        table.key2 = 2;
        table.key3 = 3;
        table.key4 = 4;
        table.key5 = 5.5;
        table.key6 = 6.6;
        table.key7 = 7;
        table.key8 = 8;
        table.key9 = 9;
        table.key10 = 10;
        table.key11 = 11.11;
        table.keyword = "keyword";
        table.keyline = "keyline";
        fp=fopen("decl_res bloc=y","a");
        fail = FALSE;
 
        /*  verify that the structure members can be referenced  */
 
        if ( table.key1 != 1 || table.key2 != 2 ||
            table.key3 != 3 || table.key4 != 4 ||
            table.key5 != 5.5 || table.key6 != 6.6 ||
            table.key7 != 7 || table.key8 != 8 ||
            table.key9 != 9 || table.key10 != 10 ||
            table.key11 != 11.11 ||
            ( compare ( table.keyword,"keyword") != 0 ) ||
            ( compare ( table.keyline,"keyline") != 0 )  )
        {
                fail = TRUE;
                fprintf(fp,"  ** declaration, structures 2.2.1.4 class 1 fail exit return code : %d\n",table.key1 );
                printf("  ** declaration, structures 2.2.1.4 class 1 fail exit return code : %d\n",table.key1 );
        }
 
        if (!fail)
                fprintf(fp,"  .. declaration, structures 2.2.1.4 class 1 pass\n");
                printf("  .. declaration, structures 2.2.1.4 class 1 pass\n");
                fclose(fp);
}
 
compare(s1,s2)                  /* compare two strings, and return a zero
                                   if they are equal to each other
                                */
char *s1,*s2;
{
        for ( ; *s1 == *s2 ; s1++,s2++ )
                if ( *s1 == '\0' )
                        return (0);
        return ( *s1 - *s2 );
}
