
     Name
          nbcc - Non-Based C Compiler driver

     Syntax
          nbcc [ options ] file [file] [file] [file]

     Description
          The nbcc command invokes the Non-Based C compiler.  The
          compilation tools consist of a preprocessor (nbcpp), compiler
          (nbccom), and assembler (nbcas).  The nbcc command processes
          the supplied options and then executes the various tools with
          the proper arguments.  The nbcc command accepts several types
          of files as arguments.

          Files whose names end with .c are taken to be C source programs
          and may be preprocessed, compiled, and assembled.  The compil-
          ation process may be stopped after the completion of any pass
          if the appropriate options are supplied.  If the compilation
          process runs through the assembler, then an object program is
          produced and is left in the file whose name is that of the 
          source with .o substituted for .c.  In the same way, files
          whose names end in .s are taken to be assembly source programs
          and may be assembled; and files whose names end in .i are
          taken to be preprocessed C source programs and may be compiled
          and assembled.  Files whose names do not end in .c, .s, or .i
          are flagged as errors, and will not be processed.

          Since the nbcc command usually creates files in the current
          directory during the compilation process, it is necessary to
          run the nbcc command in a directory in which a file can be
          created.

          The following options are interpreted by nbcc:

          -A[options]
               Pass the specified options to nbcas for processing.
               See the nbcas.m page for available options.

          -C   Produce an object file with a .o suffix.  If this option
               is not specified, the assembler will not produce an
               object file.

          -Dsymbol
               Pass the defined "symbol" to the preprocessor.

          -E   Run only nbcpp on the named C programs, and send the
               result to a file with the .i suffix.

          -G   Generate symbol attribute information for the symbolic
               debugger (AID).

          -H   Produce an output file that is pure dsect only.  This is
               the handler option for producing MPX resident code.

          -Idirectory
               Pass the "directory" path to the preprocessor to be
               scanned for include files.

          -L[file]
               Pass the specified "file" to the assembler as the file
               to use for the listing output.  If no file is specified,
               a file with a .l suffix will be used.  This may be
               required if the assembler generated listing file can
               not be extend enough to hold the listing output.  This
               option is also passed to the compile so C source code
               will be passed to the assembler as comment statements.
               This option also passes a -C to the preprocess so source
               comments are not deleted, and will be passed on to the
               compiler.

          -Mlibrary
               Pass the specified "library" to the assembler as the
               file to search for macros.  Usually m.mpxmac.

          -Q[options]
               Pass the specified options to nbcpp for processing.
               See the nbcpp.m page for available options.

          -Pprefile
               Pass the specified "prefile" to the assembler as the
               first file to be processed.

          -S   Compile and do not assemble the named C programs, and
               leave the assembler-language output in corresponding
               files suffixed .s.

          -Tprefile
               Pass the specified "tempfile" to the assembler to be
               used as the intermediate temporary file.  This may be
               required if the assembler generated temporary file can
               not be extend enough to hold the intermediate output.

          -Usymbol
               Pass the undefined "symbol" to the preprocessor.

          -V   Operate nbcc in the verbose mode, echoing commands passed
               to the preprocessor, compiler, and assembler.

          -X[options]
               Pass the specified options to nbccom for processing.
               See the nbccom.m page for available options.

          -W   Pass the option to the compiler to indicate supression
               of warning messages.

          Other arguments are taken to be program names.  Each program
          name specified will be processed in order, using the options
          specified.  A single nbcc command will process as many files
          as there is room on the command line to specify them.  Usually
          limited to 80 characters unless the TSM "line" command is used
          to set a larger value.

     Examples
          nbcc -L -C file.c will produce an object file file.o in the
          current directory.
          nbcc -E -QM file.c file2.c will produce a list of the include
          files used by the programs file.c and file2.c on the standard
          output file.
          nbcc -S file.c will produce an assembler source file file.s in
          the current working directory.
          nbcc -L -P/system/system/mpxpre file.s will produce a listing
          file file.l in the current directory.  No object file will be
          produced.  The prefile, mpxpre in the system directory, will 
          be used during the assemble process.

     Files
          file.c                C source file
          file.i                preprocessed C source file
          file.l                assembly listing file
          file.o                object file
          file.s                assembly language file
          TMPDIR/*              temporary files
          BINDIR/nbcpp          preprocessor
          BINDIR/nbccom         compiler
          BINDIR/nbcas          assembler

          BINDIR is usually /system/bin or @SYSTEM(BIN)
          TMPDIR is the current working directory

     See Also
          nbcas.m, nbcpp.m, nbccom.m

     Diagnostics
          The diagnostics produced by the C compiler are sometimes
          cryptic.

     Notes
          The C language standard was extended to allow arbitrary
          length variable names.  The preprocessor and compiler are
          currently set to 128 characters maximum.  However, the
          assembler, and Encore defined object code, only recognize 
          8 characters.  All compiler variables are prepended with
          an "_".  If an external definition is not unique in the 
          first 7 characters, an assembler error will occur.  The
          assembler will truncate arbitrary length variable names.

          Pathnames may be upper/lower case and may by specified in
          MPX format (@VOLUME(DIRECTORY)FILE) or in UNIX format
          (/volume/directory/file).  All pathnames are mapped to
          uppercase and converted MPX pathnames by the runtime.

          (printed 9/21/90 - J B Systems)


