/* yylex.c */
/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 *	Gould, Inc. Base Register Assembler
 */

#ifndef lint
/*NOBASE*/
static char *rcsid = "@(#) (Gould) $Header: yylex.c,v 5.5 89/05/12 12:38:03 pcc Rel-3_0 $";
#endif

#ifndef JCB
#define index strchr
#define _ctype_ _ctype
#endif /* JCB */

#include <stdio.h>
#include <ctype.h>
#include "struct.h"
#include "operand.h"
#include "y.tab.h"

YYSTYPE	yylval;
Tuchar	tokenbuf[MAX_STR];
char	*index();
Tuchar	*yylinept;
OPND	opnull;






/*
NAME: yyinit
PURPOSE: fix the ctype table for the parser
PRECONDITIONS:
_ctype_ is defined in ctype.h (normally in /usr/include).
isalpha and isalnum are described in UNIX man page ctype(3).
POSTCONDITIONS:
yyinit "adjusts" the ctype table allowing certain chars to be treated
as letters by routines isalpha and isalnum.
a new attribute is provide for the characters '.' and '_'.
first change is (primarily) for location pointer "dot",
second is for the C compiler underscore convention.
HISTORY:
part of initial code DJK
*/






yyinit()
{
    (_ctype_ + 1)['.'] |= _L;	/* to make .name scan as alpha */
    (_ctype_ + 1)['_'] |= _L;	/* to make _name scan as alpha */
}






/*
NAME: yylex
PURPOSE: lexical analyzer for the assembler parser.
PRECONDITIONS:
this routine is used to scan operands ONLY. labels and opcodes are
handled by simpler routines (notably get_token in pass.c).
this routine is required by yyparse in gram.c, which is a YACC parser
and should ONLY be called by yyparse.
the global pointer yylinept must be pointing at the input buffer (which
is read in pass_handler of pass.c).
a leading '$' should mean we are dealing with a NOBASE symbol
(see also get_token in pass.c).
the routine strnum in strnum.c converts a character string into a
numeric value and sets the global variable strnum_end to point at the
character which follows the last numeric character in the string.
POSTCONDITIONS:
the last character accepted as a part of the token is returned if the
token is not an identifier or number (in which case the token IDENT or
NUMBER is returned.
yylinept is left pointing at the next character in the input buffer
EXCEPT when a comma is seen. because the operand parser can count
operands only by knowing the number of commas, this routine cannot
silently scan past them.
the global structure yyval.o is set for the use of yyparse.
ALGORITHM:
clear yyval.o and scan a character using yylinept. iff the character is
white space, look at the next character.
if the next character would be a operand separator or delimiter, return
0 to yyparse to tell it as much. fix yylinept if the character is a comma
or a semicolon. commas must be counted by op1 to get operand count,
semicolons must be available for error recovery.
if the next character is not appropriate as the first character of an
operand token (essentially must be alphanumeric, '.', '_', or '$'), just
return the character.
collect a full alphanumeric token in tokenbuf.
determine (in the following order) if the collected token is a number, a
general register, or a base register.
if so, set the yyval.o fields and return.
if not, assume it is a symbol and use the appropriate symbol table
routines (from sym.c) to enter it there. then set the necessary yyval.o
fields and return to yyparse.
HISTORY:
part of initial code DJK
*/






yylex()
{
    extern Tuchar    *strnum_end;
    register Tuchar   c;
    register SYM     *s;
    register Tuchar  *tp = tokenbuf;

    yylval.o = opnull;
    for (;;) {
	c = *yylinept++;
	if (c == ' ' || c == '\t' || c == '\f')
	{
	    continue;
	}

#ifdef REP_COUNT
	if (index("\n;,!@", c))
#else /* not REP_COUNT */
	if (index("\n;,!", c))
#endif /* REP_COUNT */
	{
	    /* a little kluge to help op1 with variable operand ops */
	    /* operand parser MUST move yylinept past comma itself */
	    /* sitting on the semi colon helps error processing (sigh) */
#ifdef REP_COUNT
	    /* sitting on the @ helps repeat count processing */
	    if ((c == ',') || (c == ';') || (c == '@'))
#else /* not REP_COUNT */
	    if ((c == ',') || (c == ';'))
#endif /* REP_COUNT */
	    {
		yylinept--;
	    }
	    return(0);
	}
	if (isalnum(c)) {
	    while (isalnum(c)) {
		*tp++ = c;
		c = *yylinept++;
	    }
	    if (c == ':') {	/* DATAPOOL element name */
		*tp++ = ':';
		c = *yylinept++;
		while (isalnum(c)) {
		    *tp++ = c;
		    c = *yylinept++;
		}
	    }
	    *tp = 0;
	    yylinept--;

	    if (isdigit(tokenbuf[0])) {
		strnum(tokenbuf, &yylval.o);
		switch (*strnum_end) {

		    case 'w': 
			yylval.o.constval *= 4;
			break;

		    case 'h': 
			yylval.o.constval *= 2;
			break;

		    case 'l': 
			yylval.o.constval *= 8;
			break;

		    case 0:	/* string terminator */
			break;

		    default: 
			error("bad character in number %s", tokenbuf);
			yylval.o.constval = 0;
		}
		yylval.o.haveseen = CONST;
		return(NUMBER);
	    }
	    if( tokenbuf[0]=='r' ){
		if( tokenbuf[2]==0 && tokenbuf[1]>='0' && tokenbuf[1]<='7' ){
		    yylval.o.haveseen=AREG;
		    yylval.o.regval=tokenbuf[1]-'0';
		    return( IDENT );
		}
	    } else
	    if( tokenbuf[0]=='b' ){
		if( tokenbuf[2]==0 && tokenbuf[1]>='0' && tokenbuf[1]<='7' ){
		    yylval.o.haveseen=BREG;
		    yylval.o.baseval=tokenbuf[1]-'0';
		    return( IDENT );
		}
	    }
	    if (pass == 1)
	    {
		s = defsym(tokenbuf);
	    }
	    else	/* better be pass == 2 */
	    {
		s = lookup(tokenbuf);
	    }

    /* the first test should never happen, if it does, this routine */
    /* likely was called only in the second pass for some operand. */
	    if (s == 0)
	    {
		error ("yylex: symbol %s used before declaration",
		    tokenbuf);
		yylval.o.haveseen = NAME;
		yylval.o.symname = s;
		return(IDENT);
	    }
	    else if (s -> sflags & S_CONST) {
		yylval.o.haveseen = CONST;
		yylval.o.constval = s -> svalue;
		return(NUMBER);
	    }
	    else {
		yylval.o.haveseen = NAME;
		yylval.o.symname = s;
		return(IDENT);
	    }
	}
	yylval.opchar = c;
	return(c);
    }
}






/*
NAME: yyerror
PURPOSE: error handling routine for yyparse
PRECONDITIONS:
yyerror is required for yyparse of gram.c, which is a YACC parser.
parameter s is a string containing an error diagnostic from yyparse.
this routine should ONLY be called by yyparse.
POSTCONDITIONS:
the error message is printed using the assembler's error routine and
then the input buffer pointer yylinept is moved to the next statement
separator to avoid further error messages from the incorrect operand.
ALGORITHM:
the algorithm is obvious, but the recovery mechanism used is not very
pleasant. skipping to the next comma might be a little nicer, but it
might also cause a worse avalanche of error messages.
HISTORY:
part of initial code DJK
*/






yyerror(s)
char *s;
{
    error ("yyerror: %s", s);
    while (yylinept && (*yylinept != '\n' && *yylinept != ';'))
    {
	yylinept++;
    }
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
