/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: sym.c,v 5.2 88/08/30 01:11:30 pcc Released $";
#endif

/*
*
* Gould Base Register Assembler
* Initial design & coding by R. J. Miller 
* at Compion Corporation 
* Wed May 25 20:39:43 CDT 1983
* Modified for hashed symbol table
* Mon Jul 18 14:11:16 EDT 1983
*
*/

#include "struct.h"

#define NULL 0

int	Symsymbols;		/* symbol table size counter */
int	Symchars;		/* string table size counter */

extern SYM *lookup();

SYM symtab[NHASH];		/* hash table head nodes */
SYM *dot;
static int ccnt = 0;
static SYM *sym_free = NULL;
Tuchar *cblock = NULL;
Tuchar *sstring ();
SYM *ssymbol();
SYM *sym_create();
SYM first_sym;
SYM *latest_sym = &first_sym;
SYM *newest_label = 0;

extern int L_labflag;


/*
NAME: checklab
PURPOSE: phase check a label during pass 2
PRECONDITIONS:
label is the name of the label, if it is not defined then something
nasty happened in pass 1.
POSTCONDITIONS:
returns the symtab pointer to the symbol being checked so that the no
base stuff can get it easily.
if svalue, sspace, or the S_FAR atributes do not match, give a phase
error. if this occurs, there is a problem in the assembler with address
handling or with symbol handling between passes.
a constant space label may change svalue across passes due to the use
of instructions that have immediate variants. this contraction is legal,
so the phase check is different. expansion is not allowed however.
HISTORY:
part of initial coding RJM
NOBASE code added RJM
Mon Sep  5 16:14:30 EDT 1983
*/

#ifndef OLDCALL
int func_lab_flg = 0;
SYM * func_lab = 0;
#endif NOT OLDCALL

SYM *
checklab (label)
Tuchar *label;
{
    register SYM *sym_ptr;
    enum SEGS oldseg = last_SEGS;

    /* must trap local symbols here when implemented */
    if ((sym_ptr = lookup(label)) == NULL)
    {
	error ("checklab - symbol not defined %s", label);
    }
    else
    {
#ifdef POOL
    /* note that constant segments ARE different, see procedure header */
#else not POOL
    /* note that constant segment IS different, see procedure header */
#endif POOL
	if ((sym_ptr -> sspace != dot -> sspace) ||
#ifdef POOL
	    ((sym_ptr -> sspace < S_Lconstant
		|| sym_ptr -> sspace > S_Hconstant) &&
#else not POOL
	    (sym_ptr -> sspace != S_constant &&
#endif POOL
		sym_ptr -> svalue
		    != (dot -> svalue
			+ ((sym_ptr -> sflags & S_PAD) ? 2 : 0))
	    )
	    ||
#ifdef POOL
	    (sym_ptr -> sspace >= S_Lconstant
		&& sym_ptr -> sspace <= S_Hconstant &&
#else not POOL
	    (sym_ptr -> sspace == S_constant &&
#endif POOL
		sym_ptr -> svalue < dot -> svalue))
	{
	    error ("checklab - symbol phase error %s. expect %x+%x, got %x+%x",
		label, sym_ptr -> sspace, sym_ptr -> svalue,
		dot -> sspace, dot -> svalue);
	}
	else if (far_flag && !(sym_ptr -> sflags & S_FAR))
	{
	    error ("checklab - symbol not declared FAR %s", label);
	}
    }
#ifndef OLDCALL
    if (func_lab_flg) {		/* flag set by .bf */
	func_lab_flg = 0;
	func_lab = sym_ptr;
    }
#endif NOT OLDCALL

    return (sym_ptr);	/* so that previous statement works, sigh */
}

/*
NAME: deflab 
PURPOSE: define a label during pass 1
PRECONDITIONS:
label is name of label to be defined. except in case of a local symbol,
it should not already have S_DEF set in the symbol table.
although this routine should never be called for a stab, the label from
an operand field of a stab (stabd) may be zero length.
POSTCONDITIONS:
returns the symtab pointer to the symbol being checked so that the no
base stuff can get it easily.
successful completion results in creation of a symbol table entry with
the appropriate things done to define a label.
HISTORY:
sequential version part of initial code
hashed version part of release 2-3 mods RJM
Tue Jul 19 19:18:46 EDT 1983
NOBASE code added RJM
Mon Sep  5 16:14:30 EDT 1983
modified for threaded symbol table RJM
Wed Sep 14 16:10:08 EDT 1983
*/

#ifndef OLDCALL
SYM *curr_func_symp = 0;
int curr_farlabs = 0;
#endif NOT OLDCALL

SYM *
deflab (label)
Tuchar *label;
{
    register SYM *sym_ptr;
    register SYM *old_sym;
    int temp_hash;
    int value;
    enum SEGS oldseg = last_SEGS;

    /* find a home, if not defined than old_sym is where it will be */
    sym_ptr = symtab[(temp_hash = hash(label))].snext;
    old_sym = &symtab[temp_hash];

    while (sym_ptr &&
	((value = strcmp(sym_ptr -> sname, label)) < 0))
    {
	old_sym = sym_ptr;
	sym_ptr = sym_ptr -> snext;
    }

    /* must trap local symbols here when implemented */
    if (sym_ptr && (value == 0))
    {
	if (sym_ptr -> sflags & S_DEF)
	{
	    error ("%s redefined", label);
	    return (NULL);
	}
    }

    if ((sym_ptr == NULL) || (value > 0))
    {
	sym_ptr = sym_create (label, old_sym);
    }

    sym_ptr -> svalue = dot -> svalue;
    sym_ptr -> sflags |= S_DEF | S_DECL | S_LABEL;

    sym_ptr -> sspace = dot -> sspace;

    /* fix sflags for far space */
    switch (dot -> sspace)
    {
	case S_fartext:
	    sym_ptr -> sflags |= S_FAR;
	    /* drop into following case */
	case S_text:
#ifndef OLDCALL
	    if (curr_func_symp && curr_func_symp -> sspace == dot -> sspace
		&& (sym_ptr -> svalue - curr_func_symp -> svalue >= 0x10000))
		    ++curr_farlabs;
#endif NOT OLDCALL
	    break;

	case S_fardata:
	case S_fdat2:
	    sym_ptr -> sflags |= S_FAR;
	    /* drop into following case */
	case S_data:
	case S_dat2:
	    break;

	case S_bss:		/* should never have label in bss space */
#if defined(COFF)
	case S_farbss:		/*  except for section names */
	    if (strcmp(label, ".bss") != 0 && strcmp(label, ".nbbss") != 0) {
		error ("deflab: attempt to define label %s in bss space",
		    label);
		return (NULL);
	    }
#else A.OUT
	case S_farbss:
	    error ("deflab: attempt to define label %s in bss space",
		label);
	    return (NULL);
	    break;
#endif COFF

#ifdef POOL
	case S_Lconstant:
	case S_Dconstant:
	case S_Wconstant:
	case S_Xconstant:
	case S_Hconstant:
#else not POOL
	case S_constant:
#endif POOL
	    break;

	default:
	    error ("deflab: bad segment %d", dot -> sspace);
	    break;
    }

#ifdef DEBUG
    printf ("deflab: name %s\nsvalue %d sflags 0x%x sspace %d\n",
	sym_ptr -> sname, sym_ptr -> svalue,
	sym_ptr -> sflags, sym_ptr -> sspace);
#endif

#ifndef OLDCALL
    e_lab_append(sym_ptr);	/* append to enter stack, if in enter seg */
#endif NOT OLDCALL
    newest_label = sym_ptr;
    return (sym_ptr);
}

/*
NAME: defstab
PURPOSE: enter a stab in symtab with all attributes undefined
PRECONDITIONS:
this routine should be called ONLY from op_stab in stab.c.
argument symbol is just name of symbol to define.
the symbol from a stabd pseudo op will have zero length, string table
size must be calculated to avoid these.
POSTCONDITIONS:
must always return a newly allocated symbol table entry, so initialize
all of the fields for a new symbol table entry, link it in, and
return a pointer to the symbol. this routine should not fail, but call
to ssymbol might (causing assembly abort).
HISTORY:
copy of defsym with appropriate modifications RJM
Thu Feb  9 10:51:19 CST 1984
*/

SYM *
defstab (symbol)
Tuchar *symbol;
{
    register SYM *sym_ptr;
    register SYM *old_sym;
    int temp_hash;

    sym_ptr = symtab[(temp_hash = hash(symbol))].snext;
    old_sym = &symtab[temp_hash];

    while (sym_ptr &&
	(strcmp(sym_ptr -> sname, symbol) <= 0))
    {
	old_sym = sym_ptr;
	sym_ptr = sym_ptr -> snext;
    }

    sym_ptr = sym_create (symbol, old_sym);

    sym_ptr -> svalue = 0;
    sym_ptr -> sflags = S_DECL;
    if (far_flag)
    {
	sym_ptr -> sflags |= S_FAR;
    }
    sym_ptr -> sspace = last_SEGS;

#ifdef DEBUG
    printf ("defstab: name %s\nsvalue %d sflags 0x%x sspace %d\n",
	sym_ptr -> sname, sym_ptr -> svalue,
	sym_ptr -> sflags, sym_ptr -> sspace);
#endif

    return (sym_ptr);
}

/*
NAME: defsym
PURPOSE: enter a symbol in symtab with all attributes undefined
PRECONDITIONS:
argument symbol is just name of symbol to define.
the symbol from a stabd pseudo op will have zero length, string table
size must be calculated to avoid these.
POSTCONDITIONS:
if symbol already defined, just return a pointer, otherwise initialize
all of the fields for a new symbol table entry, link it in, and
return a pointer to the symbol. this routine should not fail, but call
to ssymbol might (causing assembly abort).
HISTORY:
sequential version part of initial code
hashed version part of release 2-3 mods RJM
Mon Jul 18 15:26:13 EDT 1983
modified for threaded symbol table RJM
Wed Sep 14 16:10:08 EDT 1983
*/

SYM *
defsym (symbol)
Tuchar *symbol;
{
    register SYM *sym_ptr;
    register SYM *old_sym;
    int temp_hash;
    int value;

    sym_ptr = symtab[(temp_hash = hash(symbol))].snext;
    old_sym = &symtab[temp_hash];

    while (sym_ptr &&
	((value = strcmp(sym_ptr -> sname, symbol)) < 0))
    {
	old_sym = sym_ptr;
	sym_ptr = sym_ptr -> snext;
    }

    if ( sym_ptr && (value == 0))
    {
	return (sym_ptr);
    }

    sym_ptr = sym_create (symbol, old_sym);

    sym_ptr -> svalue = 0;
    sym_ptr -> sflags = S_DECL;
    if (far_flag)
    {
	sym_ptr -> sflags |= S_FAR;
    }
    sym_ptr -> sspace = last_SEGS;

#ifdef DEBUG
    printf ("defsym: name %s\nsvalue %d sflags 0x%x sspace %d\n",
	sym_ptr -> sname, sym_ptr -> svalue,
	sym_ptr -> sflags, sym_ptr -> sspace);
#endif

    return (sym_ptr);
}

/*
NAME: hash
PURPOSE: define hash function for the symbol table
PRECONDITIONS:
parameter s is the symbol name to be hashed.
POSTCONDITIONS:
value returned is the index into symtab which this symbol will be
chained to.
NO chaining is done here, defsym and deflab handle that problem.
HISTORY:
part of release 2-3 mods RJM
Mon Jul 18 15:01:54 EDT 1983
*/

hash (s)
register Tuchar *s;
{
    int i = 0;

    /* create a value from the symbol */
    while (*s)
    {
	i = i * 10 + *s++ - ' ';
    }

    /* returned value restricted to: 0 <= i < NHASH */
    i = i % NHASH;

    return (i < 0 ? i + NHASH : i);
}

/*
NAME: initsymtab
PURPOSE: initialize the symbol table
POSTCONDITIONS:
define the position pointer '.' (dot) in the symbol table.
dot is not output with symbol table, so it should not be threaded off
of first_sym.
also force default declarations to be in near space.
HISTORY:
sequential version part of initial code
hashed version part of release 2-3 mods RJM
Tue Jul 19 19:10:02 EDT 1983
modified for threaded symbol table RJM
Wed Sep 14 16:10:08 EDT 1983
*/

initsymtab ()
{
    /* the location pointer, referred to as "dot" */
    dot = defsym(".");
    dot -> sspace = S_text;
    dot -> sflags = S_DEF;

    first_sym.s_taborder = NULL;
    latest_sym = &first_sym;	/* and reset this one too */
}

/*
NAME: lookstab
PURPOSE:
find a stab in the symbol table, return a pointer to the symtab entry
PRECONDITIONS:
this routine should be called ONLY from op_stab in stab.c.
the search performed by this routine is dependent on the linear ordering
of the symbols and will fail if called more than once per unique stab.
in the symtab hash table, each chain should be in (alpha) order. if the
stab has already been "found" by this routine there should be another
one following it which is the one we need to return.
POSTCONDITIONS:
returns a pointer to the symbol on success, returns NULL (== 0) on fail.
the S_LOOKSTAB bit in the symbol's sflags element is set on success.
HISTORY:
copy of lookup with appropriate modifications RJM
Thu Feb  9 10:51:19 CST 1984
*/

SYM *
lookstab (name)
register Tuchar *name;
{
    register SYM *symp;
    register int value;
    register Tuchar *tsymp;

    symp = symtab[hash(name)].snext;

    while (symp)
    {
	if (((value = strcmp (symp -> sname, name)) == 0) &&
	    ((symp -> sflags & S_LOOKSTAB) == 0))
	{
	    symp -> sflags |= S_LOOKSTAB;
	    return (symp);
	}
	else if (value > 0)	/* have gone beyond where it would be */
	{
/* SPR85100782 */
/* Note that stab names with ";A" or ";T" substrings may have had digit */
/* string following 'A'/'T' changed. Therefore, for these do not end */
/* search when value > 0 */
	    for (tsymp = name; *tsymp;)
		if (*tsymp++ == ';' && (*tsymp == 'T' || *tsymp == 'A'))
		    goto lookstab_loop;
	    return (NULL);
	}
	else			/* keep looking */
	{
lookstab_loop:
	    symp = symp -> snext;
	}
    }

    return (NULL);		/* symbol not found */
}

/*
NAME: lookup
PURPOSE:
find a symbol in the symbol table, return a pointer to the symtab entry
PRECONDITIONS:
in the symtab hash table, each chain should be in (alpha) order
POSTCONDITIONS:
returns a pointer to the symbol on success, returns NULL (== 0) on fail.
HISTORY:
sequential version part of initial code
hashed version part of release 2-3 mods RJM
Mon Jul 18 15:26:13 EDT 1983
*/

SYM *
lookup (name)
register Tuchar *name;
{
    register SYM *symp;
    register int value;

    symp = symtab[hash(name)].snext;

    while (symp)
    {
	if ((value = strcmp (symp -> sname, name)) == 0)
	{
	    return (symp);
	}
	else if (value > 0)	/* have gone beyond where it would be */
	{
	    return (NULL);
	}
	else			/* keep looking */
	{
	    symp = symp -> snext;
	}
    }

    return (NULL);		/* symbol not found */
}

/*
NAME: set_rel_id
PURPOSE: set s_id field for use in relocation info in pass 2
PRECONDITIONS:
pass 1 MUST be completed before calling this routine (currently called
from pass2_init of aout.c), otherwise forward references to local labels
may not have been flagged properly.
POSTCONDITIONS:
all symbols that are to be emitted to the output (object) file are
#if defined(COFF)
selected and numbered properly for the r_symndx field of a relocation
#else A.OUT
selected and numbered properly for the r_symbolnum field of a relocation
#endif COFF
datum. Symsymbols (number of symbols in the symbol table) and Symchars
(number of characters in the string table) are also set.
local labels (any beginning with 'L') are not output to the a.out file
except if -L was specified (L_labflag).
stabd symbols (any beginning with '!') are not output to the string
table as they really have no name (the assembler requires one however
and uses the internal convention of leading '!' followed by the third
operand (which should be the source line number)). see op_stab in stab.c
the s_id field must begin at zero (it being a zero based ordinal). the
number of symbols (Symsymbols) is a cardinal and hence is one based.
ALGORITHM:
if the -L flag (L_labflag) is in effect, all symbols are selected. the
static order chain built by Sym_create need not be touched.
if not, symbols with names beginning with 'L' (capital L) and which have
the S_LABEL attribute set (done ONLY by deflab) are compressed out of
the static chain. these symbols are local labels by compiler convention.
HISTORY:
coded RJM
Mon Nov 14 22:41:41 CST 1983
*/

set_rel_id ()
{
    register SYM *old_ptr;
    register SYM *sym_ptr;

    /* compress the static list if necessary */
    if (!L_labflag)
    {
	for (old_ptr = &first_sym, sym_ptr = first_sym.s_taborder;
	    sym_ptr; sym_ptr = sym_ptr -> s_taborder)
	{
	    if (sym_ptr -> sname[0] == 'L' &&
	       (sym_ptr -> sflags & S_LABEL))
	    {
#ifdef SPAN
/* keep Local symbols defined in data and bss so span functionality in ld */
/* can calculate correct sizes */
	    switch(sym_ptr -> sspace) {
		case S_data:
		case S_bss:
		case S_dat2:
			old_ptr = sym_ptr;
			break;
		default:
			old_ptr -> s_taborder = sym_ptr -> s_taborder;
			break;
	    }
#else not  SPAN
		old_ptr -> s_taborder = sym_ptr -> s_taborder;
#endif SPAN
	    }
	    else
	    {
		old_ptr = sym_ptr;
	    }
	}
    }

    /* now set the s_id field, Symsymbols, and Symchars */
    for (sym_ptr = first_sym.s_taborder, Symsymbols = 0, Symchars = 0;
	sym_ptr; sym_ptr = sym_ptr -> s_taborder)
    {
	sym_ptr -> s_id = Symsymbols++;
	/* leading ! indicates an internal stab symbol */
	if (sym_ptr -> sname[0] != '!')
	{
	    Symchars += strlen (sym_ptr -> sname) + 1;
	}
    }
}

/*
NAME: sstring
PURPOSE: preallocate space for symbol table name fields
PRECONDITIONS:
parameter string is the name that space is required for.
POSTCONDITIONS:
if no space left (as determined by return value of calloc), abort the
assembly, otherwise should always return a string pointer.
ALGORITHM:
a large block (cblock) is allocated and used until a request cannot be
satisfied, at which point a new block is allocated.
manifest constant MAX_STR is defined in struct.h .
HISTORY:
part of release 2-3 mods RJM
one might guess that this routine was borrowed from some other assembler.
Tue Jul 19 19:14:56 EDT 1983
*/

Tuchar	*
sstring(string)
register Tuchar  *string;
{
    register Tuchar  *p, *q;			/* working char string */
    register int    i;

    i = strlen (string);			/* get length of string */

    /* if the string is longer than the allocated block, forget it */
    /* strlen does not include the null terminator */
    if (i >= MAX_STR)
    {
	error ("Fatal assembler error (string too long) %s", string);
	exit (2);
    }

    if (++i > ccnt) {			/* if not enough room get more */
	if ((cblock = (Tuchar *) calloc (MAX_STR, 1)) == NULL)
	{
	    error ("Fatal assembler error (string storage exceeded)");
	    exit (2);
	}
	ccnt = MAX_STR;
    }

    p = q = cblock;			/* copy string into permanent storage */
    while (*p++ = *string++);
    cblock = p;
    ccnt -= i;
    return (q);
}

/*
NAME: ssymbol
PURPOSE: preallocate space for symbol table entries
PRECONDITIONS:
variable sym_free must == NULL on first call to assure proper
termination of the free list.
POSTCONDITIONS:
if no space left (as determined by return value of calloc), abort the
assembly, otherwise should always return a symbol pointer.
ALGORITHM:
a large block is allocated and used until a request cannot be satisfied,
at which point a new block is allocated.  all elements are linked
through the SYM field snext in a chain to the static pointer sym_free
after the calloc call for efficient allocation of single SYM elements.
manifest constant SYM_INCR is defined in struct.h
HISTORY:
part of release 2-3 mods RJM
one might guess that this routine was borrowed from some other assembler.
Mon Jul 18 15:01:54 EDT 1983
*/

SYM *
ssymbol()
{
    register SYM *sym_ptr;
    register int i;

    if ((sym_ptr = sym_free) != NULL)
    {
	sym_free = sym_ptr -> snext;
    }
    else
    {
	sym_ptr = (SYM *) calloc (SYM_INCR, sizeof(SYM));
	if (sym_ptr == NULL)
	{
	    error ("Fatal assembler error (symbol storage exceeded)");
	    exit (2);
	}
	else
	{
	    /* chain all of them together */
	    for (i = SYM_INCR - 1; i--;)
	    {
		sym_ptr -> snext = sym_free;
		sym_free = sym_ptr++;
	    }
	}
    }
    return (sym_ptr);
}

/*
NAME: sym_create
PURPOSE: link up a new symbol table entry
PRECONDITIONS:
parameter name is the symbol name, parameter old_sym is the pointer to
the symbol table chain element that this symbol attaches to through the
old_sym -> snext field.
the global symbol latest_sym points to the last symbol entered in the
table and is used to maintain the source (static) ordering of the
symbols in the table so they may be output correctly for the debuggers.
POSTCONDITIONS:
a pointer to the new symbol is returned.
space is allocated for the symbol table entry using ssymbol and for the
symbol name using sstring.
HISTORY:
coded RJM
Wed Sep 14 09:46:41 EDT 1983
*/

SYM *
sym_create (name, old_sym)
char *name;
SYM *old_sym;
{
    register SYM *sym_ptr;

    sym_ptr = ssymbol ();

    /* link it back up */
    sym_ptr -> snext = old_sym -> snext;
    old_sym -> snext = sym_ptr;

    /* and fix the name */
    sym_ptr -> sname = sstring (name);

    /* set the static ordering links */
    sym_ptr -> s_taborder = NULL;
    latest_sym -> s_taborder = sym_ptr;
    latest_sym = sym_ptr;

    return (sym_ptr);
}

/*
NAME: dump_syms, pr_sym
PURPOSE: debugging routines, prints the symbol table
ALGORITHM:
dump_syms handles the hashing, pr_sym prints the fields of a single
symbol table entry.
HISTORY:
sequential version part of initial code
hashed version part of release 2-3 mods RJM
Tue Jul 19 19:17:43 EDT 1983
*/

dump_syms ()
{
    register SYM *sym_ptr;
    register int i;
    printf ("symbol table dump:\n");

    for (i = 0; i < NHASH; i++)
    {
	sym_ptr = symtab[i].snext;
	while (sym_ptr)
	{
	    printf ("hash chain index: %d ", i);
	    pr_sym (sym_ptr);
	    sym_ptr = sym_ptr -> snext;
	}
    }
}

pr_sym (sym_ptr)
register SYM *sym_ptr;
{
    printf ("name %s\nsvalue %d sflags 0x%x sspace %d s_id %d\n",
	sym_ptr -> sname, sym_ptr -> svalue, sym_ptr -> sflags,
	sym_ptr -> sspace, sym_ptr -> s_id);
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
