/* ophash.c */
/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 *	Gould, Inc. Base Register Assembler
 */

#ifndef lint
/*NOBASE*/
static char *rcsid = "@(#) (Gould) $Header: ophash.c,v 5.5 89/05/12 12:36:24 pcc Rel-3_0 $";
#endif

/*
NAME: oplook
PURPOSE: hashing function for opcode table
PRECONDITIONS:
parameter s is the opcode mnemonic.
this routine does NOT assure that the returned index matches the optable
index of the mnemonic (eg, it does not chain to the correct entry).
this routine should be called using routine uncollide (in opcode.c) if
chaining is required (builder does its own chaining).
POSTCONDITIONS:
returns an integer index into the optable array which is (hopefully)
very close to the actual position of the mnemonic.
HISTORY:
stolen from sym.c, original date
Mon Jul 18 15:01:54 EDT 1983
tested in builder
Sun Jul 24 21:43:59 EDT 1983
inclusion in assembler
Mon Aug  1 10:52:12 EDT 1983
*/







#ifdef TEST
extern int MAX_HASH;
extern int HASH_BASE;
#else /* NOT TEST */
#include "ophash.h"
#endif /* TEST */

oplook (s)
register char *s;
{
    register int i = 0;

    /* build a value from the mnemonic */
    while (*s)
    {
	i = i * HASH_BASE + *s++ - ' ';
    }

    /* must return value i such that: 0 <= i < MAX_HASH */
    i %= MAX_HASH;

    return (i < 0 ? i + MAX_HASH : i);
}

/*
 * 	(c) Copyright 1987 Gould Inc.
 * 	    All Rights Reserved.
 */
