/* reader.c */

/* %M% %I% %H% SCCS comment line. Leave it alone. */
# include "mfile2.h"
FILE *infc;
/* some storage declarations */
#ifndef ONEPASS
NODE node[TREESZ];
int lineno;
int ftnno;  /* number of current function */
char filename[100] {
 "" };
#else
#define NOMAIN
#endif
int nrecur;
int lflag;
extern int Wflag;
OFFSZ tmpoff;  /* offset for first temporary, in bits
                  for current block*/
OFFSZ maxoff;  /* maximum temporary offset over all blocks
                  in current ftn, in bits */
int maxtreg;
NODE *stotree;
int stocook;
OFFSZ baseoff = 0;
OFFSZ maxtemp = 0;
#ifndef NOMAIN
mainp2( argc, argv ) char *argv[];
{
 /* prepare to read the trees, etc. from the first pass, and
   generate real code from them */
 int oreg2(); /* jrr */
 register NODE *p;
 register int c;
 register char *cp;
 register temp;
  p2init(argc, argv);
 tinit();
 while( (c=getc(infc)) > 0 ) switch( c ){
 case 't': /* text space */
  getc(infc);
  swfc(textfc);
  continue;
 case 'd': /* data space */
  getc(infc);
  swfc(datafc);
  continue;
 case ')':
  /* copy line unchanged */
  while( (c=getc(infc)) > 0 ){
   if (noprt == 0) putc(c, of);
   if( c == '\n' ) break;
  }
  continue;
 case '[':
  /* beginning of a block */
  temp = rdin(10);  /* ftnno */
  tmpoff = baseoff = rdin(10); /* autooff for block gives
                                  max offset of autos in block */
  maxtreg = rdin(10);
  if( getc(infc) != '\n' ) cerror( "intermediate file format error");
  if( temp != ftnno ){ /* beginning of function */
   maxoff = baseoff;
   ftnno = temp;
   maxtemp = 0;
  }
  else {
   if( baseoff > maxoff ) maxoff = baseoff;
   /* maxoff at end of ftn is max of autos and temps
         over all blocks in the function */
  }
  setregs();
  continue;
 case ']':  /* end of block */
  SETOFF( maxoff, ALSTACK );
  eobl2();
  while( (c=getc(infc)) != '\n' ){
   if( c <= 0 ) cerror( "intermediate file format eof" );
  }
  continue;
 case '.':
  /* compile code for an expression */
  lineno = rdin( 10 );
  for( cp=filename; (*cp=getc(infc)) != '\n'; ++cp ) ;
        /* VOID, reads filename */
  *cp = '\0';
 /* if( lflag ) */
  lineid( lineno, filename );
  tmpoff = baseoff;  /* expression at top level reuses temps */
  p = eread();
  if( edebug ) {
   fprintf(of, "mainp2(), case '.':\n");
   fwalk(p, eprint, 0);
  }
  nrecur = 0;
  walkf( p, oreg2 ); /* jrr */
  areg2(p); /* create U& and U* nodes for dummy registers - jrr */
  if(xdebug && edebug) {
   fprintf(of, "mainp2(), before codgen:\n");
   fwalk(p, eprint, 0);
  }
  codgen( p, FOREFF );  /* expression statement  throws out results */
  reclaim( p, RNULL, 0 );
  allchk();
  tcheck();
  continue;
 default:
  cerror( "intermediate file format error" );
 }
 /* EOF */
 return(nerrors);
}
#endif
p2init(argc, argv) char    *argv[];
{
 /* set the values of the pass 2 arguments */
 register int    c;
 register char  *cp;
 register    files;
 swfc(textfc);
 allo0();      /* free all regs */
 files = 0;
 for (c = 1; c < argc; ++c) {
  if (*(cp = argv[c]) == '-') {
   while (*++cp) {
    switch (*cp) {
    case 'X':     /* pass1 flags */
     while (*++cp) {   /* VOID */
     }
     --cp;
     break;
    case '1': /* hold over from old days */
      /* ignore it. */
     break;
    case 'm':    /* table matches */
     ++mdebug;
     break;
    case 'l':     /* linenos */
     ++lflag;
     break;
    case 'e':     /* expressions */
     ++edebug;
     break;
    case 'o':     /* orders */
     ++odebug;
     break;
    case 'r':     /* register allocation */
     ++rdebug;
     break;
    case 'a':     /* rallo */
     ++radebug;
     break;
    case 't':     /* ttype calls */
     ++tdebug;
     break;
    case 's':     /* shapes */
     ++sdebug;
     break;
    case 'u':     /* Sethi-Ullman testing (machine dependent) */
     ++udebug;
     break;
    case 'x':     /* general machine-dependent debugging flag */
     ++xdebug;
     break;
    case 'w':
    case 'W':     /* shut up warnings */
     ++Wflag;
     break;
    default:
     cerror("bad option: %c", *cp);
    }
   }
  }
  else
   files = 1;     /* assumed to be a filename */
 }
 mkdope();
 setrew();
 return(files);
}
#ifdef ONEPASS
p2compile(p) NODE  *p;
{
 extern int oreg2();
 NODE *np;
 if(edebug)
  printf("p2compile(%x):\n", p);
 for(np=node; np <&node[TREESZ]; ++np)
  if(np->in.op != TYPE) {
   np->in.rall = NOPREF;
   np->in.su = 0;
  }
 /*if (lflag)*/
  lineid(lineno, filename);
 tmpoff = baseoff;     /* expression at top level reuses temps */
 /* generate code for the tree p */
#ifndef BUG4
 if (edebug)
  fwalk(p, eprint, 0);
#endif
#ifdef MYREADER
 MYREADER(p);     /* do your own laundering of the input */
#endif
 nrecur = 0;
 walkf(p, oreg2);
 areg2(p);
 if(xdebug && edebug) {
  fprintf(of, "p2compile(), before codgen:\n");
  fwalk(p, eprint, 0);
 }
 if(optype(p->in.op) == LTYPE)
  dumchek(p); /* Check for nonsense statements */
 codgen(p, FOREFF);
 reclaim(p, RNULL, 0);
 allchk();
 /* can't do tcheck here; some stuff (e.g., attributes) may
    be around from first pass */
 /* first pass will do it... */
}
p2bbeg(aoff, myreg)
{
 static int  myftn = -1;
 tmpoff = baseoff = (unsigned int) aoff;
 maxtreg = myreg;
 if (myftn != ftnno) {    /* beginning of function */
  maxoff = baseoff;
  myftn = ftnno;
  maxtemp = 0;
 }
 else {
  if (baseoff > maxoff)
   maxoff = baseoff;
  /* maxoff at end of ftn is max of autos and temps over all blocks */
 }
 setregs();
}
p2bend()
{
 SETOFF(maxoff, ALSTACK);
 eobl2();
}
#endif
dumchek(p)  NODE *p;
{
 if(ISFTN(p->in.type))
  werror("Nonsense function reference - parentheses missing???");
 else
  werror("Nonsense statement has no effect");
}
codgen( p, cookie ) NODE *p;
{
 register NODE *svtree;
 /* generate the code for p;
     order may call codgen recursively */
 /* cookie is used to describe the context */
 svtree = NIL;
 for(;;){
  p->in.rall = NOPREF;
  canon(p);  /* creats OREG from * if possible and does sucomp */
  stotree = NIL;
  if( edebug ){
   fprintf(of,  "codegen - store called on:\n" );
   fwalk( p, eprint, 0 );
  }
  store(p);
  if( stotree==NIL ) break;
  order( stotree, stocook );
 }
 order( p, cookie );
}
char *cnames[]  = {
 "SANY",
 "SAREG",
 "STAREG",
 "SBREG",
 "STBREG",
 "SCC",
 "SNAME",
 "SCON",
 "SFLD",
 "SOREG",
 "STARNM",
 "STARREG",
 "INTEMP",
 "FORARG",
 "SWADD",
 0,
};
prcook( cookie ){
 /* print a nice-looking description of cookie */
 int i, flag;
 if( cookie & SPECIAL ){
  if( cookie == SZERO ) fprintf(of,  "SZERO" );
  else if( cookie == SONE ) fprintf(of,  "SONE" );
  else if( cookie == SMONE ) fprintf(of,  "SMONE" );
  else fprintf(of,  "SPECIAL+%d", cookie & ~SPECIAL );
  return;
 }
#ifndef NBC
 if (!cookie) fprintf (of, "NULL");
#endif
 flag = 0;
 for( i=0; cnames[i]; ++i ){
  if( cookie & (1<<i) ){
   if( flag ) fprintf(of,  "|" );
   ++flag;
   fprintf(of,  cnames[i] );
  }
 }
}
order(p,cook) NODE *p;
{
 register o, ty, m;
 int m1;
 int cookie;
 NODE *p1, *p2;
 /* by this time, p should be able to be generated without stores;
     the only question is how */
again:
 cookie = cook;
 rcount();
 canon(p);
 rallo( p, p->in.rall );
 if( odebug ){
  fprintf(of,  "order( %x, ", p );
  prcook( cookie );
  fprintf(of,  " )\n" );
  fwalk( p, eprint, 0 );
 }
 o = p->in.op;
 ty = optype(o);
 /* first of all, for most ops, see if it is in the table */
 /* look for ops */
 switch( m = p->in.op ){
 default:
  /* look for op in table */
  for(;;){
   if( (m = match( p, cookie ) ) == MDONE ) goto cleanup;
   else if( m == MNOPE ){
    if( !(cookie = nextcook( p, cookie ) ) ) goto nomat;
    continue;
   }
   else break;
  }
  if( cook == INTEMP) {
   order(p, INAREG|INBREG);
   m = match(p, INTEMP);
   if(m == MDONE) goto cleanup;
   else  goto nomat;
  }
  break;
 case COMOP:
 case FORCE:
 case FORCE1:
 case CBRANCH:
 case QUEST:
 case ANDAND:
 case OROR:
 case NOT:
 case UNARY CALL:
 case CALL:
 case UNARY STCALL:
 case STCALL:
 case UNARY FORTCALL:
 case FORTCALL:
  /* don't even go near the table... */
  ;
 }
 /* get here to do rewriting if no match or
     fall through from above for hard ops */
 p1 = p->in.left;
 if( ty == BITYPE ) p2 = p->in.right;
 else p2 = NIL;
 if( odebug ){
  fprintf(of,  "order( %x, ", p );
  prcook( cook );
  fprintf(of,  " ), cookie " );
  prcook( cookie );
  fprintf(of,  ", rewrite %s\n", opst[m] );
 }
 switch( m ){
 default:
nomat:
  if( odebug ){
   fprintf(of, "nomat: cookie = ");
   prcook( cookie );
   fprintf(of,  " )\n" );
   fwalk( p, eprint, 0 );
  }
  cerror( "no table entry for op %s", opst[p->in.op] );
 case SCONV:
  if(p->in.type == UNDEF) { /* cast to void */
   p->in.type = INT;
   goto again;
  }
  if(p->in.left->in.op == REG)
   if((p->in.left->in.rall & ~MUSTDO) == p->in.left->tn.rval)
    goto nomat;
  order(p->in.left, INAREG);
  goto again;
 case PCONV:
  if(p->in.type == UNDEF) { /* cast to void */
   p->in.type = INT;
   goto again;
  }
  if(p->in.left->in.op = REG)
   if( isbreg(p->in.left->tn.rval) )
    goto nomat;
  order(p->in.left, INBREG);
  goto again;
 case COMOP:
  codgen( p1, FOREFF );
  p2->in.rall = p->in.rall;
  codgen( p2, cookie );
  ncopy( p, p2 );
  p2->in.op = FREE;
  goto cleanup;
 case FORCE:
 case FORCE1:
  { int forcereg;
   forcereg = (m == FORCE) ? R0 : R1;
   p1->in.rall = forcereg;
   order(p1, INTAREG|INTBREG);
   if(p1->tn.rval != forcereg) {
    p1->in.rall = forcereg | MUSTDO;
    order(p1, INTAREG|INTBREG);
   }
   ncopy(p, p1);
   p1->in.op = FREE;
   goto cleanup;
  }
 case CBRANCH:
  o = p2->tn.lval;
  cbranch( p1, -1, o );
  p2->in.op = FREE;
  p->in.op = FREE;
  return;
 case QUEST:
   { int svrall;
  cbranch( p1, -1, m=getlab() );
  p2->in.left->in.rall = p->in.rall;
  codgen( p2->in.left, INTAREG|INTBREG );
  /* force right to compute result into same reg used by left */
  svrall = p2->in.left->tn.rval;
  reclaim( p2->in.left, RNULL, 0 );
  cbgen( 0, m1 = getlab(), 'I' );
  deflab( m );
  p2->in.right->in.rall = svrall;
  codgen( p2->in.right, INTAREG|INTBREG );
  if(p2->in.right->tn.rval != svrall) {
   p2->in.right->in.rall = svrall | MUSTDO;
   order(p2->in.right, INAREG|INBREG);
  }
  deflab( m1 );
  p->in.op = REG;  /* set up node describing result */
  p->tn.lval = 0;
  p->tn.rval = p2->in.right->tn.rval;
  p->in.type = p2->in.right->in.type;
  tfree( p2->in.right );
  p2->in.op = FREE;
  goto cleanup;
   }
 case ANDAND:
 case OROR:
 case NOT:  /* logical operators */
  /* if here, must be a logical operator for 0-1 value */
  cbranch( p, -1, m=getlab() );
  p->in.op = CCODES;
  p->bn.label = m;
  order( p, INTAREG );
  goto cleanup;
 case FLD: /* fields of funny type */
  if ( p1->in.op == UNARY MUL ){
   offstar( p1->in.left );
   oreg2(p1);
   goto again;
  }
 case UNARY AND:
  if(p->in.op == UNARY AND && p->in.left->in.op == UNARY MUL) {
   int i;
   p1 = p->in.left->in.left;
   p->in.left->in.op = FREE;
   p->in.op = p1->in.op;
   p->in.rall = p1->in.rall;
   p->in.type = p1->in.type;
   p->in.su = p1->in.su;
   MVNAME(p->in.name, p1->in.name);
   p->in.left = p1->in.left;
   p->in.right = p1->in.right;
   p1->in.op = FREE;
   goto again;
  }
  goto nomat;
 case REG: /* need artificial stack register value */
  /* in a register.   */
  if(p->tn.rval <= R7)
   goto nomat;
  p1 = tcopy(p);
  p1->in.op = OREG;
  p1->in.type = DECREF(p1->in.type);
  p->in.op = UNARY AND;
  p->in.left = p1;
  p->tn.rval = 0;
  goto again;
 case UNARY MINUS:
  if( p->in.type == UNSIGNED ) {  /* band-aid for front end bug. */
   p->in.type = INT;
   goto again;
  }
  order( p1, INBREG|INAREG );
  goto again;
 case NAME:
  /* all leaves end up here ... */
  if( p->in.op == REG ) goto nomat;
  if( p->tn.lval < 0 || !ishalfcon(p->tn.lval) )
   if(setleaf(p)) goto again;
  order( p, INTAREG|INTBREG );
  goto again;
 case INIT:
  uerror( "illegal initialization" );
  return;
 case UNARY FORTCALL:
  p->in.right = NIL;
 case FORTCALL:
  if( genfcall( p, cookie ) ) goto nomat;
  goto cleanup;
 case UNARY CALL:
  p->in.right = NIL;
 case CALL:
  o = p->in.op = UNARY CALL;
  if( gencall( p, cookie ) ) goto nomat;
  goto cleanup;
 case UNARY STCALL:
  p->in.right = NIL;
 case STCALL:
  if( genscall( p, cookie ) ) goto nomat;
  goto cleanup;
  /* if arguments are passed in register, care must be
     taken that reclaim
    /* not throw away the register which now has the result... */
 case UNARY MUL:
  if( cook == FOREFF ){
   /* do nothing */
   order( p->in.left, FOREFF );   
   p->in.op = FREE;
   return;
  }
  order(p->in.left, INAREG|INBREG);
  oreg2(p);
  goto again;
 case INCR:  /* INCR and DECR */
  /* x++ becomes (x =+ 1) -1; */
  if( cook & FOREFF ){
     /* result not needed so inc or dec and be done with it */
   /* x++ => x =+ 1 */
   p->in.op = (p->in.op==INCR)?ASG PLUS:ASG MINUS;
   goto again;
  }
  p1 = tcopy(p);
  reclaim( p->in.left, RNULL, 0 );
  p->in.left = p1;
  p1->in.op = (p->in.op==INCR)?ASG PLUS:ASG MINUS;
  p->in.op = (p->in.op==INCR)?MINUS:PLUS;
  goto again;
 case STASG:
  if( setstr( p ) ) goto again;
  goto nomat;
 case ASG MUL:
 case ASG DIV:
  if( setmulop(p) ) goto again;
  /* there are assumed to be no side effects in LHS */
  p2 = tcopy(p);
  p->in.op = ASSIGN;
  reclaim( p->in.right, RNULL, 0 );
  p->in.right = p2;
  canon(p);
  rallo( p, p->in.rall );
  if( odebug ) fwalk( p, eprint, 0 );
  order( p2->in.left, INTBREG );
  order( p2, INTBREG|INTAREG );
  goto again;
 case ASG PLUS:  /* and other assignment ops */
 case ASG LS:
 case ASG RS:
  if( setasop(p) ) goto again;
  /* there are assumed to be no side effects in LHS */
  p2 = tcopy(p);
  p->in.op = ASSIGN;
  reclaim( p->in.right, RNULL, 0 );
  p->in.right = p2;
  canon(p);
  rallo( p, p->in.rall );
  if( odebug ) fwalk( p, eprint, 0 );
  order( p2->in.left, INTAREG|INTBREG );
  order( p2, INTBREG|INTAREG );
  goto again;
 case ASSIGN:
  if( setasg( p ) ) goto again;
  goto nomat;
 case BITYPE:
  if( setbin( p ) ) goto again;
  /* try to replace binary ops by =ops */
  switch(o){
  case PLUS:
  case MINUS:
  case MUL:
  case DIV:
  case MOD:
  case AND:
  case OR:
  case ER:
  case LS:
  case RS:
   if( istnode(p->in.left) ) {
    p->in.op = ASG o;
    goto again;
   }
  }
  goto nomat;
 }
cleanup:
 /* if it is not yet in the right state, put it there */
 --nrecur;
 if( cook & FOREFF ){
  reclaim( p, RNULL, 0 );
  return;
 }
 if( tshape( p, cook ) ) return;
 if( (m=match(p,cook) ) == MDONE ) return;
 /* we are in bad shape, try one last chance */
 if( lastchance( p, cook ) ) goto again;
 goto nomat;
}
int callflag;
int fregs;
store( p ) register NODE *p;
{
 /* find a subtree of p which should be stored */
 register o, ty;
 NODE *temp;
 if(udebug) {
  fprintf(of, "store(%x)\n", p);
 }
 o = p->in.op;
 ty = optype(o);
 if( ty == LTYPE ) return;
 if( ty == UTYPE || o==ANDAND || o==OROR || o==QUEST || o==COMOP ||
                    o==CBRANCH ) {
  if( o == UNARY CALL || o == UNARY FORTCALL || o == UNARY STCALL )
     ++callflag;
  else if( o == UNARY MUL && asgop(p->in.left->in.op) )
           stoasg( p->in.left, UNARY MUL );
  else if( (o==QUEST || o==COMOP) && p->in.right->in.su>fregs )
           SETSTO(p,INTEMP);
  if (ty != UTYPE){
     /*  fix problem of calls within ? and && ops - jrr */
   temp = stotree;
   store(p->in.right);
   if (stotree != temp)
    SETSTO(p, INTEMP);
  }
  store( p->in.left );
  return;
 }
 if( o == CALL || o == FORTCALL || o == STCALL ){ /*  special case */
  store( p->in.left);
  stoarg( p->in.right, o );
  ++callflag;
  return;
 }
 if( asgop( p->in.right->in.op ) ) stoasg( p->in.right, o );
 if( p->in.su>fregs ){ /* must store */
  mkadrs( p );  /* set up stotree and stocook to subtree
       that must be stored */
 }
 store( p->in.right );
 store( p->in.left );
}
setsto( p, cookie ) register NODE *p;
{
 /* SETSTO macro invokes this routine */
 if(udebug) {
  fprintf(of, "setsto(%x, ", p);
  prcook(cookie);
  fprintf(of, ")\n" );
 }
 stotree = p;
 stocook = cookie;
}
stoarg( p, calltype ) register NODE *p;
{
 /* arrange to store the args */
 if(udebug) {
  fprintf(of, "stoarg(%x, calltype=%d)\n", p, calltype);
 }
 if( p->in.op == CM ){
  stoarg( p->in.left, calltype );
  p = p->in.right ;
 }
 if( calltype == CALL ){
  STOARG(p);
 }
 else if( calltype == STCALL ){
  STOSTARG(p);
 }
 else {
  STOFARG(p);
 }
 callflag = 0;
 store(p);
 if( callflag ){ /* prevent two calls from being active at once  */
  SETSTO(p,INTEMP);
  store(p); /* do again to preserve bottom up nature....  */
 }
}
int negrel[]  = {
 NE, EQ, GT, GE, LT, LE, UGT, UGE, ULT, ULE }
;  /* negatives of relationals */
cbranch( p, true, false ) NODE *p;
{
 /* evaluate p for truth value, and branch to true or false
  /* accordingly: label <0 means fall through */
 register o, lab, flab, tlab;
 lab = -1;
 switch( o=p->in.op ){
 case ULE:
 case ULT:
 case UGE:
 case UGT:
 case EQ:
 case NE:
 case LE:
 case LT:
 case GE:
 case GT:
  if( true < 0 ){
   o = p->in.op = negrel[ o-EQ ];
   true = false;
   false = -1;
  }
  if( p->in.right->in.op == ICON &&
      p->in.right->tn.lval == 0 && p->in.right->in.name[0] == '\0' ){
   switch( o ){
   case UGT:
   case ULE:
    o = p->in.op = (o==UGT)?NE:EQ;
   case EQ:
   case NE:
   case LE:
   case LT:
   case GE:
   case GT:
    if( logop(p->in.left->in.op) ){
     /* strange situation: e.g., (a!=0) == 0 */
     /* must prevent reference to p->in.left->lable, so get 0/1 */
     /* we could optimize, but why bother */
     codgen( p->in.left, INAREG|INBREG );
    }
    codgen( p->in.left, FORCC );
    cbgen( o, true, 'I' );
    break;
   case UGE:
    cbgen( 0, true, 'I' );  /* unconditional branch */
   case ULT:
    ;   /* do nothing for LT */
   }
  }
  else {
   p->bn.label = true;
   codgen( p, FORCC );
  }
  if( false>=0 ) cbgen( 0, false, 'I' );
  reclaim( p, RNULL, 0 );
  return;
 case ANDAND:
  lab = false<0 ? getlab() : false ;
  cbranch( p->in.left, -1, lab );
  cbranch( p->in.right, true, false );
  if( false < 0 ) deflab( lab );
  p->in.op = FREE;
  return;
 case OROR:
  lab = true<0 ? getlab() : true;
  cbranch( p->in.left, lab, -1 );
  cbranch( p->in.right, true, false );
  if( true < 0 ) deflab( lab );
  p->in.op = FREE;
  return;
 case NOT:
  cbranch( p->in.left, false, true );
  p->in.op = FREE;
  break;
 case COMOP:
  codgen( p->in.left, FOREFF );
  p->in.op = FREE;
  cbranch( p->in.right, true, false );
  return;
 case QUEST:
  flab = false<0 ? getlab() : false;
  tlab = true<0 ? getlab() : true;
  cbranch( p->in.left, -1, lab = getlab() );
  cbranch( p->in.right->in.left, tlab, flab );
  deflab( lab );
  cbranch( p->in.right->in.right, true, false );
  if( true < 0 ) deflab( tlab);
  if( false < 0 ) deflab( flab );
  p->in.right->in.op = FREE;
  p->in.op = FREE;
  return;
 default:
  /* get condition codes */
  codgen( p, FORCC );
  if( true >= 0 ) cbgen( NE, true, 'I' );
  if( false >= 0 ) cbgen( true >= 0 ? 0 : EQ, false, 'I' );
  reclaim( p, RNULL, 0 );
  return;
 }
}
rcount(){ /* count recursions */
 if( ++nrecur > NRECUR ){
  cerror( "expression too hard for compiler: simplify!" );
 }
}
eprint( p, down, a, b ) NODE *p;
int *a, *b;
{
 *a = *b = down+1;
 while( down >= 2 ){
  fprintf(of,  "\t" );
  down -= 2;
 }
 if( down-- ) fprintf(of,  "    " );
 fprintf(of,  "%x) %s", p, opst[p->in.op] );
 switch( p->in.op ) { /* special cases */
 case REG:
  fprintf(of,  " %s", rnames[p->tn.rval] );
  break;
 case ICON:
 case NAME:
  fprintf(of,  " " );
  acon( p );
  break;
 case OREG:
  fprintf(of,  " " );
  adrput( p );
  break;
 case STCALL:
 case UNARY STCALL:
 case STARG:
 case STASG:
  fprintf(of,  " size=%d", p->stn.stsize );
  fprintf(of,  " align=%d", p->stn.stalign );
  break;
 }
 fprintf(of,  ", " );
 tprint( p->in.type );
 fprintf(of,  ", " );
 if( p->in.rall == NOPREF ) fprintf(of,  "NOPREF" );
 else {
  if( p->in.rall & MUSTDO ) fprintf(of,  "MUSTDO " );
  else fprintf(of,  "PREF " );
  fprintf(of,  "%s", rnames[p->in.rall&~MUSTDO]);
 }
 fprintf(of,  ", SU= %d\n", p->in.su );
}
#ifndef NOMAIN
NODE *
eread(){
 /* call eread recursively to get subtrees, if any */
 NODE *p;
 int i, c;
 char *pc;
 int j;
 i = rdin( 10 );
 p = talloc();
 p->in.op = i;
 i = optype(i);
 if( i == LTYPE ) p->tn.lval = rdin( 10 );
 if( i != BITYPE ) p->tn.rval = rdin( 10 );
 p->in.type = rdin(8 );
 p->in.rall = NOPREF;  /* register allocation information */
 if( p->in.op == STASG  || p->in.op == STARG ||
     p->in.op == STCALL || p->in.op == UNARY STCALL ){
  p->stn.stsize = (rdin( 10 ) + (SZCHAR-1) )/SZCHAR;
  p->stn.stalign = rdin(10) / SZCHAR;
  if( getc(infc) != '\n' ) cerror( "illegal \n" );
 }
 else {   /* usual case */
  if( p->in.op == REG ) rbusy( p->tn.rval, p->in.type );
      /* non usually, but sometimes justified */
  for( pc=p->in.name,j=0; ( c = getc(infc) ) != '\n'; ++j ){
   if( j < NCHNAM ) *pc++ = c;
  }
  if( j < NCHNAM ) *pc = '\0';
 }
 /* now, recursively read descendents, if any */
 if( i != LTYPE ) p->in.left = eread();
 if( i == BITYPE ) p->in.right = eread();
 return( p );
}
CONSZ
rdin( base ){
 register sign, c;
 CONSZ val;
 sign = 1;
 val = 0;
 while( (c=getc(infc)) > 0 ) {
  if( c == '-' ){
   if( val != 0 || sign != 1 ) cerror( "illegal -");
   sign = -sign;
   continue;
  }
  if( c == '\t' ) break;
  if( c>='0' && c<='9' ) {
   val = val*base + sign*(c - '0');
   continue;
  }
  cerror( "illegal character `%c' on intermediate file", c );
  break;
 }
 if( c <= 0 ) {
  cerror( "unexpected EOF");
 }
 return( val );
}
#endif
#ifndef FIELDOPS
/* do this if there is no special hardware support for fields */
ffld( p, down, down1, down2 ) NODE *p;
int *down1, *down2;
{
 /* look for fields that are not in an lvalue context, and
     rewrite them... */
 register NODE *shp, *pleft;
 register s, o, v;
 *down1 =  asgop( p->in.op );
 *down2 = 0;
 if( !down && p->in.op == FLD ){ /* rewrite the node */
  if( !rewfld(p) ) return;
  v = p->tn.rval;
  s = UPKFSZ(v);
  o = SZINT - s - UPKFOFF(v);  /* amount to shift */
  /* make & mask part */
  v = p->in.type;
  pleft = p->in.left;
  /*Mask needed ? */
  if((v==CHAR || v==UCHAR) && o+s==SZCHAR)
   /* No Mask Needed */
   shp = p;
  else{
   p->in.op = AND;
   p->in.right = talloc();
   p->in.right->in.op = ICON;
   p->in.right->in.rall = NOPREF;
   p->in.right->in.type = INT;
   p->in.right->tn.lval = 1;
   p->in.right->tn.rval = 0;
   MVNAME(p->in.right->in.name, "");
   p->in.right->tn.lval <<= s;
   p->in.right->tn.lval--;
   shp = 0;
  }
  /* now, if a shift is needed, do it */
  if( o != 0 ){
   if(!shp){
    shp = talloc();
    p->in.left = shp;
   }
   shp->in.op = RS;
   shp->in.rall = NOPREF;
   shp->in.type = INT;
   shp->in.left = pleft;
   shp->in.right = talloc();
   shp->in.right->in.op = ICON;
   shp->in.right->in.rall = NOPREF;
   shp->in.right->in.type = INT;
   shp->in.right->tn.rval = 0;
   shp->in.right->tn.lval = o;  /* amount to shift */
   MVNAME(shp->in.right->in.name, "");
   /* whew! */
  }
  p->in.type = v;
 }
}
#endif
oreg2( p ) register NODE *p;
{
 /* look for situations where we can turn * into OREG */
 NODE *q;
 register i;
 register r;
 register char *cp;
 NODE *tp;
 CONSZ temp;
 if( p->in.op == UNARY MUL ){
  q = p->in.left;
  if( q->in.op == REG ){
   temp = q->tn.lval;
   r = q->tn.rval;
   cp = "";
   goto ormake;
  }
  if(q->in.op==PLUS && q->in.right->in.op==REG &&
     q->in.left->in.op==ICON){
   tp = q->in.right;
   q->in.right = q->in.left;
   q->in.left = tp;
  }
  if( (q->in.op==PLUS || q->in.op==MINUS) &&
       q->in.right->in.op == ICON&& q->in.left->in.op == REG ){
   temp = q->in.right->tn.lval;
   if( q->in.op == MINUS ) temp = -temp;
   r = q->in.left->tn.rval;
   temp += q->in.left->tn.lval;
   cp = q->in.right->in.name;
   if( *cp && q->in.op == MINUS ) return;
ormake:
   if( notoff( p->in.type, r, temp, cp ) ) return;
   p->in.op = OREG;
   p->tn.rval = r;
   p->tn.lval = temp;
   MVNAME(p->in.name, cp);
   tfree(q);
   return;
  }
 }
}
canon(p) NODE *p;
{
 /* put p in canonical form */
 int oreg2(), sucomp();
#ifndef FIELDOPS
 int ffld();
 fwalk( p, ffld, 0 ); /* look for field operators */
# endif
 walkf( p, oreg2 );  /* look for and create OREG nodes */
 walkf( p, sucomp );  /* do the Sethi-Ullman computation */
}
