/* order.c */

/* %M% %I% %H% SCCS comment line. Leave it alone. */
# include "mfile2.h"
int maxargs = {
 -1 };
stoasg( p, o ) register NODE *p;
{
 /* should the assignment op p be stored,
      given that it lies as the right operand of o
      (or the left, if o==UNARY MUL) */
 if(udebug) {
  fprintf(of, "stoasg(%x, o=%d)\n", p, o);
 }
 if( p->in.op == INCR || p->in.op == DECR ) return;
 if( o==UNARY MUL && p->in.left->in.op == REG &&
     !isbreg(p->in.left->tn.rval) ) SETSTO(p,INAREG);
}
mkadrs(p) register NODE *p;
{
 register o;
 if(udebug) {
  fprintf(of, "mkadrs(%x)\n", p);
 }
 o = p->in.op;
 if( asgop(o) ){
  if( p->in.left->in.su >= p->in.right->in.su ){
   if( p->in.left->in.op == UNARY MUL ){
    SETSTO( p->in.left->in.left, INTEMP );
   }
   else if( p->in.left->in.op == FLD &&
            p->in.left->in.left->in.op == UNARY MUL ){
    SETSTO( p->in.left->in.left->in.left, INTEMP );
   }
   else { /* should be only structure assignment */
    SETSTO( p->in.left, INTEMP );
   }
  }
  else SETSTO( p->in.right, INTEMP );
 }
 else {
  if( p->in.left->in.su > p->in.right->in.su ){
   SETSTO( p->in.left, INTEMP );
  }
  else {
   SETSTO( p->in.right, INTEMP );
  }
 }
}
notoff( t, r, off, cp) CONSZ off;
char *cp;
{
 /* is it legal to make an OREG or NAME entry which has an
   /* offset of off, (from a register of r), if the
   /* resulting thing had type t */
 if(off < 0 || !ishalfcon(off)) return(1); /* illegal offset */
 switch( r ){
 case 1:
 case 2:
 case 3:
 case AUTO_P:
 case ARG_P:
 case TMP_P:
 case CALL_P:
  return( 0 ); /* YES */
 }
 return( 1 ); /* NO */
}
# define max(x,y) ((x)<(y)?(y):(x))
sucomp( p ) NODE *p;
{
 /* set the su field in the node to the sethi-ullman
      number, or local equivalent */
 register o, ty, sul, sur;
 int t, mt, mf;
 t = p->in.type;
 o = p->in.op;
 ty = optype( o );
 p->in.su = 1;
 if( o==OREG && istreg( p->tn.rval ) ) p->in.su = 2;
 if( ty == LTYPE ) return;
 else if( ty == UTYPE ){
  switch( o ) {
  case UNARY CALL:
  case UNARY FORTCALL:
  case UNARY STCALL:
   p->in.su = fregs;  /* all regs needed */
   return;
  case SCONV:
   mt = t == FLOAT || t == DOUBLE;
   mf  = p->in.left->in.type == FLOAT || p->in.left->in.type == DOUBLE;
   if (mt != mf || t == LONG || t == DOUBLE){
    p->in.su = fregs;
    return;
   }
  default:
   p->in.su = max( p->in.left->in.su, 1);
   return;
  }
 }
 /* If rhs needs n, lhs needs m, regular su computation */
 sul = p->in.left->in.su;
 sur = p->in.right->in.su;
 if( o == ASSIGN ){
  /* computed by doing right, then left(if not in mem), then doing it */
  p->in.su = max(sur,sul+1);
  return;
 }
 if( o == CALL || o == STCALL || o == FORTCALL ){
  /* in effect, takes all free registers */
  p->in.su = fregs;
  return;
 }
 if( o == STASG ){
  /* right, then left */
  p->in.su = max( max( 1+sul, sur), fregs );
  return;
 }
 if( asgop(o) ){
  /* computed by doing right, doing left address, doing left,
     op, and store */
  p->in.su = max(sur,sul+2);
  if (t == LONG || t == DOUBLE || p->in.left->in.op == UNARY MUL)
   p->in.su = max(p->in.su, sur+1); /* address computed first */
  if (p->in.type != FLOAT)
   if( o==ASG MUL || o==ASG DIV || o==ASG MOD || t == LONG ||
      t == DOUBLE)
    p->in.su = max(p->in.su,fregs);
  return;
 }
 switch( o ){
 case ANDAND:
 case OROR:
 case QUEST:
 case COLON:
 case COMOP:
  p->in.su = max( max(sul,sur), 1);
  return;
 }
 /* binary op, computed by left, then right, then do op */
 p->in.su = max(sul,1+sur);
 if (p->in.type != FLOAT)
  if( o==MUL||o==DIV||o==MOD || t == LONG || t == DOUBLE)
   p->in.su = max(p->in.su,fregs);
}
rallo( p, down ) NODE *p;
{
 /* do register allocation */
 register o, type, down1, down2, ty;
 int mt, mf;
 if( radebug ) {
  fprintf(of,  "rallo( %x, ", p );
  if( down == NOPREF ) fprintf(of,  "NOPREF" );
  else {
   if( down & MUSTDO ) fprintf(of,  "MUSTDO " );
   else fprintf(of,  "PREF " );
   fprintf(of,  "%s", rnames[down&~MUSTDO]);
  }
  fprintf(of, " )\n");
 }
 down2 = NOPREF;
 p->in.rall = down;
 down1 = ( down &= ~MUSTDO );
 ty = optype( o = p->in.op );
 type = p->in.type;
 switch (o) {
 case SCONV:
  mt = (type == FLOAT) || (type == DOUBLE);
  mf = (p->in.left->in.type == FLOAT)||(p->in.left->in.type == DOUBLE);
  if (mt != mf){
   if (type == LONG || type == DOUBLE)
    down1 = R0|MUSTDO;
   else
    down1 = R1|MUSTDO;
  }
  else if (type == LONG)
   down1 = R1|MUSTDO;
  else if (type == DOUBLE)
   down1 = R0|MUSTDO;
  goto ral;
  break;
 case FORCE:
  down1 = R0|MUSTDO;
  break;
 case FORCE1:
  down1 = R1|MUSTDO;
  break;
 case UNARY MUL:
  down1 = R2; /* preference */  /* mjp mod */
  break;
 }
 switch (type){
 case FLOAT:
  break;
 case LONG:
 case DOUBLE:
  if (asgop(o)){
   if (p->in.left->in.op == UNARY MUL){
    rallo(p->in.left->in.left, R2|MUSTDO);
    rallo(p->in.right, R0|MUSTDO);
    return;
   }
  }
  if (o == CALL || o == STCALL || o == FORTCALL) {
   down1 = NOPREF;
   goto ral;
  }
  if (ty == BITYPE){
   down1 = R0|MUSTDO;
   if (o == ASG LS || o == ASG RS) down2 = R2|MUSTDO;
/* if (p->in.right->in.op == UNARY MUL) {    this block by mjp   
    rallo(p->in.right->in.left, R2|MUSTDO);
    rallo(p->in.left, R0|MUSTDO);
    return;
   } */
  }
  goto ral;
 default:
  switch( o ) {
  case ASSIGN:
   down1 = NOPREF;
   down2 = down;
   break;
  case DIV:
  case MOD:
   down2 = R2;
  case MUL:
   down1 = R1;
   break;
  case ASG MUL:
  case ASG DIV:
  case ASG MOD:
   if( p->in.left->in.op == FLD  &&
       p->in.left->in.left->in.op == UNARY MUL ){
    rallo( p->in.left->in.left->in.left, R2 );
   }
   if (p->in.left->in.op == UNARY MUL){
    rallo( p->in.left->in.left, R2);
    p->in.left->in.rall = R1;
    rallo( p->in.right,  R1);
    return;
   }
   else if (p->in.left->in.op == REG){
    down2 = R2;
    break;
   }
   else{
    down1 = R1;
    break;
   }
  case CALL:
  case FORTCALL:
   down1 = R1|MUSTDO;
   break;
  case STASG:
  case EQ:
  case NE:
  case GT:
  case GE:
  case LT:
  case LE:
  case NOT:
  case ANDAND:
  case OROR:
   down1 = NOPREF;
   break;
  }
 }
ral:
 if( ty != LTYPE ) rallo( p->in.left, down1 );
 if( ty == BITYPE ) rallo( p->in.right, down2 );
}
offstar( p ) NODE *p;
{
 register t;
 t = p->in.type;
 if (xdebug)
  fprintf(of, "Offstar %x), op = %d, type = %d\n",
           p, p->in.op, p->in.type);
 if( p->in.op == PLUS ){
  if( p->in.right->in.op == ICON ){
   if(!ishalfcon(p->in.right->tn.lval)) {
    order(p, INTBREG|INBREG);
    return(1);
   }
   if( tshape(p->in.left, SBREG) )
    return(0);
   else {
    order( p->in.left , INTBREG|INBREG );
    return(1);
   }
  }
 }
 /*
   * The following code is commented out to avoid
   * generating indirection in base register mode.
   *
  * if (ISPTR(t)){
   *  switch(DECREF(t)){
   *  case INT:
   *  case FLOAT:
   *   switch( p->in.op ){
   *   case NAME:
   *   case ICON:
   *   case OREG:
   *    return(0);  don't put it in a reg
   *   }
   *  }
   * }
   */
 order( p, INTBREG|INBREG);
 return(1);
}
setbin( p ) register NODE *p;
{
 register ro;
 ro = p->in.right->in.op;
 if( !istnode( p->in.left) ) { /* try putting LHS into a reg */
  order( p->in.left, INAREG);
  return(1);
 }
 else if( ro == UNARY MUL){
  order( p->in.right, INAREG);
  return(1);
 }
 else {
  switch( ro ){
  case REG:
  case ICON:
  case NAME:
  case OREG:
   break;
  default:
   order( p->in.right, INAREG);
   return(1);
  }
 }
 return(0);
}
setstr( p ) register NODE *p;
{ /* structure assignment */
 if( p->in.right->in.op != REG ){
  order( p->in.right, INTBREG );
  return(1);
 }
 if( !isbreg(p->in.right->tn.rval) ) {
  order( p->in.right, INTBREG );
  return(1);
 }
 p = p->in.left;
 if( p->in.op != NAME && p->in.op != OREG ){
  if( p->in.op != UNARY MUL ) cerror( "bad setstr" );
  order( p->in.left, INTBREG );
  return( 1 );
 }
 return( 0 );
}
setasg( p ) register NODE *p;
{
 /* setup for assignment operator */
 NODE *pleft, *p1, *p2, *p3;
 if( p->in.right->in.op != REG ){
  order( p->in.right, INAREG|INBREG );
  return(1);
 }
 pleft = p->in.left;
 if(pleft->in.op == NAME) {
  p3 = tcopy(pleft);
  p3->in.op = ICON;
  p3->in.type = INCREF(pleft->in.type);
  p3->tn.lval = 0;
  p3->tn.rval = 0;
  p2 = tcopy(pleft);
  p2->in.op = ICON;
  p2->in.type = INT;
  MVNAME(p2->in.name, "");
  p2->tn.rval = 0;
  /* p2->tn.lval has original constant */
  p1 = tcopy(p3);
  p1->in.op = PLUS;
  p1->in.left = p3;
  p1->in.right = p2;
  pleft->in.op = UNARY MUL;
  MVNAME(pleft->in.name, "");
  pleft->in.left = p1;
  pleft->tn.rval = 0;
  order(p1, INBREG|INTBREG);
  oreg2(pleft);
  return(1);
 }
 if( p->in.left->in.op == UNARY MUL ) {
  offstar( p->in.left->in.left );
  oreg2(p->in.left);
  return(1);
 }
 if( p->in.left->in.op == FLD &&
     p->in.left->in.left->in.op == UNARY MUL ){
  offstar( p->in.left->in.left->in.left );
  oreg2(p->in.left->in.left);
  return(1);
 }
 return(0);
}
setdouble( p ) register NODE *p;
{
 /* setup for asg ops on doubles */
 /* get right in temp and left in */
 /* reg, as 32/27 has no reg-to-reg */
 /* floating point instructions.    */
 int ro, lo;
 NODE *p2, t;
 if(xdebug) fprintf(of, "setdouble(%x)\n", p);
 ro = p->in.right->in.op;
 lo = p->in.left->in.op;
 if(ro != NAME && ro != OREG && ro != ICON) {
  order(p->in.right, INTEMP);
  return(1);
 }
 if(ro == OREG && p->tn.rval == R1) {
  /* Move R1 to another register, as */
  /* R0,R1 pair will probably be needed. */
  p2 = tcopy(p->in.left);
  p2->in.op = REG;
  order(p2, INBREG);
  p->in.left->tn.rval = p2->tn.rval;
  reclaim(p2, RNULL, 0);
  return(1);
 }
 if(lo == UNARY MUL) {
  offstar(p->in.left->in.left);
  oreg2(p->in.left);
  if(p->in.left->in.op != OREG) {
   cerror("setdouble: cant reduce U*");
  }
  return(1);
 }
 if(lo != REG) {
  /* 1. rewrite as left = left op= right; */
  /* 2. get middle part in register pair */
  /* 3. go again    */
  p2 = tcopy(p);
  p->in.op = ASSIGN;
  reclaim(p->in.right, RNULL, 0);
  p->in.right = p2;
  order(p2->in.left, INAREG);
  return(1);
 }
 cerror("illegal setdouble");
 return(0); /* shut up warnings */
}
setmulop( p ) register NODE *p;
{
 /* setup for *= /= %= ops */
 /* objective is to get left side in r1 */
 int ro, lo;
 NODE *p2, *t;
 if(xdebug) fprintf(of, "setmulop(%x)\n", p);
 if( ttype(p->in.type, TDOUBLE) )
  return(setdouble(p));
 ro = p->in.right->in.op;
 lo = p->in.left->in.op;
 if(ro != REG && ro != OREG && ro != NAME && ro != ICON) {
  p->in.right->in.rall = R4; /* prefer R4 */
  order(p->in.right, INAREG|INBREG);
  return(1);
 }
 if(ro == OREG && p->in.right->tn.rval == R1) {
  p->in.right->in.rall = R4; /* prefer R4 */
  order(p->in.right, INAREG|INBREG);
  return(1);
 }
 if( lo == UNARY MUL) {
  offstar(p->in.left->in.left);
  oreg2(p->in.left);
  if( p->in.left->in.op != OREG ) {
   cerror("setmulop: cant reduce U*");
  }
  return(1);
 }
 /* now there are no side effects in either side */
 if( lo == OREG && p->in.left->tn.rval == R1 ) {
  /* move R1 to another register */
  /* and update tree acordingly */
  p2 = tcopy(p->in.left);
  p2->in.op = REG;
  order(p2, INAREG);
  p->in.left->tn.rval = p2->tn.rval;
  reclaim(p2, RNULL, 0);
  return(1);
 }
 if(lo != REG || p->in.left->tn.rval != R1) {
  /* rewrite as left = left *= right; */
  p2 = tcopy(p);
  p->in.op = ASSIGN;
  reclaim(p->in.right, RNULL, 0);
  p->in.right = p2;
  ++busy[R0]; /* Make R0 busy temporarily */
  if(p2->in.right->in.op == REG && p2->in.right->tn.rval == R1) {
   /* move it to another register, NOT R0 !!! */
   p2->in.right->in.rall = R4; /* prefer R4 */
   order(p2->in.right, INAREG|INBREG);
  }
  /* do it as:  R1 = left; left = R1 op= right; */
  p2->in.left->in.rall = MUSTDO|R1;
  order(p2->in.left, INAREG|INBREG);
  --busy[R0]; /* Restore original state of R0 */
  if(p2->in.right->in.op == REG && p2->in.right->tn.rval == R0) {
   p2->in.right->in.rall = R4; /* prefer R4 */
   order(p2->in.right, INAREG|INBREG);
  }
  if(busy[R0]) {
   --busy[R0];
   order(p2, INAREG);
   ++busy[R0];
  }
  return(1);
 }
 /* Left is now in R1, but match failed.  */
 /* Try putting right in a register  */
 if(ro != REG) {
  p->in.right->in.rall = R4; /* prefer R4 */
  order(p->in.right, INAREG);
  return(1);
 }
 /* Last chance: maybe R0 was the right side of a  */
 /* div or mod op, which isn't allowed.     */
 if(ro == REG && p->in.right->tn.rval == R0) {
  p->in.right->in.rall = R4; /* prefer R4 */
  order(p->in.right, INAREG|INBREG);
  return(1);
 }
 cerror("setmulop: cant match R1 op= something");
 return(0); /* shut up warnings */
}
setasop( p ) register NODE *p;
{
 /* setup for =ops */
 NODE *pr, *pl;
 int o;
 register ro, t;
 if (xdebug) fprintf(of, "Setasop %x)\n", p);
 if( ttype(p->in.type, TDOUBLE) )
  return(setdouble(p));
 ro = p->in.right->in.op;
 if(ro == UNARY MUL) {
  offstar(p->in.right->in.left);
  oreg2(p->in.right);
  if(p->in.right->in.op != OREG) /* Cant, so put it in a reg. */
   order(p->in.right, INAREG|INTAREG);
  return(1);
 }
 if(ro != ICON && ro != NAME && ro != OREG && ro != REG) {
  order(p->in.right, INAREG|INTAREG);
  return(1);
 }
 p = p->in.left;
 if( p->in.op == FLD )   p = p->in.left;
 switch(p->in.op) {
 case REG:
 case ICON:
 case NAME:
 case OREG:
  return(0);
 case UNARY MUL:
  offstar(p->in.left);
  oreg2(p);
  return(1);
 }
 cerror("illegal setasop");
 return(0); /* shut up warnings */
}
setleaf( p ) register NODE *p;
{
 NODE *p2, *p3;
 switch(p->in.op) {
 case ICON:
 case REG:
  return(0);
 case NAME:
  p3 = tcopy(p);
  p3->tn.lval = 0;
  p3->tn.rval = 0;
  p2 = tcopy(p3);
  p2->in.op = UNARY AND;
  p2->in.type = INCREF(p3->in.type);
  p2->in.left = p3;
  p2->in.right = p2;
  p3 = tcopy(p);
  p3->in.op = ICON;
  p3->in.type = INT;
  MVNAME(p3->in.name, "");
  p3->tn.rval = 0;
  /* p3->tn.lval has original offset */
  p->in.op = PLUS;
  p->in.type = p2->in.type;
  p->in.left = p2;
  p->in.right = p3;
  break;
 case OREG:
  p->in.type = INCREF(p->in.type);
  p2 = talloc();
  p2->in.op = REG;
  p2->in.type = p->in.type;
  p2->tn.lval = 0;
  p2->tn.rval = p->tn.rval;
  p3 = talloc();
  p3->in.op = ICON;
  p3->in.type = INT;
  MVNAME(p3->in.name, "");
  p3->tn.lval = p->tn.lval;
  p3->tn.rval = 0;
  p->in.op = PLUS;
  p->in.left = p2;
  p->in.right = p3;
  break;
 }
 order(p, INBREG);
 p->in.op = OREG;
 p2->in.type = DECREF(p->in.type);
 return(1);
}
ascomop( o ){
 return( o == ASG PLUS || o == ASG AND || o == ASG OR || o == ASG ER);
}
int crslab = 9999;  /* Honeywell */
getlab(){
 return( crslab-- );
}
deflab( l ){
 fprintf(of,  "L.%d equ $\n", l );
}
genargs( p, ptemp ) register NODE *p, *ptemp;
{
 register NODE *pasg;
 register align;
 register size;
 register TWORD type;
 /* generate code for the arguments */
 if(odebug) {
  fprintf(of, "Genargs, p = %x, ptemp = %x\n", p, ptemp);
  fwalk(p, eprint, 0);
  fwalk(ptemp, eprint, 0);
 }
 /*  first, do the arguments on the left */
 while( p->in.op == CM ){
  genargs( p->in.left, ptemp );
  p->in.op = FREE;
  p = p->in.right;
 }
 if( p->in.op == STARG ){ /* structure valued argument */
  size = p->stn.stsize;
  align = p->stn.stalign;
  SETOFF( ptemp->tn.lval, align );
  p->in.op = STASG;
  p->in.right = p->in.left;
  p->in.left = tcopy( ptemp );
  /* the following line is done only with the knowledge
      that it will be undone by the STASG node, with the
      offset (lval) field retained */
/*
 *  if( p->in.right->in.op == OREG ) p->in.right->in.op = REG;
 */
  order( p, FOREFF );
  ptemp->tn.lval += size;
  return;
 }
 /* ordinary case */
 pasg = talloc();
 pasg->in.op = ASSIGN;
 pasg->in.type = ptemp->in.type = p->in.type;
 pasg->in.right = p;
 type = p->in.type;
 if( type == FLOAT || type == DOUBLE || type == LONG ){
  align = 8;
  size = 8;
  ptemp->in.type = type;
 }
 else {
  align = 4;
  size = 4;
  ptemp->in.type = INT;
 }
 SETOFF( ptemp->tn.lval, align );
 pasg->in.rall = NOPREF;
 pasg->in.su = p->in.su;
 pasg->in.left = tcopy( ptemp );
 if(type == FLOAT)
  pasg->in.left->in.type = DOUBLE;
 order( pasg, FOREFF );
 ptemp->tn.lval += size;
}
argsize( p )
NODE *p;
{
 register t;
 t = 0;
 if( p->in.op == CM ){
  t = argsize( p->in.left );
  p = p->in.right;
 }
 if(p->in.type == DOUBLE || p->in.type == LONG || p->in.type == FLOAT){
  SETOFF( t, 8 );
  return( t+8 );
 }
 else if( p->in.op == STARG ){
  SETOFF( t, p->stn.stalign );  /* alignment */
  return( t + p->stn.stsize );  /* size */
 }
 else {
  SETOFF( t, 4 );
  return( t+4 );
 }
}
areg2( p ) register NODE *p;
{
 /* look for uses of dummy registers and put them under
    U& and U* nodes*/
 register NODE *p1, *p2;
 register ot;
 if ((p->in.op == PLUS || p->in.op == MINUS) &&
     (p->in.left->in.op == REG &&
      p->in.right->in.op == ICON && p->in.left->tn.rval >= 8)){
andmake:
  p1 = talloc();
  p2 = talloc();
  ncopy(p2,p);
  if(xdebug) fprintf(of, "p %x, p1 %x, p2 %x\n", p, p1, p2);
  p->in.op = UNARY AND;
  p->in.type = p2->in.type;
  p->in.left = p1;
  p1->in.op = UNARY MUL;
  p1->in.type = DECREF( p2->in.type );
  p1->in.left = p2;
  return;
 }
 else if (p->in.op == REG && p->tn.rval >= 8) goto andmake;
 else{
  ot = optype( p->in.op );
  if (ot != LTYPE) areg2( p->in.left );
  if (ot == BITYPE) areg2( p->in.right );
 }
}
