/* local.c */

# include "mfile1.h"
/* this file contains code which is dependent on the target machine */
#define ADDCON(x) { r=talloc(); \
   r->in.op=SCONV; \
   r->in.left=pleft; \
   r->in.right=NIL; \
   r->in.type = x; \
   p->in.left = r; \
   }
NODE *
clocal(p) NODE *p;
{
 /* this is called to do local transformations on
     an expression tree preparitory to its being
     written out in intermediate code.
  */
 /* the major essential job is rewriting the
     automatic variables and arguments in terms of
     REG and OREG nodes */
 /* conversion ops which are not necessary are also clobbered here */
 /* in addition, any special features (such as rewriting
     exclusive or) are easily handled here as well */
 register struct symtab *q;
 register NODE *r;
 register o;
 int t, t1;
 NODE *pleft;
 int eprint();
 o = p->in.op;
 switch( o ){
 case FLD:
  {
/*
 *   int sz, off;
 *
 *   sz = UPKFSZ(p->tn.rval);
 *   off = UPKFOFF(p->tn.rval);
 *
 *   if( (p->in.left->in.type==INT || p->in.left->in.type==UNSIGNED) &&
                                      andok(p->in.left) )
 *    if(off/SZCHAR == (off+sz-1)/SZCHAR)
 *     ofld(p, CHAR, SZCHAR);
 *    else if(off/SZSHORT == (off+sz-1)/SZSHORT)
 *     ofld(p, SHORT, SZSHORT);
 */
  }
  break;
 case NAME:
  if( p->tn.rval < 0 ) { /* already processed; ignore... */
   return(p);
  }
  q = &stab[p->tn.rval];
  switch( q->sclass ){
  case AUTO:
  case PARAM:
   /* fake up a structure reference */
   r = block( REG, NIL, NIL, PTR+STRTY, 0, 0 );
   r->tn.lval = 0;
   r->tn.rval = (q->sclass==AUTO?STKREG:ARGREG);
   p = stref( block( STREF, r, p, 0, 0, 0 ) );
   break;
  case ULABEL:
  case LABEL:
  case STATIC:
   if( q->slevel == 0 ) break;
   p->tn.lval = 0;
   p->tn.rval = -q->offset;
   break;
  case REGISTER:
   p->in.op = REG;
   p->tn.lval = 0;
   p->tn.rval = q->offset;
   break;
  }
  break;
 case PCONV:
  /* pointers all have the same representation; the type is inherited */
  p->in.left->in.type = p->in.type;
  p->in.left->fn.cdim = p->fn.cdim;
  p->in.left->fn.csiz = p->fn.csiz;
  p->in.op = FREE;
  return( p->in.left );
 case SCONV:
  if(xdebug && edebug) {
   printf("clocal(), case SCONV:\n");
   fwalk(p, eprint, 0);
  }
again:
  pleft = p->in.left;
  t = p->in.type;
  t1 = pleft->in.type;
  if(ISARY(t1)){
   p->in.left = buildtree(UNARY AND, p->in.left, NIL);
   goto again;
  }
  if(ISPTR(t)) t = INT;
  if(ISPTR(t1)) t1 = INT;
  /* Conversion from type t1 to type t */
  if(t==t1 || ( (t==INT || t==UNSIGNED) && (t1==INT || t1==UNSIGNED) ) )
   goto clob;
  if(t != LONG && t1 != LONG){
   if(pleft->in.op == FCON)
    if(t == FLOAT){
     pleft->fpn.dval = (float) pleft->fpn.dval;
     goto clob;
    }
    else if(t == DOUBLE)
     goto clob;
   else{
    pleft->tn.lval = pleft->fpn.dval;
    pleft->in.op = ICON;
    pleft->fn.csiz = INT;
    pleft->tn.rval = NONAME;
   }
   if(pleft->in.op == ICON)
    switch(t){
    case CHAR:
    case UCHAR:
     pleft->tn.lval &= 0377;
     goto clob;
    case USHORT:
     pleft->tn.lval &= 0xffff;
     goto clob;
    case SHORT:
     pleft->tn.lval = (short) pleft->tn.lval;
     goto clob;
    case UNSIGNED:
    case INT:
clob:
     pleft->in.type = p->in.type;
     pleft->fn.csiz = p->fn.csiz;
     p->in.op = FREE;
     return(pleft);
    case FLOAT:
    case DOUBLE:
     if(t1==UNSIGNED)
      pleft->fpn.dval = (double)(unsigned) pleft->tn.lval;
     else
      pleft->fpn.dval = (double) pleft->tn.lval;
     if(t == FLOAT) pleft->fpn.dval = (float) pleft->fpn.dval;
     pleft->in.op = FCON;
     goto clob;
    }
  }
  if((t==FLOAT || t==DOUBLE)^(t1==FLOAT || t1==DOUBLE))
   extflg |= (t==FLOAT || t1==FLOAT)? C_IF : C_LD;
  switch(t1){
  case DOUBLE:
   if(t==FLOAT || t==LONG) return(p);
   ADDCON(LONG);
   goto again;
  case FLOAT:
   if(t==DOUBLE || t==INT) return(p);
   if(t==LONG || t==UNSIGNED) {
    ADDCON(DOUBLE);
    goto again;
   }
   ADDCON(INT);
   goto again;
  case LONG:
   if(t==INT || t==DOUBLE ||t==UNSIGNED) return(p);
   if(t==FLOAT) {
    ADDCON(DOUBLE);
    goto again;
   }
   ADDCON(INT);
   goto again;
  case UNSIGNED:
   if(t==FLOAT || t==DOUBLE) {
    ADDCON(LONG);
    goto again;
   }
   return(p);
  default:
   if(t==DOUBLE) {
    ADDCON(LONG);
    goto again;
   }
   return(p);
  }
 case PVCONV:
 case PMCONV:
  if( p->in.right->in.op != ICON ) cerror( "bad conversion", 0);
  p->in.op = FREE;
  return( buildtree( o==PMCONV?MUL:DIV, p->in.left, p->in.right ) );
 case MUL:
 case DIV:
 case MOD:
 case ASG MUL:
 case ASG DIV:
 case ASG MOD:
  if (p->in.type == LONG) extflg |= C_LOP;
  break;
 case FORTCALL:
 case UNARY FORTCALL:
  extflg |= C_FCALL;
 case PLUS:
 case MINUS:
  if(nncon(p->in.right) && p->in.left->in.op == ICON){
   p->in.left->tn.lval +=
       (o==PLUS)? p->in.right->tn.lval : -(p->in.right->tn.lval);
   p->in.op = p->in.right->in.op = FREE;
   p->in.left->in.type = p->in.type;
   p->in.left->fn.csiz = p->fn.csiz;
   return(p->in.left);
  }
  break;
 case NE:
 case EQ:
  if(ISUNSIGNED(p->in.right->in.type))
   p->in.right = makety(p->in.right, INT);
  if(ISUNSIGNED(p->in.left->in.type))
   p->in.left = makety(p->in.left, INT);
  if(nncon(p->in.right) && p->in.left->in.op == FLD){
   int sz;
   int shft;
   sz = UPKFSZ(p->in.left->tn.rval);
   shft = SZINT - sz - UPKFOFF(p->in.left->tn.rval);
   if(p->in.right->tn.lval & ~((1<<sz)-1) ){
    werror("Constant is bigger than field");
    break;
   }
   p->in.left = noshftfld(p->in.left);
   p->in.right->tn.lval <<= shft;
  }
  break;
 }
 return(p);
}
andable( p ) NODE *p;
{
 return(1);  /* all names can have & taken on them ? */
}
cendarg(){ /* at the end of the arguments of a ftn, set
              the automatic offset */
 autooff = 0;
}
cisreg( t ){ /* is an automatic variable of type t OK for
                a register variable */
 if( t==INT || t==UNSIGNED || ISPTR(t) ) return(1);
 return(0);
}
NODE *
offcon( off, t, d, s ) OFFSZ off;
{
 /* return a node, for structure references, which is suitable for
     being added to a pointer of type t, in order to be off bits offset
     into a structure */
 register NODE *p;
 /* t, d, and s are the type, dimension offset, and sizeoffset */
 /* in general they  are necessary for offcon, but not on H'well */
 p = bcon(0L);
 p->tn.lval = off/SZCHAR;
 return(p);
}
#ifdef NBC
incode( p, sz ) register NODE *p;
{
 /* generate initialization code for assigning a constant c
   to a field of width sz */
 /* we assume that the proper alignment has been obtained */
 /* inoff is updated to have the proper final value */
 /* we also assume sz  < SZINT */
 if( idebug ) {
  printf("incode(%x, %d):\n", p, sz);
 }
 if( inoff%SZINT == 0 ){
  trparen();
  fprintf(curfc, " gen " );
 }
 fprintf(curfc, "%d/", sz );
 fprintf(curfc, CONFMT, p->tn.lval );
 inoff += sz;
 if( inoff%SZINT == 0 ) fprintf(curfc, "\n" );
 else fprintf(curfc, "," );
}
#else
/*
** Generate initialization code for assigning a constant c to a field
** of width sz.  We assume that the proper alignment has been obtained.
** inoff is updated to have the proper final value.
**
** The reason for such backflips is that this routine
** is used to initialize bitfields, as well as 'normal'
** types. We collect the data
** in 'word', and when we are at the end of the
** initialization, or inoff is on a byte boundary, we
** dump the data. For normal initialization, we dump
** the data at each call, since inoff will be at least
** byte aligned. In that case, we only go through the
** loop one time. For fields, we may collect data over
** several calls, and then dump the data.
*/
static int inwd;  /* curr offset in word */
static int word;  /* word being built */

void
incode(p, sz)
NODE	*p;
int	sz;
{
 int  onecon, tw1, tw2;
 int  oinoff = inoff;
 long	tlw;

 if( idebug ) {
  printf("incode(%x, %d):\n", p, sz);
 }

 onecon = 1L;
 tw1 = p->tn.lval;

 if( (sz/SZCHAR) >= sizeof(word) || inwd == 0)
  word = tw1;
 else
 {/*
  ** This is a direct conversion from the line:
  ** word = (word << sz) | (p->tn.lval & ((1L<<sz)-1));
  */
 word = (word << sz) | (p->tn.lval & ((1L<<sz)-1));
 }
 inwd += sz;
 inoff += sz;
 if((inoff % SZCHAR) == 0)        /* on at least a byte boundary */
  while(inwd >= SZCHAR)           /* and at least a byte to emit */
   {
   if (inwd >= SZINT && (oinoff % SZINT) == 0)     /* dump the word */
    {
    inwd -= SZINT;
    fprintf(curfc, " dataw %ld\n", word >> inwd);
    word &= ((1L << inwd) - 1L);
    }
   else if (inwd >= SZSHORT && (oinoff % SZSHORT) == 0)  /* dump a halfword */
    {
    inwd -= SZSHORT;
    fprintf(curfc, " datah %ld\n", (word >> inwd) & 0xffff);
    word &= ((1L << inwd) - 1L);
    }
   else
    {
    inwd -= SZCHAR;         /* remove a byte            */
    fprintf(curfc, " datab %ld\n", (word >> inwd) & 0xff);
    word &= ((1L << inwd) - 1L);
    }
   }
}
#endif /* NBC */

#define HEXVAL(x) (x+((x<10)?'0':'A'-10))
static hexpout(c) char c;
{
 fprintf(curfc, "%c%c", HEXVAL(c/16), HEXVAL(c%16) ) ;
 return(0) ;
}
fincode( d, sz ) double d;
{
 /* output code to initialize space of size sz to the value d */
 /* the proper alignment has been obtained */
 /* inoff is updated to have the proper final value */
 /* on the target machine, write it out in octal! */
 /* important not to print out exact integers in simple e format or
      the assembler will not give an exact result */
 char cd[32];
 register char *ep, *zp, *p;
 register exp;
 char sign;
 char minus;
 int nch,ctr ;
 union {
  double ddb ;
  char dch[8] ;
 }
 du ;
 if(idebug) {
  printf("fincode(%e, %d)\n", d, sz);
 }
 trparen();
 if(sz == SZDOUBLE)
 {
  fprintf(curfc, " datad X'") ;
  nch = 8 ;
 }
 else
 {
  fprintf(curfc, " dataw X'") ;
  nch = 4 ;
 }
 /*
 >>>>>> code for conversion to a decimal string is replaced by
        hex output
  if(d < 0){
   minus = '-';
   d = -d;
   }
  else
   minus = 0;

  sprintf(cd,"%.17e", d);

  for(ep=cd; *ep !='e' && *ep != 'E'; ep++);
  exp = (ep[2]-'0')*10+ep[3]-'0';
  if(ep[1] == '-') exp = -exp;
  for(zp=ep-1; *zp=='0'; zp--);
  zp++;
  for(p=cd+2; exp > -77 && (p-cd) <= 12 && !(p >= zp && exp <= 0); p++){
   p[-1] = p[0];
   exp--;
  }
  p[-1] = '.';
  p[12]=0;
  if(zp < p) zp = p;
  *zp =0;
  if(exp){
   if(exp < 0){
    exp = -exp;
    sign = '-';
   }else
    sign = '+';
   fprintf( curfc, "'%c%se%c%02d'\n", minus, cd, sign, exp);
  }else
   fprintf( curfc, "'%c%s'\n", minus, cd);
 >>>>>> end of commented-out code
 */
 du.ddb = d ;/* assign double value to union of double and char array */
 /* then put out hexadecimal bytes from array */
 for ( ctr = 0 ; ctr < nch ; ++ctr ) hexpout( du.dch[ctr] ) ;
 fprintf( curfc, "'\n") ;
 inoff += sz;
}
cinit( p, sz ) NODE *p;
{
 /* arrange for the initialization of p into a space of
  size sz */
 /* the proper alignment has been opbtained */
 /* inoff is updated to have the proper final value */
 if(idebug) {
  printf("cinit(%x, %d)\n", p, sz);
 }
 ecode( p );
 inoff += sz;
}
#ifdef NBC
vfdzero( n ){ /* define n bits of zeros in a vfd */
 if( n <= 0 ) return;
 if( inoff%ALINT == 0 ){
  trparen();
  fprintf(curfc, " gen " );
 }
 fprintf(curfc, "%d/0", n );
 inoff += n;
 if( inoff%ALINT == 0 ) fprintf(curfc, "\n" );
 else fprintf(curfc, "," );
}
#else
/*
** define "n" bits of zeros in a field.
*/
void
vfdzero (n)
int n;
{
 NODE zeroinit;
 zeroinit.in.op = ICON;
 zeroinit.tn.lval = 0;
 incode (&zeroinit, n); /* let initializer do it */
}
#endif
char *exname( p ) struct symtab *p;
{
 /* make a name look like an external name in the local machine */
 char *nm;
 static char text[NCHNAM+2];
 register i;
 i = 0;
 if( ldnames(p) ) /* end, etext, edata */
  text[i++] = '_';
 else if (ISFTN( p->stype) && p->sclass != FORTRAN && p->sclass != UFORTRAN)
/* UFORTRAN added by mjp */
  text[i++] = '_';                                                  
 else if( p->sclass == EXTDEF || p->sclass == EXTERN )
#ifdef NBC
  text[i++] = '>';
#else
  text[i++] = '_';
#endif
 for(nm=p->sname; *nm && i<NCHNAM; ++i ){
  text[i] = *nm++;
 }
 text[i] = '\0';
 text[NCHNAM] = '\0';  /* truncate */
 return( text );
}
char umodflg;
ctype(type)
{       /* map types which are not defined on the local machine */
 switch (BTYPE(type)) {
 case UCHAR:
  MODTYPE(type, CHAR);
  break;
 case CHAR:
  break;
  /*
  *  DJK: would let LONGS alone if gram treats
  * long long var as a real long. otherwise int.
  @
  */
 case LONG:
  MODTYPE(type, INT);
  break;
 case ULONG:
  werror("Unsigned long is made long.\n");
  MODTYPE(type, UNSIGNED);
 }
 return(type);
}
noinit( t ) { /* curid is a variable which is defined but
 is not initialized (and not a function );
 This routine returns the storage class for an
   uninitialized declaration */
 return(EXTERN);
}
commdec(x){
}
pcommon( id ){ /* make a common declaration for id, if reasonable */
 register struct symtab *q;
 OFFSZ off;
 int wds;
 q = &stab[id];
#ifdef NBC
 fprintf(dclfc, "_%s common %s(", exname(q)+1, exname(q));
#else
 if (q->sclass == EXTERN)
  fprintf(dclfc, " ext _%s\n", exname(q)+1);
 if (q->sclass == EXTDEF)
  fprintf(dclfc, " def _%s\n", exname(q)+1);
#endif
#ifdef NBC
 if(q->sclass == EXTERN)
  off = 0;
 else
  off = tsize( q->stype, q->dimoff, q->sizoff );
 wds = (off + 31)/SZINT;
 if(wds > 16000) {
  werror("extern array produces common > 16k wds.\n");
 }
 fprintf(dclfc, CONFMT, wds );
 fprintf(dclfc, ")\n" );
#endif
}
isitlong( cb, ce ){ /* is lastcon to be long or short */
 /* cb is the first character of the representation, ce the last */
 /* for the interdata, long = int so no issue.... */
 return(0);
}
isitfloat( s ) char *s;
{
 double atof();
 dcon = atof(s);
 return( FCON );
}
ecode( p ) NODE *p;
{
 /* walk the tree and write out the nodes.. */
 if( nerrors ) return;
 symline(lineno, ftitle);
 p2tree( p );
#ifdef ONEPASS
 p2compile( p );
#endif
}
trparen(){
#ifndef ONEPASS
 if( curfc == textfc) fprintf(textfc, ")");
#endif
}
andok(p)
NODE *p;
{
 /*Is it ok to put & in front of p */
 switch(p->in.op){
 case UNARY MUL:
 case NAME:
  return(1);
 case COMOP:
  return(andok(p->in.right));
 case QUEST:
  return(andok(p->in.right->in.right) && andok(p->in.right->in.left));
 }
 return(0);
}
ofld(p, ty, tysz)
NODE *p;
{
 /* Reduce shifts by converting the field reference to the
   Smallest type that will hold it
  */
 int sz, off;
 int skip;
 sz = UPKFSZ(p->tn.rval);
 off = UPKFOFF(p->tn.rval);
 p->in.left = buildtree(UNARY AND, p->in.left, NIL);
 p->in.left = makety(p->in.left, INCREF(ty));
 skip = off/tysz;
 p->in.left = buildtree(PLUS, p->in.left, bcon((CONSZ) skip) );
 p->in.left = buildtree(UNARY MUL, p->in.left, NIL);
 p->tn.rval = PKFIELD(sz, (off+tysz*(SZINT/tysz-1-skip)));
 p->in.type += (ty-INT);
}
/* Null routines to replace Compion's routines for */
/* generating SDB symbol table.                    */
fixarg() {
}
outstab() {
}
pstab() {
}
pstabdot() {
}
poffs() {
}
psline() {
}
plcstab() {
}
prcstab() {
}
pfstab() {
}
NODE *
noshftfld(p)
NODE *p;
{
 int sz, shft;
 sz = UPKFSZ(p->tn.rval);
 shft = SZINT - sz - UPKFOFF(p->tn.rval);
 p->in.op = AND;
 p->in.right = bcon( (((CONSZ)1<<sz)-1)<<shft);
 return(p);
}
prstab(i)
int i;
{
 struct symtab *q;
 q = &stab[i];
 printf("%d:  %x %x %x %x %x %x %x %x ", i,
 q->stype, q->sclass, q->slevel, q->sflags, q->offset,
 q->dimoff, q->sizoff, q->suse);
 if(q->sname)
  printf("%s", q->sname);
 printf("\n");
}
#ifndef ONEPASS
ishalfcon( c ) CONSZ c;
{
 if(c < 0 || c >= 0x8000) return(0);
 else return(1);
}
#endif
