/*~!diff.h*/
/* Name:  diff.h Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"$Id: diff.h,v 1.5 1995/10/13 23:34:37 jbev Exp $"

/* $Log $
 */

/*
 * diff - common declarations
 */

#ifdef mpx
# define context_vec cntx_vec
# define context_vec_start s_cntx_vec
# define context_vec_end e_cntx_vec
# define context_vec_ptr p_cntx_vec
#endif

void done();

/*
 * Output format options
 */
int	opt;

#define	D_NORMAL	0	/* Normal output */
#define	D_EDIT		-1	/* Editor script out */
#define	D_REVERSE	1	/* Reverse editor script */
#define	D_CONTEXT	2	/* Diff with context */
#define	D_IFDEF		3	/* Diff with merged #ifdef's */
#define	D_NREVERSE	4	/* Reverse ed script with numbered
				   lines and no trailing . */

/* 
 * Constant declarations 
 */
#define	HALFMASK	0xf

#define	prints(s)	fputs(s,stdout)

#define	MAX_CONTEXT	128

#ifdef mpx
# define u_long long
# define pid_t int
# define mode_t unsigned short
#endif /* mpx */

/*
 * diff - directory comparison
 */
#define	d_flags	d_ino

#define	ONLY	1		/* Only in this directory */
#define	SAME	2		/* Both places and same */
#define	DIFFER	4		/* Both places and different */
#define	DIRECT	8		/* Directory */

#ifdef linux
#ifdef d_namlen
#undef d_namlen
#endif
#endif

struct dir {
	u_long	d_ino;
#ifndef mpx
	short	d_reclen;
#endif
	short	d_namlen;
	char	*d_entry;
};


/* 
 * type definitions 
 */

struct cand {
	int x;
	int y;
	int pred;
} cand;

struct line {
	int serial;
	int value;
} *file[2], line;

/*
 * The following struct is used to record change information when
 * doing a "context" diff.  (see routine "change" to understand the
 * highly mneumonic field names)
 */
struct context_vec {
	int	a;	/* start line in old file */
	int	b;	/* end line in old file */
	int	c;	/* start line in new file */
	int	d;	/* end line in new file */
};


/*
 * Algorithm related options
 */
int bflag=0;
int tflag=0;
int wflag=0;
int iflag=0;
int rflag=0;
int lflag=0;
int sflag=0;
int hflag=0;
#ifdef mpx
int qflag=0;
#endif

/*
 * Variables for D_IFDEF option.
 */
int wantelses=0;	/* used with D_IFDEF */
char *ifdef1, *ifdef2;  /* hold the ifdef strings */
char *endifname;
int inifdef=0;

/*
 * Variables for -C (-c) context option.
 */
int context=0;		/* number of lines specfied with the C flag */

char *empty = "";	/* the empty string */

char **diffargv;	/* keep track of argv for diffdir */

char chrtran[256];	/* array of all characters, used with i flag */

char start[256];	/* specify where to start, used with -S */

FILE *input[2];		/* two input files */
int  len[2];
struct line *sfile[2];  /*shortened by pruning common prefix and suffix*/
int  slen[2];

struct stat stb0;

/*
 * Input file names.
 * With diffdir, file1 and file2 are allocated BUFSIZ space,
 * and padded with a '/', and then efile0 and efile1 point after
 * the '/'.
 */
char	*file1, *file2, *efile1, *efile2;
struct	stat stb1, stb2;

#ifdef mpx
char pr[] = "/system/bin/pr";
char diff[] = "/system/bin/diff";
char diffh[] = "/system/bin/diffh";
#else /* mpx */
char pr[] = "/usr/bin/pr";
char diff[] = "/usr/bin/diff";
char diffh[] = "/usr/lib/diffh";
#endif /* mpx */
int status = 2;
int anychange = 0;

struct	context_vec	*context_vec_start,
			*context_vec_end,
			*context_vec_ptr;

char tempfile[2][16];	/* used when comparing against std input
			   or char special devices */
int whichtemp;
char *dummy;		/*used in resetting storage search ptr*/
