/*~!FAULT.C*/
/* Name:  FAULT.C Part No.: _______-____r
 *			
 *	                     SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 */
static char 	 UTfault[] = "@(#)FAULT.C	1.2";

#
/*
 * UNIX shell
 *
 * S. R. Bourne
 * Bell Telephone Laboratories
 *
 */

#include	"defs.h"

#ifdef mpx
BOOL    trapnote;
#endif

STRING		trapcom[MAXTRAP];
BOOL		trapflg[MAXTRAP]= {
					0,
					0,		/* 1 hangup */
					SIGCAUGHT,	/* 2 interrupt */
					SIGCAUGHT,	/* 3 quit */
					0,		/* 4 illegal instr */
					0,		/* 5 trace trap */
					0,		/* 6 IOT */
					0,		/* 7 EMT */
					0,		/* 8 data excptn */
					0,		/* 9 kill */
					0, 		/* 10 bus error */
					0,		/* 11 data mem prot */
					0,		/* 12 bad sys call */
					0,		/* 13 bad pipe call */
					SIGCAUGHT,	/* 14 alarm */
					SIGCAUGHT, 	/* 15 software term */
					0,		/* 16 user defined 1 */
					0,		/* 17 user defined 2 */
					0,		/* 18 death of child */
					0,		/* 19 */
					0,		/* 20 */
					0,		/* 21 */
					0,		/* 22 */
					0,		/* 23 */
					0,		/* 24 */
					0,		/* 25 */
					0,		/* 26 */
					0,		/* 27 */
					0,		/* 28 */
					0,		/* 29 */
					0,		/* 30 */
					0,		/* 31 */
					0,		/* 32 */
					0,		/* 33 */
					0,		/* 34 */
					0,		/* 35 */
					0,		/* 36 */
					0,		/* 37 */
					0,		/* 38 */
					0,		/* 39 */
					0,		/* 40 */
					0,		/* 41 */
					0,		/* 42 */
					0,		/* 43 */
					0,		/* 44 */
					0,		/* 45 */
					0,		/* 46 */
					0,		/* 47 */
					0,		/* 48 */
					0,		/* 49 */
					0,		/* 50 */
					0,		/* 51 */
					0,		/* 52 */
					0,		/* 53 */
					0,		/* 54 */
					0,		/* 55 */
					0,		/* 56 */
					0,		/* 57 */
					0,		/* 58 */
					0,		/* 59 ECC mem error */
					0,		/* 60 pgm mem prot */
					0,		/* 61 simulated instr */
					0,		/* 62 priv instr */
					0,		/* 63 user create flt */
					};

/* ========	fault handling routines	   ======== */


VOID	fault(sig)
	REG INT		sig;
{
	REG INT		flag;

	signal(sig, fault);
	IF sig==MEMF
	THEN	IF setbrk(brkincr) == -1
		THEN	error(nospace);
		FI
	ELIF sig==ALARM
	THEN	IF flags&waiting
		THEN	done();
		FI
	ELSE	flag = (trapcom[sig] ? TRAPSET : SIGSET);
		trapnote |= flag;
		trapflg[sig] |= flag;
		IF sig == INTR THEN wasintr++ FI
	FI
}

stdsigs()
{
	signal(MEMF, fault);
	ignsig(QUIT);
	getsig(INTR);
	getsig(ALARM);
}

ignsig(n)
{
	REG INT		s, i;

	IF (i=n)==MEMF
	THEN	clrsig(i);
		failed(badtrap, "cannot trap 11");
	ELIF (s=signal(i,1)&01)==0
	THEN	trapflg[i] |= SIGMOD;
	FI
	return(s);
}

getsig(n)
{
	REG INT		i;

	IF trapflg[i=n]&SIGMOD ORF ignsig(i)==0
	THEN	signal(i,fault);
	FI
}

oldsigs()
{
	REG INT		i;
	REG STRING	t;

	i=MAXTRAP;
	WHILE i--
	DO  t=trapcom[i];
		    IF t==0 ORF *t
		    THEN clrsig(i);
		    FI

		    trapflg[i]=0;
	OD
	trapnote=0;
}

clrsig(i)
	INT		i;
{
	free(trapcom[i]); trapcom[i]=0;
	IF trapflg[i]&SIGMOD
	THEN	IF trapflg[i]&SIGCAUGHT
		THEN signal(i, fault);
		ELSE	signal(i, 0);
		FI
		trapflg[i] &= ~SIGMOD;
	FI
}

chktrap()
{
	/* check for traps */
	REG INT		i=MAXTRAP;
	REG STRING	t;

	trapnote &= ~TRAPSET;
	WHILE --i
	DO IF trapflg[i]&TRAPSET
	   THEN trapflg[i] &= ~TRAPSET;
		IF t=trapcom[i]
		THEN	INT	savxit=exitval;
			execexp(t,0);
			exitval=savxit;
			 exitset();
		FI
	   FI
	OD
}
