#ident "$Id: writevsn.c_v 1.1 1995/05/08 21:36:41 SYSTEM Exp $"

/* $Log $
 */

#define MAIN

#include "traps.h"

int main(argc,argv)

int argc;
char *argv[];

{
  int vsn;                      /* starting vsn number to write */
  int i;                        /* local loop counter */
  int diskaddr;                 /* disk address */
  int vsnindex;			/* lfc index */
  int istat;                    /* status from calls */
  int param;                    /* loop counter for command line params */
  int buff[(SECTORSIZE/4)*10];  /* buffer big enough for 10 sectors */

  vsnindex = 0;			/* first lfc in table */
  if (argc == 1) {      /* did the user specify an disk addresses? */
    printf("usage: WRITEVSN diskaddr1, diskaddr2, ... diskaddrn\n");
    printf("    example WRITEVSN 7E20\n");
  }else{                /* yes they did, continue on */
    printf("Enter starting VSN number:");
    scanf("%d",&vsn);
    printf("\n");

    for (i=0;i<(SECTORSIZE/4)*10;i++) buff[i] = 0;      /* clear out buffer */
    for (param=2;param<=argc;param++) {     /* loop thru the specified disks */
      diskaddr = atoh(argv[param-1]);         /* get each disk address from the command line */
      istat = opendisc(diskaddr,vsnindex);       /* open the disk */
      if (istat == 0) {
         buff[0] = vsn;
/*       sprintf((char*)buff,"%8d",vsn);        /* put the vsn in the buffer */
         for (i=0;i<100;i+=10) {
           istat = writesector(vsnindex,buff,i,SECTORSIZE*10);
           if (istat != 0) {
             printf("Error writing to disk DM%04X\n",diskaddr);
             break;
           }
           buff[0] = 0;         /* clear out vsn from first two words */
           buff[1] = 0;
         }
         printf("Wrote VSN %d on disk DM%04X\n",vsn,diskaddr);
         vsn++;                 /* increment to the next vsn # */
         closedev(vsnindex);
      }else{  /* error on open of disk */
         printf("Unable to open disk DM%04X\n",diskaddr);
      }
    }   /* for loop on the disk devices */
  }  /* if any command line params */
}
