#ident "$Id: rtchelp.c_v 1.1 1995/05/08 21:36:41 SYSTEM Exp $"

/* $Log $
 */

#define MAIN

#include "traps.h"
#include "rtchelp.h"

void main()

{


  int i;
  int currpos;                     /* current byte position in file */
  int currlen;                     /* current line length */
  int topcount;                    /* total number of topics found */
  int lasttop;			   /* last topic that had text with it */
  int linecount;                   /* number of lines found for current topic */
  char thisline[133];              /* current line being processed */

  struct {
    char topic[12];
    int tcw;
  } loctab;


  helptab = (struct helpent *)calloc(MAXTOPICS,16); /* get and clear memory for topic table */

  currpos = MAXTOPICS * 16;   /* size of dictionary at beginning of file */
  topcount = -1;
  lasttop = -1;
  linecount = 0;

  if ((fp_help = fopen(helppath,wrtbin)) == NULL) {   /* open output file */
     printf("Can't open file %s for update \n",helppath);
  }else{
   if ((fp_text = fopen(textpath,"r")) == NULL) {   /* open input file */
     printf(" can't open file %s\n",textpath);
   }else{
/*
    both files are opened, now start reading
*/
     do {
       memset(thisline,'\0',132);       /* zero input buffer each time */
       fgets(thisline,89,fp_text);
       if (!feof(fp_text)) {
	for (i=87;i>1;i--) {            /* find "true" length of input string */
	  if (thisline[i] != ' ') {
	    break;
	  }else{
	    thisline[i] = '\0';         /* back zero all spaces */
	  }
	}
	thisline[i+1] = '\n';   /* append newline to eol */
	currlen = strlen(thisline);
/*
   is this a new topic?   (a line that begins with '#')
*/
	if (thisline[0] == '#') {
	  if (topcount != -1)     /* update last topic's linecount */
	    if (linecount !=0) {  /* if there is any text with it */
	      for (i=lasttop+1;i<=topcount;i++) {
		helptab->tcw[i] = helptab->tcw[i] | (linecount << 20);
		if (i == topcount) {
		  printf("Topic: %-11s with %2d lines of text.\n\n",
			 helptab->topic[i],linecount);
		}else{
		  printf("Topic: %-11s is same as: \n",helptab->topic[i]);
		}
	      }
	      lasttop = topcount; /* update */
	    }
	  for (i=1;i<12;i++) {
	    if ((thisline[i] == ' ') || (thisline[i] == '\n'))
	       break;
	 }
	  thisline[i] = '\0';
	  topcount++;
	  linecount = 0;
	  sprintf(helptab->topic[topcount],"%s",&thisline[1]);
	  helptab->tcw[topcount] = currpos;

	}else if (thisline[0] == '!') {
/*
   lines that start with '!' are comments
     so don't do anything
*/
	}else{
/*
      this is a data line-output to file
*/
	  linecount++;
	  fseek(fp_help,currpos,0);
	  fputs(thisline,fp_help);
	  currpos = currpos + currlen;   /* update for next time */
	}
       }
     } while (!feof(fp_text));

     if (topcount != -1)       /* update last topics linecount */
       if (linecount != 0)     /* if there was any text with it */
	for (i=lasttop+1;i==topcount;i++)
	  helptab->tcw[i] = helptab->tcw[i] | (linecount << 20);
/*
      output table of contents
*/
     for (i=0;i<MAXTOPICS;i++) {
       fseek(fp_help,i*16,0);
       strncpy(loctab.topic,helptab->topic[i],12);      /* copy over */
       loctab.tcw = helptab->tcw[i];
       fwrite(loctab.topic,1,16,fp_help);
     }
   }  /* if bad open of fp_text */
  } /* if bad open of fp_help */
}
