*SYSTEM DEBUGGER MAPPED PART       MPX-32 RELEASE 3.6.1 HEADER  H.DBUG1
************************************************************************
*                                                                      *
*                    PROPRIETARY INFORMATION                           *
*                    -----------------------                           *
*   THE INFORMATION CONTAINED HEREIN IS PROPRIETARY TO ENCORE          *
*   COMPUTER CORPORATION AND/OR ITS VENDORS, AND ITS USE, DISCLOSURE,  *
*   OR DUPLICATION IS SUBJECT TO THE RESTRICTIONS STATED IN THE        *
*   STANDARD ENCORE COMPUTER CORPORATION LICENSE TERMS AND CONDITIONS  *
*   OR THE APPROPRIATE THIRD-PARTY SUBLICENSE AGREEMENT.               *
*                                                                      *
*                       RESTRICTED RIGHTS                              *
*                       -----------------                              *
*   USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT       *
*   TO RESTRICTIONS AS SET FOURTH IN SUBDIVISION (c) (1) (ii) OF       *
*   THE RIGHTS IN TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT       *
*   252.227.7013                                                       *
************************************************************************
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *
*     ALL RIGHTS RESERVED                                              *
************************************************************************
         M.PGM     DEBUG,MPX-32,3.6.1,00,Y
         M.VRSION
************************************************************************
         TITLE '** ENCORE MPX-32 SYSTEM DEBUGGER, MAPPED SECTION **'
************************************************************************
*                                  MPX SOURCE IN SH.DBUG
************************************************************************
         SPACE     2
         DEF       DEBUGGER
         DEF       RESTART         DEBUG RESTART ENTRY
         DEF       INSTR           TRACE EXECUTE LOCATION
         DEF       INSTRPSW        TRACE INSTR POINTER
         DEF       EMFLAG          EXTENDED MEMORY FLAG         S8501030
         DEF       INIT            INITIALIZED FLAG
         DEF       RETLOC          USER REGISTERS ON ENTRY
*                                                               EBRG-33
         DEF       BRETLOC         USER BASE REGISTERS ON ENTRY EBRG-33
         DEF       BRDBREG         IMAGE OF CURRENT BASE REG'S  EBRG-33
         DEF       BASEMPX         BASE MPX LOGICAL START ADDR  EBRG-33
         DEF       ENDBASE         BASE MPX LOGICAL END ADDRESS EBRG-33
         DEF       ADBRGS          END LOCATION OF BASE REGS    EBRG-33
         DEF       BRDBR7          USER BASE REG 7 IMAGE        EBRG-33
         DEF       DBREGS          IMAGE OF CURRENT USER REGISTERS
         DEF       DBREGS7         IMAGE OF CURRENT USER REG (7)
         DEF       ADBREGS         ENDING ADDRESS OF DBREGS
         DEF       ADR.ATR         CURRENT ADDRESS ATTRIBUTES   EOUT-35A
         DEF       UM.PRNO         USER PROGRAM NUMBER
         DEF       UM.CALLR        CALLER'S PROGRAM NUMBER
         DEF       UM.RSAVE        REGISTER SAVE WHILE MAPPED
         DEF       UM.RSAV1        REG 1 SAVE WHILE MAPPED
         DEF       UM.RSAV2        REG 2 SAVE WHILE MAPPED
         DEF       UM.RSAV3        REG 3 SAVE WHILE MAPPED
         DEF       UM.RSAV4        REG 4 SAVE WHILE MAPPED
         DEF       UM.RSAV5        REG 5 SAVE WHILE MAPPED
         DEF       UM.RSAV6        REG 6 SAVE WHILE MAPPED
         DEF       UM.RSAV7        REG 7 SAVE WHILE MAPPED
         DEF       LWMAP           LOAD WORD MAPPED ROUTINE
         DEF       STWMAP          STORE WORD MAPPED ROUTINE
         DEF       LEAMAP          LOAD EFFECTIVE ADDRESS MAPPED
         DEF       LBMAP           LOAD BYTE MAPPED ROUTINE
         DEF       LHMAP           LOAD HALFWORD MAPPED ROUTINE
         DEF       BUMAP           BRANCH MAPPED ROUTINE
         DEF       TRSWMAP         RETURN MAPPED ROUTINE
         DEF       INSTMAP         EXECUTE INSTRUCTION MAPPED
         DEF       BU.RET          USER RETURN ADDRESS
         DEF       PSW             USER PSW
         DEF       PSW2            USER PSW2                    EDEB-35C
         DEF       MAPPED          USER MAPPED STATE ON ENTRY   EDEB-35D
         DEF       SVCBU           WHERE SVC RETURNS TO, MAPPED
         DEF       REMAP2          REMAP PSD'S
         DEF       REMAP1          ENTRY FOR UNMAPPED REMAP     C020-34
         DEF       RE07            REMAP LOCATION
         DEF       REMAP3
         DEF       BP0TRP          BREAKPOINT 0 TRAP E.P.
         DEF       BP1TRP
         DEF       BP2TRP
         DEF       BP3TRP
         DEF       BP4TRP
         DEF       BP5TRP
         DEF       BP6TRP
         DEF       BP7TRP
         DEF       BPTEND          END OF BREAKPOINT TABLES
         EXT       DBEXEC02        UNMAPPED CT BREAKPOINT PROCESSOR
         DEF       FKPSD           FAKE PSD FOR LPSD
         DEF       FKPSD2          2ND WORD OF FKPSD
         EXT       UM.RSTRT        RESTART UNMAPPED ENTRY
         EXT       UM.DBGR         NORMAL UNMAPPED ENTRY
         EXT       DBUG01          COMMAND INPUT
         EXT       PATCLIST        PATCHLIST BUFFER
         EXT       SVCBU1          WHERE SVC RETURNS TO, UNMAPPED
         EXT       BPTRP           COMMON UNMAPPED E.P. FOR BREAKPOINTS
*        DEF       H.DBUG          DEBUG HAT TABLE              S880966
         LIST      NOMAC
         M.EQUS
         M.TBLS
         M.PSD.                    INCLUDE PSD EQUATES          E3G1635A
         M.PRC.                    INCLUDE CPU STATUS EQUATES   E3G1635A
*
         PAGE
*        FLAG BIT  SETTINGS FOLLOW:
*
*        FLAG      (0)             READ FROM TUBE IF TRUE - ELSE SI
*        FLAG      (1)             G THRU Z ARE DELIMITERS ALSO
*        FLAG      (2)             TRACEBACK MODE IS IN EFFECT
*        FLAG      (3)             OUTPUTS INHIBITED            E3G1635A
*        FLAG      (4)             TUBE OUTPUT  IS OK
*        FLAG      (5)             DEBUGGER ENTERED IN BASE     E3G1635A
*        FLAG      (6)             ISSUE CEAR AT DBUG01 LOOP    E3G1635A
*        FLAG      (7)             DISPLAY REGISTERS
*        FLAG      (9)             SLAVE MODE
*        FLAG      (11)            TRACE IS RUNNING NOW
*        FLAG      (13)            DISABLE EXPRESSION RESOLUTION
*        FLAG      (14)            LF/STF DISPLAY IN PROGRESS
*        FLAG      (15)            DOUBLEWORD REG IN TRACE MODE
*        FLAG      (16)            REGISTER 'D' GOING OUT
*        FLAG      (17)            DUMP SYMBOLIC/NO EXECUTE THO
*        FLAG      (18)            ABS MODE DISPLAY IF RESET/ELSE SYMBOL
*        FLAG      (19)            DUMPER DOES 'SNAP' TYPE DUMP
*        FLAG      (20)            BP IS ACTIVE
*        FLAG      (21)            IF SET, IMPLIES IOP CONSOLE
*        FLAG      (22)            IF SET, IMPLIES IOP LINEPRINTER
*        FLAG      (23)            IF SET, NEED TO ISSUE UEI
*        FLAG      (24)            IF SET, COLLECT COMMAND LIST
*        FLAG      (25)            IF SET, EXECUTE COMMAND LIST
*        FLAG      (26)            IF SET, COMMAND LIST FULL
*        FLAG      (27)            IF SET, COLLECT PATCH 05AUG80A
*        FLAG      (28)            IF SET, EXECUTE PATCH 05AUG80A
*        FLAG      (29)            IS SET, PATCH LIST    05AUG80A
*        FLAG      (30)            IF SET, EXTENDED ADDRESSING MODE 3206
*                                                               EBRG-33
*        FLAG      (31)            IF SET, BASE REGISTER MODE   EBRG-33
*
CEARFL   EQU        6              FLAG TO DBUG01 TO ISSUE CEAR E3G1635A
TYIOP    EQU       21              IOP CONSOLE FLAG
LPIOP    EQU       22              IOP LINEPRINTER FLAG
UNBLK    EQU       23              ISSUE UEI FLAG
COLLC    EQU       24              COLLECT COMMAND LIST   05AUG80A
EXECC    EQU       25              EXECUTE COMMAND LIST   05AUG80A
COMLIFUL EQU       26              COMMAND LIST FULL      05AUG80A
COLLP    EQU       27              COLLECT PATCH LIST     05AUG80A
EXECP    EQU       28              EXECUTE PATCH LIST     05AUG80A
PATLIFUL EQU       29              PATCH LIST FULL        05AUG80A
PAT      EQU       30              RUN PATCHER                 08JUL81
*
         PAGE
*
*        RESTART  AFTER SOME ABORT
*
*
DEBUG    EQU       $
H.DBUG   DATAW     1               DEBUGGER HAT TABLE
         ACW       DBUGS           INITIALIZATION ENTRY
*
ADR.ATR  DATAW     0        HOLDS CURRENT ADDR ATTRIBUTES       EDEB-35
ATR.VA   EQU       0        SET INDICATES VIRTUAL ADDRESS       EOUT-35A
ATR.MOD  EQU       1     SET IF BASE HAS BEEN MODIFIED          EDEB-35
*
         BOUND     1W
RESTART  EQU       $
         TBM       0,INIT          WERE WE RUNNING?
         BNS       DEBUGGER        BR TO INIT IF NO
*                                                               EBRG-33
         LW        R1,C.MPXBR+7W   BASE MPX PHYSICAL START ADDR EBRG-33
         STW       R1,BASEMPX      IN CASE WE ARE UNMAPPED      EBRG-33
         LW        R1,C.MPXBR+0W   BASE MPX PHYSICAL END ADDRESSEBRG-33
         STW       R1,ENDBASE      UNMAPPED END ADDRESS         EBRG-33
         RDSTS     R1              SEE IF WE ARE MAPPED         EBRG-33
         ZBM       1,EMFLAG        ZAP THE EXTENDED MODE FLAG   ETSA-35
         TBR       R1,5            SEE IF WE ARE IN EXTENDED    ETSA-35
         BNS       REST.01         SKIP IF NOT                  ETSA-35
         SBM       1,EMFLAG        ELSE SHOW EXTENDED MODE      ETSA-35
REST.01  CEQU      $               CONTINUE                     ETSA-35
         TBR       R1,8            MAPPED?                      EBRG-33
         BNS       BRMOD.01        NO, USE PHYSICAL ADDRESS     EBRG-33
         TRR       R1,R7           SAVE STATUS                  EBRG-33
         LB        R1,C.PRNO       IS THERE A CURRENT TASK?     EBRG-33
         BZ        BRMOD.01        NO, BASE MPX IS UNMAPPED     EBRG-33
         TBR       R7,6            BASE REGISTER MODE?          ETSA-35
         BS        REST.02         YES.CURRENT MODE IS BASE     ETSA-35
         ZBM       31,FLAG         RESET BASE MODE FLAG         ETSA-35
         SEA                       GO EXTENDED FOR TSA          ETSA-35
         BU        REST.03         MERGE AND CONTINUE           ETSA-35
REST.02  CEQU      $               BASE MODE                    ETSA-35
         SBM       31,FLAG         YES, SET BASE REG MODE       ETSA-35
REST.03  CEQU      $               CONTINUE                     ETSA-35
         LW        R2,C.REGS       YES, FIND BASE MPX           EBRGB02
         LCW       R1,T.MPXBR+7W,R2 BASE REG 7 = BASE MPX START EOUT-35
         STW       R1,BASEMPX      SAVE TO COMPUTE MODULE ADDR  EBRG-33
         LCW       R1,T.MPXBR+0W,R2 BASE REG 0 = BASE MPX END   EOUT-35
         STW       R1,ENDBASE      SAVE FOR ADDRESS RANGE CHECK EBRG-33
BRMOD.01 EQU       $                                            EBRG-33
         LB        R1,C.PRNO       GET CURRENT PROGRAM
         STB       R1,UM.PRNO      KEEP FOR MAPPING
         STB       R1,UM.CALLR     KEEP FOR RETURN
         RDSTS     R1              GET CPU STATUS
         ZBR       R1,PRC.BRM      RESET BASE MODE FLAG         E3G1635A
         SRL       R1,24           TOP BYTE
         STB       R1,DB.01        KEEP SAME STATE WHEN GO UNMAPPED
         LPSD      DB.01           GO UNMAPPED
*
         BOUND     1D
DB.01    GEN       1/1,7/0,24/UM.RSTRT   UNMAPPED RESTART ENTRY PSD
         GEN       16/0,2/2,14/0         UNMAPPED, RETAIN BLK STATE
************************************************************************
*
*        SYSTEM DEBUGGER 'BL' ENTRY FOR NON-BASE USAGE
*
************************************************************************
DBUG     EQU       $               FROM BL *C.DEBUG
         ABM       31,C.GINT       DISABLE FURTHER SCHEDULING   EDEB-35A
*
*        SPECIAL ENTRY POINT FOR PATCH LIST EXECUTION          08JUL81
*                  AT STARTUP - MPX 2.0                        08JUL81
*                                                              08JUL81
PATCHER  EQU       $                                           08JUL81
*                                                               EBRG-33
         ZBM       31,FLAG         RESET BASE MODE              EBRG-33
         ZBM       5,FLAG          RESET BASE EXIT              EBRG-33
DBUG.01  EQU       $               BASE MODE 'BL' MERGE POINT   EBRG-33
         ZBM       PAT,FLAG        INITIALIZE PATCHER FLAG     08JUL81
         ZBM       0,C.PATCH       INITIALIZED BY SYSINIT?     08JUL81
         BNS       PATEND          NO; DONT RUN PACH           08JUL81
         SBM       PAT,FLAG        RUN PATCHER                 08JUL81
         LI        R5,-96           192 W DOUBLE WORD          08JUL81
         LW        R1,C.PATCH                                  08JUL81
         LA        R2,PATCLIST      ADDRESS OF PATCH           08JUL81
         LW        R6,0,R1         GET FIRST WORD OF PATCH     08JUL81
         BZ        PAXX            ZERO PATCH LIST             08JUL81
         SBM       EXECP,FLAG      EXECUTE                     08JUL81
PATLOP   LD        R6,0,R1          LOAD WORD                  08JUL81
         STD       R6,0,R2          STORE                      08JUL81
         ADI       R1,1D            INCREMENT INPUT            08JUL81
         ADI       R2,1D            INCREMENT OUTPUT           08JUL81
         BIB       R5,PATLOP        HAVE WE MOVE 192W          08JUL81
         LA        R2,PATCLIST                                 08JUL81
PAXX     STW       R2,C.PATCH                                  08JUL81
PATEND   EQU       $                                           08JUL81
*
DEBUGGER EQU       $
*                                                               EBRG-33
         ZMW       BRFLAG          INITIALIZE BASE MODE FLAGS   EBRG-33
         SBM       0,INIT          TOGGLE STARTUP BIT
         BS        RESTART         RESTART IF SECOND TIME
         STF       R0,RETLOC       SAVE CALLING ADDRESS FOR EXIT
*
*        MUST NOP BASE REG. INSTRUCTIONS FOR 32/27
*        AND CHANGE RPSWT INSTRUCTIONS TO NOPS                  EDEB-35C
*
         TBM       0,NOP.FLG       CHECK MACHINE TYPE?          EBRGA04
         BS        BRVALID         ALREADY CHECKED              EBRGA04
         RDSTS     R7              CPU STATUS                   EBRGA04
         LI        R4,X'F'         CPU MASK                     EBRGA04
         ANR       R4,R7           MACHINE TYPE                 EBRGA04
         CI        R7,2            32/27?                       EBRGA04
         BNE       BRVALID         NO,BASE REG. SUPPORTED       EBRGA04
DB.27NOP EQU       $                                            EBRGA04
         SBM       0,NOP.FLG       NOP COMPLETE                 EBRGA04
*                                                               EBRG-33
         STW       R0,PSW          SAVE PSW1                    EDEB-35D
         TBM       31,FLAG         DID WE ENTER IN BASE MODE?   EDEB-35D
         BS        DBUG.001        YES. SKIP PSD2 RECORDNG      EDEB-35D
         ZR        R7              CLEAR FOR READ PSW2          EDEB-35D
         BU        DBUG.002        MERGE WITH COMMON CODE       EDEB-35D
DBUG.001 CEQU      $               CONTINUE PROCESSING          EDEB-35D
         LW        R7,DB.PSW2      FETCH PSW2 FROM BASE SECTION EDEB-35D
DBUG.002 CEQU      $               CONTINUE                     EDEB-35D
         STW       R7,PSW2         UPDATE PSW2 WITH NEW PSD     EDEB-35D
         LB        R7,C.PRNO       GET CURRENT PROGRAM
         STB       R7,UM.PRNO      KEEP FOR MAPPING
         STB       R7,UM.CALLR     KEEP FOR RETURN
         ZMB       MAPPED          CLEAR MAPPED FLAG
*                                                               EBRG-33
         LW        R1,C.MPXBR+7W   INIT BASE MPX START ADDRESS  EBRG-33
         STW       R1,BASEMPX      TO PHYSICAL ADDRESS          EBRG-33
         LW        R1,C.MPXBR+0W   ALSO BASE MPX END ADDRESS    EBRG-33
         STW       R1,ENDBASE      TO PHYSICAL END ADDRESS      EBRG-33
         RDSTS     R7              GET CPU STATUS
         TBR       R7,5            CHECK EXTENDED ADDR. BIT     S8501030
         BNS       NEXM            CLEAR FLAG IF NOT SET        S8501030
         SBM       1,EMFLAG        SET FLAG OTHERWISE           S8501030
         BU        DB.02                                        S8501030
NEXM     ZBM       1,EMFLAG        SHOW NON-EXTENDED ADDRESSING S8501030
DB.02    TBR       R7,8            MAP ENABLED?                 S8501030
         BNS       UM.DBGR         GO STRAIGHT THERE IF UNMAPPED
*                                                               EBRG-33
         LB        R1,C.PRNO       IS THERE A CURRENT TASK      EBRG-33
         BZ        BRMOD.07        NO, BASE MPX IS UNMAPPED     EBRG-33
         SEA                       GO EXTENDED FOR TSA          ETSA-35
         LW        R2,C.REGS       MAPPED - GET USER BASE ADDR  EBRGB02
         LCW       R1,T.MPXBR+7W,R2 BASE REG 7 = BASE MPX START EOUT-35
         STW       R1,BASEMPX      SAVE TO COMPUTE MODULE ADDR  EBRG-33
         LCW       R1,T.MPXBR+0W,R2 BASE REG 0 = BASE MPX END   EOUT-35
         STW       R1,ENDBASE      SAVE FOR ADDRESS RANGE CHECK EBRG-33
BRMOD.07 EQU       $                                            EBRG-33
         ABM       7,MAPPED        INDICATE MAPPED
         SRL       R7,24           GET TOP BYTE OF STATUS
         STB       R7,DB.03        KEEP SAME STATE UNMAPPED
         LPSD      DB.03           GO UNMAPPED
*
         BOUND 1D
DB.03    GEN       1/1,7/0,24/UM.DBGR     UNMAPPED BL ENTRY PSD
         GEN       16/0,2/2,14/0         UNMAPPED, RETAIN BLK STATE
*                                                               EBRG-33
DBUG.RTN EQU       $                                            EBRG-33
         SBM       31,FLAG         ENTERED VIA ADAPTOR          EBRG-33
         BU        DBUG.01         MERGE WITH NON-BASE BL ENTRY EBRG-33
         BU        PATEND                                       S880966
         PAGE
*****************************************************************
*                                                               *
*        LWMAP - EXECUTE AN INSTRUCTION UNDER STARTUP CONTEXT   *
*        THE FLAG LWFLAG, INDICATES THE OPERATION               *
*        LWFLAG=0   LW,  R2 IS EFFECTIVE ADDRESS                *
*                        R5 IS RETURNED VALUE                   *
*        LWFLAG=1   STW, R2 IS EFFECTIVE ADDRESS                *
*                        R5 IS VALUE TO STORE                   *
*        LWFLAG=2   LEA, R2 IS INDEX REGISTER                   *
*                        R5 IS EFFECTIVE ADDRESS OUT            *
*        LWFLAG=3   LB,  AS LW                                  *
*        LWFLAG=4   LH,  AS LW                                  *
*        LWFLAG=5   BU,  DESTINATION ADDRESS IS IN BU.RET       *
*        LWFLAG=6   TRSW,   "          "      "  "   "          *
*        LWFLAG=7   EXECUTE INSTRUCTION FOR TRACE               *
*                                                               *
*****************************************************************
*
LWMAP    EQU       $
*        ZMB       LWFLAG          INDICATE LOAD WORD           E3G1635
         LI        R4,0            INDICATE LOAD WORD           E3G1635
EXMAP    EQU       $               COMMON ENTRY POINT
*        ZMB       LW.ENTRY        CLEAR ENTRY FLAGS    EDEB-35EE3G1635A
         STB       R4,LWFLAG       SAVE OPERATION CODE          E3G1635
         RDSTS     R7              GET CPU STATUS ON ENTRY      EDEB-35E
         STW       R7,LW.RDSTS     SAVE FOR EXIT                E3G1635A
         CI        R4,4            IS OPCODE MEMORY REFERENCE?  E3G1635A
         BGT       LW.RMX5         NO. SKIP TO OPCODES 5-7      E3G1635A
         M.IOFF                    BLOCK EXTERNAL INTS.        E1BLK35
*                                                               E3G1635A
*  PROCESS OPCODES 0-4                                          E3G1635A
*                                                               E3G1635A
*W.RM00  CEQU      $               CONTINUE             EDEB-35EE3G1635A
         LI        R7,-1           FETCH DECRIMENT VALUE        E3G1635A
         ARMW      R7,C.GINT       RESTORE C.CINT INITIAL VALUE E3G1635A
         TBM       7,MAPPED        WERE WE MAPPED ON ENTRY?
         BNS       LW.RM08         NO, DON'T REMAP
         TBM       ATR.VA,ADR.ATR  IS THIS A VIRTUAL ADDRESS?   EDEB-35B
         BNS       LW.RM08         NO. DO NOT REMAP             EDEB-35B
         LPSD      LW.RM01         GO MAPPED
*
         BOUND     1D
LW.RM01  GEN       8/X'84',24/LW.RM08  NEW PSD1=>PRI,EXT        E3G1635A
LW.RM02  DATAW     X'80018000'     NEW PSD2               32B02 EOUT-35B
*                                  MAPPED, RETAIN BLOCK, RTN MAP   32B02
*
LW.RM08  EQU       $               NOW AT STARTUP CONTEXT
*        CEA                       DEFAULT TO CEA  MODE E3G1635ACP12442
         TBM       1,EMFLAG        CHECK FOR EXTENDED ADDR.     S8501030
         BNS       LW.8B           DON'T SEA IF NOT SET         S8501030
         SEA                       SET EXTENDED ADDRESSING      S8501030
LW.8B    EQU       $
         XCR       R4,R3           POSITION OPCODE IN INDEX     E3G1635A
         SLL       R3,2            WORD ADJUST OPCODE MAPPED IN E3G1635A
         EXM       LW.TABLE,X3     EXECUTE INSTRUCTION          E3G1635A
         TRR       R4,R3           RECOVER R3                   E3G1635A
         ABM       31,C.GINT       RESTORE C.GINT TO ENTRY      E3G1635A
         BU        LW.RM09         REJOIN
LW.RMX5  CEQU      $               PROCESS OPCODES 5-7          E3G1635A
         TBM       7,MAPPED        WERE WE MAPPED ON ENTRY?     E3G1635A
         BNS       LW.RM5A         NO. SKIP REMAPPING           E3G1635A
         LB        R7,BU.RET       GET CALLER'S PSD(0-7)        E3G1635A
         ZBR       R7,30           DON'T GO BASE MODE YET       E3G1635A
         STB       R7,LW.PSD02     FORCE TO RESTORE PSD STATE   E3G1635A
         LPSD      LW.PSD02        GO MAPPED                    E3G1635A
*                                                               E3G1635A
         BOUND     1D                                           E3G1635A
LW.PSD02 GEN       1/1,7/0,24/LW.RM5A  NEW PSD1                 E3G1635A
         DATAW     X'80018000'     NEW PSD2               32B02 E3G1635A
*                                                               E3G1635A
LW.RM5A  CEQU      $                                            E3G1635A
         CEA                       DEFAULT TO CEA  MODE         E3G1635A
         TBM       1,EMFLAG        CHECK FOR EXTENDED ADDR.     E3G1635A
         BNS       LW.5C           DON'T SEA IF NOT SET         E3G1635A
         SEA                       SET EXTENDED ADDRESSING      E3G1635A
LW.5C    EQU       $                                            E3G1635A
         CI        R4,5            IS IT BU                     EDEB-35E
         BNE       LW.RMX6         NO
         LF        R0,DBREGS       RESTORE USER REGS
*                                                               EBRG-33
         ZBM       31,FLAG         RETURN THRU ADAPTOR?         EBRG-33
         BNS       BMPX.01         NO                           EBRG-33
* DEBUG ADAPTOR CODE SEQUENCE FOR BUMAP PROCESSING              EBRG-33
         STF       R0,DBREGS       SAVE GPR'S                   EBRG-33
         LW        R7,BU.RET       RETURN ADDRESS + COND. CODE  EBRG-33
         RDSTS     R6              GET CURRENT CPU STATUS       EBRG-33
         ANMW      R6,=X'87000000' RETAIN ALL BUT CC'S          EBRG-33
         SBR       R6,6            BASE REGISTER MODE           EBRG-33
         ORR       R6,R7           INCLUDE CURRENT CPU STATUS   EBRG-33
         STW       R7,PSD1         READY TO EXECUTE             EBRG-33
         LF        R0,DBREGS       RELOAD CALLERS GPR'S         EBRG-33
         LPSD      PSD1            RETURN TO CALLER             EBRG-33
PSD1     M.PSDGEN  X'0',OVR,X'00',X'8001',X'0000'               EOUT-35
BMPX.01  EQU       $                                            EBRG-33
         BU        *BU.RET         RETURN
BU.RET   REZ       1W              RETURN ADDRESS
INST.RET REZ       1W              RETURN ADDRESS FOR INSTMAP
LW.RMX6  CI        R4,6            IS IT A TRSW R0
         BNE       LW.RMX7         NO
         LF        R0,RETLOC       RESTORE REGS
*                                                               EBRG-33
         ZBM       31,FLAG         RETURN THRU ADAPTOR?         EBRG-33
         BNS       BMPX.02         NO                           EBRG-33
* DEBUG ADAPTOR CODE SEQUENCE FOR TRSWMAP PROCESSING            EBRG-33
BRBL.RET EQU       $                                            EBRG-33
         RDSTS     R7              CURRENT CPU STATE            EBRG-33
         SBR       R7,6            BASE REGISTER MODE           EBRG-33
         SRL       R7,24           CLEAN OUT GARBAGE            EBRG-33
         STB       R7,PSD.TRSW     UPDATE FOR USER STATE        EBRG-33
         LF        R0,RETLOC       RESTORE CALLERS REGISTERS    EBRG-33
         LPSD      PSD.TRSW        BACK TO BASE REGISTER MODE   EBRG-33
PSD.TRSW M.PSDGEN  BMPX.02,OVR,X'00',X'8001',X'8000'            EOUT-35
BMPX.02  EQU       $                                            EBRG-33
         TRSW      R0              RETURN TO CALLING TASK
LW.RMX7  CI        R4,7            IS IT AN EXECUTE?
         BNE       LW.RM09         NO, DON'T DO ANYTHING
         STW       R0,INST.RET     SAVE RETURN ADDRESS
         LF        R0,DBREGS       LOAD UP USER REGS
*                                                               EBRG-33
         TBM       31,FLAG         ADAPTOR EXECUTION REQUIRED?  EBRG-33
         BNS       BMPX.03         NO                           EBRG-33
         ZBM       31,BRFLAG       EXECUTE 'FAKE' LPSD INSTR?   EBRG-33
         BS        BMPX.03         YES, EXECUTE NON-BASE        EBRG-33
         ZBM       29,BRFLAG       SVC EXECUTION?               EBRG-33
         BNS       BMPX.07         NO, CONTINUE                 EBRG-33
         LW        R6,INSTRPSW     USER SVC INSTRUCTION ADDRESS EBRG-33
         SBR       R6,6            SET BASE MODE EXECUTION      EBRG-33
         RDSTS     R5              CURRENT CPU STATE            EBRG-33
         ANMW      R5,=X'87000000' MASK OUT CC'S                EBRG-33
         ORR       R5,R6           MERGE WITH CONDITION CODES   EBRG-33
         STW       R6,PSD1         WILL RETURN TO CALLER        EBRG-33
         LF        R0,DBREGS       RESTORE USER GPR'S           EBRG-33
         LPSD      PSD1            EXECUTE SVC                  EBRG-33
BMPX.07  EQU       $                                            EBRG-33
* DEBUG CODE SEQUENCE FOR INSTRUCTION EXECUTION PROCESS         EBRG-33
         LW        R7,INSTR        USER INSTRUCTION             EBRG-33
         STW       R7,BR.INST      EXECUTE IN BASE REGISTER MODEEBRG-33
         RDSTS     R7              CURRENT CPU STATUS           EBRG-33
         ANMW      R7,=X'87000000' RETAIN ALL BUT CC'S          EBRG-33
         SBR       R7,6            BASE REGISTER MODE           EBRG-33
         LW        R6,INSTRPSW     CALLERS CURRENT CC'S         EBRG-33
         ORR       R6,R7           COMBINE WITH MACHINE STATE   EBRG-33
         SRL       R7,24           ALIGN FOR PSD STORE          E3G1635
         STB       R7,PSD.EX       EXECUTE INSTR W/USER PSW     EBRG-33
         LF        R0,DBREGS       RESTORE CALLERS GPR'S        EBRG-33
         LPSD      PSD.EX          EXECUTE INSTRUCTION          EBRG-33
PSD.EX   M.PSDGEN  BR.INST,OVR,X'00',X'8001',X'8000'            EOUT-35
         DSECT                     TELL SYSGEN WE'RE BACK       EBRG-33
BR.INST1 EQU       $                                            EBRG-33
         BU        BR.INSTR        MERGE WITH INSTR PROCESSING  EBRG-33
BMPX.03  EQU       $                                            EBRG-33
         CEA                       DEFAULT TO CEA  MODE         E3G1635A
         TBM       1,EMFLAG        CHECK FOR EXTENDED ADDR.     S8501030
         BNS       BMPX3B          DON'T SEA IF NOT SET         S8501030
         SEA                       SET EXTENDED ADDRESSING      S8501030
BMPX3B   BU        *INSTRPSW       PICK UP CONDITION CODES
INSTRPSW DATAW     0
INSTR    EQU       $
         NOP
         NOP
BR.INSTR STF       R0,DBREGS       SAVE USER REGS               EBRG-33
         BL        $+1W            GET CONDITION CODES
         STW       R0,UM.RSAVE     TO BE OUTPUT IN R0
         RDSTS     R0              FETCH NEW CPW STATUS WORD    E3G1635A
         ZBM       SEA.EM,EMFLAG   DEFAULT TO CEA  EXECUTION    E3G1635A
         ZBM       PSD.EXT,PSW     DEFAULT PSW1 TO CEA          E3G1635A
         TBR       R0,PRC.EXT      DID WE GO SEA?               E3G1635A
         BNS       BMPX3D          NO. SKIP TOGGLE TO SEA       E3G1635A
         SBM       SEA.EM,EMFLAG   INDICATE WE'RE NOW SEA       E3G1635A
         SBM       PSD.EXT,PSW     TOGGLE PSW                   E3G1635A
BMPX3D   CEQU      $               CONTINUE                     E3G1635A
         LW        R0,INST.RET     PICK UP INSTRMAP RETURN ADDR
*
LW.RM09  EQU       $
         TBM       7,MAPPED        WERE WE MAPPED ON ENTRY?     E3G1635A
         BNS       LW.RM11         NO. SKIP REMAPPING           E3G1635A
LW.9B    LPSD      LW.RM10         GO UNMAPPED AGAIN
LW.RM11  EQU       $
         CEA                         DEFAULT TO CEA  FOR EXIT   E3G1635A
         TBM       PRC.EXT,LW.RDSTS  DID WE ENTER LWMAP SEA?    E3G1635A
         BNS       LW.RM11B          YES, SKIP GOING SEA        E3G1635A
         SEA                         RESTORE SEA MODE           E3G1635A
LW.RM11B CEQU      $                                            E3G1635A
         ZBM       PRC.BLK,LW.RDSTS    TEST BLOCKED ON ENTRY ?  E3G1635A
         BS        LW.RM11C            YES. RETAIN OVER TRSW    E3G1635A
         M.IONN                        OTHERWISE,UNBLOCK        E3G1635A
LW.RM11C CEQU      $                                            E3G1635A
         TRSW      R0              RETURN
         BOUND     1D
LW.RM10  GEN       8/X'84',24/LW.RM11   NEW PSD1                CP11865
         GEN       16/0,2/2,14/0        NEW PSD2, UNMAPPED, RET BLK
*
SVCBU    EQU       $                    SVC'S RETURN HERE
         BU        $+1W                 INSTRUCTION PLACED IN SVC TRAP
         LF        R0,UM.RSAVE          RESTORE REGISTERS
         LPSD      LW.RM20              GO UNMAPPED AGAIN
*
         BOUND     1D
LW.RM20  GEN       8/X'84',24/SVCBU1    BACK TO UNMAPPED SVC    CP11865
         GEN       16/0,2/2,14/0        NEW PSD2, UNMAPPED, RET BLK
*
         BOUND     1D
FKPSD    DATAW     0               THIS IS WHERE PSDOP PUTS THE LPSD
FKPSD2   DATAW     0               DESTINATION ADDRESS
*
STWMAP   EQU       $
         LI        R4,1            INDICATE STORE
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP           COMMON CODE
*
LEAMAP   EQU       $
         LI        R4,2            INDICATE LEA
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP
*
LBMAP    EQU       $
         LI        R4,3            INDICATE LB
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP
*
LHMAP    EQU       $
         LI        R4,4            INDICATE LH
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP
*
BUMAP    EQU       $
         LI        R4,-1           LOAD -1                      EDEB-35A
         ARMW      R4,C.GINT       DECRIMENT C.GINT             EDEB-35A
         ZMW       ADR.ATR         CLEAR ADDRESS ATTRIBUTES     EDEB-35A
         LI        R4,5            INDICATE BU
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP
*
TRSWMAP  EQU       $
         LI        R4,-1           LOAD -1                      EDEB-35A
         ARMW      R4,C.GINT       DECRIMENT C.GINT             EDEB-35A
         ZMW       ADR.ATR         CLEAR ADDRESS ATTRIBUTES     EDEB-35A
         LI        R4,6            INDICATE TRSW
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP
*
INSTMAP  EQU       $
         LI        R4,7            INDICATE EXECUTE INST
*        STB       R4,LWFLAG                                    E3G1635
         BU        EXMAP
*
         BOUND     1D
REMAP3   M.PSDGEN  RE06,OVR,X'80',X'8000',X'8010'               EOUT-35
RE06     EQU       $
         STB       R4,*C.MPL       REINSTATE BPIX LOAD BIT
RE07     EQU       $
         LPSDCM    REMAP1          ESTABLISH NEW MAP
         BOUND     1D
REMAP1   GEN       1/1,7/0,24/RE08 NEW PSD WD 1
REMAP2   DATAW     0               NEW PSD WD 2
RE08     EQU       $
*                                                               EBRG-33
         SBM       7,MAPPED        SET  MAPPED FLAG             C020-34
         TBM       0,REMAP2        ARE WE REALLY MAPPED?        C020-34
         BS        GC1             BRANCH IF YES                C020-34
         ZMB       MAPPED          CLEAR MAPPED FLAG OTHERWISE  C020-34
GC1      EQU       $                                            C020-34
         LW        R1,C.MPXBR+7W   DEFAULT TO PHYSICAL ADDRESS  EBRG-33
         STW       R1,BASEMPX      FOR BASE MPX START           EBRG-33
         LW        R1,C.MPXBR+0W   ALSO PHYSICAL END ADDRESS    EBRG-33
         STW       R1,ENDBASE      BASE MPX END                 EBRG-33
         LB        R1,C.PRNO       IS THERE A CURRENT TASK?     EBRG-33
         BZ        BRMOD.08        NO, BASE MPX IS UNMAPPED     EBRG-33
         RDSTS     R1              FETCH CURRENT STATE          ETSA-35
         TBR       R1,5            EXTENDED ADDRESSING SET?     ETSA-35
         BS        GC1.01          YES. NO NEED TO SET          ETSA-35
         TBR       R1,6            BASE MODE?                   ETSA-35
         BS        GC1.01          YES. NO NEED TO GO EXTENDED  ETSA-35
         SEA                       GO EXTENDED FOR TSA          ETSA-35
GC1.01   CEQU      $               CONTINUE                     ETSA-35
         LW        R2,C.REGS       REMAPPED - GET MAPPED ADDR   EBRGB02
         LCW       R1,T.MPXBR+7W,R2 BASE REG 7 = BASE MPX START EOUT-35
         STW       R1,BASEMPX      SAVE TO COMPUTE MODULE ADDR  EBRG-33
         LCW       R1,T.MPXBR+0W,R2 BASE REG 0 = BASE MPX END   EOUT-35
         STW       R1,ENDBASE      SAVE FOR ADDRESS RANGE CHECK EBRG-33
BRMOD.08 EQU       $                                            EBRG-33
         LPSD      REMAP4          GO UNAMPPED AGAIN!
         BOUND     1D
REMAP4   GEN       1/1,7/0,24/DBUG01  BACK TO COMMAND INPUT
         DATAW     X'00008000'        UNMAPPED, RETAIN BLK MODE
*
BP0BLK   DATAW     0,0,0,0
         BU        BP0TRP
BP1BLK   DATAW     0,0,0,0
         BU        BP1TRP
BP2BLK   DATAW     0,0,0,0
         BU        BP2TRP
BP3BLK   DATAW     0,0,0,0
         BU        BP3TRP
BP4BLK   DATAW     0,0,0,0
         BU        BP4TRP
BP5BLK   DATAW     0,0,0,0
         BU        BP5TRP
BP6BLK   DATAW     0,0,0,0
         BU        BP6TRP
BP7BLK   DATAW     0,0,0,0
         BU        BP7TRP
*
BPTEND   DATAW     BPTEND-1W
************************************************************************
*
* NON BASE REGISTER ENTRY FOR ONE-SHOT BREAKPOINT
*
************************************************************************
DBEXEC01 EQU       $
         STF       R0,DBREGS       SAVE REGS
         BL        $+1W            GET CCS
         ABM       31,C.GINT       DISABLE FURTHER SCHEDULING   EDEB-35C
         STW       R0,PSW          SAVE THEM
         ZR        R2              CLEAR FOR READ PSW2          EDEB-35C
         STW       R2,PSW2         SAVE FOR LATER               EDEB-35C
DBEX.00  CEQU      $               CONTINUE PROCESSING          EDEB-35C
         RDSTS     R2              GET CPU STATUS
         TRR       R2,R7           COPY TO R7                   E3G1635
         SRL       R2,24
         STB       R2,EXPSD        KEEP USER STATE WHEN UNMAPPED
         ZMB       MAPPED          CLEAR MAPPED FLAG           3301
*        RDSTS     R7              GET CPU STATUS      3301     E3G1635
         TBR       R7,8            MAP ENABLED?                3301
         BNS       DBUNM           GO STRAIGHT THERE IF UNMAPPED3301
         ABM       7,MAPPED        INDICATE MAPPED             3301
         LW        R1,C.MPXBR+7W   DEFAULT BASE MPX TO PHYSICAL EBRG-33
         STW       R1,BASEMPX      START ADDRESS                EBRG-33
         LW        R1,C.MPXBR+0W   PHYSICAL END ADDRESS         EBRG-33
         STW       R1,ENDBASE      OF BASE MPX                  EBRG-33
         LB        R2,C.PRNO       IS THERE A CURRENT TASK?     EBRG-33
         BZ        BRMOD.09        NO, BASE MPX IS UNMAPPED     EBRG-33
         SEA                       GO EXTENDED FOR TSA DATA     ETSA-35
DBEX.01  CEQU      $               CONTINUE                     ETSA-35
         LW        R1,C.REGS       MAY HAVE BASE MPX REMAPPED   EBRGB02
         LCW       R2,T.MPXBR+7W,R1 BASE REG 7 = BASE MPX START EOUT-35
         STW       R2,BASEMPX      SAVE TO COMPUTE MODULE ADDR  EBRG-33
         LCW       R2,T.MPXBR+0W,R1 BASE REG 0 = BASE MPX END   EOUT-35
         STW       R2,ENDBASE      SAVE FOR ADDRESS RANGE CHECK EBRG-33
BRMOD.09 EQU       $                                            EBRG-33
DBUNM    EQU       $                                           3301
         LPSD      EXPSD           GO UNMAPPED
         BOUND     1D
EXPSD    GEN       1/1,7/0,24/DBEXEC02  PSD WORD 1
         GEN       16/0,2/2,14/0        PSD WORD 2, UNMAPPED, RET BLK
*                                                               EBRG-33
BR.RCVR  EQU       $                                            EBRG-33
         SBM       31,FLAG         SHOW BASE EXECUTION MODE     EBRG-33
         STF       R0,DBREGS       SAVE INCOMMING REGISTERS     EDEB-35C
         LW        R2,DB.PSW       FETCH INCOMMING PSD          EDEB-35C
         STW       R2,PSW          SAVE PSW1                    EDEB-35C
         LW        R2,DB.PSW2      FETCH INCOMMING PSD          EDEB-35C
         STW       R2,PSW2         SAVE PSW2                    EDEB-35C
         BU        DBEX.00         MERGE WITH NON-BASE CODE     EDEB-35C
BP0TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP0BLK       POINT TO BP TABLE
         BU        MAPBPTRP
BP1TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP1BLK       POINT TO BP TABLE
         BU        MAPBPTRP
BP2TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP2BLK       POINT TO BP TABLE
         BU        MAPBPTRP
BP3TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP3BLK       POINT TO BP TABLE
         BU        MAPBPTRP
BP4TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP4BLK       POINT TO BP TABLE
         BU        MAPBPTRP
BP5TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP5BLK       POINT TO BP TABLE
         BU        MAPBPTRP
BP6TRP   STF       R0,DBREGS       SAVE USER REGS
         BL        $+1W
         STW       R0,PSW        SAVE CONDITION CODES
         LA        R1,BP6BLK       POINT TO BP TABLE
         BU        MAPBPTRP
*
BP7TRP   EQU       $
         STF       R0,DBREGS       SAVE USER REGISTERS
         BL        $+1W
         STW       R0,PSW        SAVE PSW
         LA        R1,BP7BLK       POINT TO BLOCK
         BU        MAPBPTRP        ENTER RECEIVER
*                                                               EBRG-33
BRBP.RTN EQU       $                                            EBRG-33
         STF       R0,DBREGS       SAVE CALLERS GPR'S           EBRG-33
         LW        R1,C.MPXBR+7W   INITIALIZE BASE MPX          EBRG-33
         STW       R1,BASEMPX      IN CASE UNMAPPED             EBRG-33
         LW        R1,C.MPXBR+0W   BASE MPX END ADDRESS         EBRG-33
         STW       R1,ENDBASE      PHYSICAL ADDRESS             EBRG-33
         LW        R1,DB.BLK       RESTORE BREAKPOINT BLOCK ADDREBRG-33
         LW        R0,DB.PSW       RETRIEVE CONDITION CODES     EBRG-33
*  MERGE WITH MAPBPTRP PROCESSING                               EBRG-33
         STW       R0,PSW          SAVE LOCALLY                 EBRG-33
         SBM       31,FLAG         SHOW BASE MODE               EBRG-33
         LW        R2,DB.PSW2      FETCH INCOMMING PSW2         EDEB-35C
         STW       R2,PSW2         ESTABLISH INCOMMING PSW2     EDEB-35C
         BU        MAPBP.01        MERGE WITH NON-BASE BREAK    EDEB-35C
************************************************************************
*
* NON-BASE REGISTER BREAKPOINT COMMON PROCESSING ENTRY POINT
*
************************************************************************
MAPBPTRP EQU       $               MAP TO RECEIVER
         ABM       31,C.GINT       DISABLE FURTHER SCHEDULING   EDEB-35A
         ZR        R2              CLEAR FOR READ PSW2          EDEB-35C
         STW       R2,PSW2         SAVE FOR LATER               EDEB-35C
MAPBP.01 CEQU      $               BASE MODE BREAK COMMON MERGE EDEB-35C
         RDSTS     R2              GET CPU STATUS
         TRR       R2,R7           COPY TO R7                   E3G1635
         SRL       R2,24           TOP BYTE=PSW STATE
         STB       R2,BPPSD        KEEP USER STATE WHEN UNMAPPED
         ZMB       MAPPED          CLEAR MAPPED FLAG           3301
         TBR       R7,5            CHECK EXTENDED ADDR. BIT     S8501030
         BNS       ZEMF            CLEAR FLAG IF NOT SET        S8501030
         SBM       1,EMFLAG        SET FLAG BIT OTHERWISE       S8501030
         BU        MAPCHK                                       S8501030
ZEMF     ZBM       1,EMFLAG        CLEAR EXTENDED ADDR. FLAG    S8501030
         TBR       R7,6            BASE MODE?                   ETSA-35
         BS        MAPCHK          DON'T GO EXTENDED            ETSA-35
         SEA                       GO EXTENDED FOR TSA DATA     ETSA-35
MAPCHK   TBR       R7,8            MAP ENABLED?                 S8501030
         BNS       BPUNM           GO STRAIGHT THERE IF UNMAPPED3301
         ABM       7,MAPPED        INDICATE MAPPED             3301
         LW        R7,C.MPXBR+7W   BASE MPX PHYSICAL START ADDR EBRG-33
         STW       R7,BASEMPX      IN CASE WE ARE UNMAPPED      EBRG-33
         LW        R7,C.MPXBR+0W   PHYSICAL END ADDRESS         EBRG-33
         STW       R7,ENDBASE      OF BASE MPX                  EBRG-33
         LB        R7,C.PRNO       DO WE HAVE A CURRENT TASK?   EBRG-33
         BZ        BPUNM           NO, BASE MPX IS UNMAPPED     EBRG-33
         LW        R3,C.REGS       BASE MPX MAY BE REMAPPED     EBRGB02
         LCW       R7,T.MPXBR+7W,R3 BASE REG 7 = BASE MPX START EOUT-35
         STW       R7,BASEMPX      SAVE TO COMPUTE MODULE ADDR  EBRG-33
         LCW       R7,T.MPXBR+0W,R3 BASE REG 0 = BASE MPX END   EOUT-35
         STW       R7,ENDBASE      SAVE FOR ADDRESS RANGE CHECK EBRG-33
BPUNM    EQU       $                                           3301
         LPSD      BPPSD           GO UNMAPPED
         BOUND     1D
BPPSD    GEN       1/1,7/0,24/BPTRP  COMMON BP RECEIVER
         GEN       16/0,2/2,14/0     UNMAPPED, RETAIN BLK STATE
*
LWFLAG   REZ       1B              ACTION FLAG FOR EXMAP
UM.PRNO  REZ       1B              CURRENT PROGRAM NUMBER
UM.CALLR REZ       1B              CALLING PROGRAM NUMBER
MAPPED   REZ       1B              MAPPED FLAG, MAPPED IF 1
         BOUND     1F
RETLOC   RES       8W
DBREGS   RES       7W              USER REG 0-6 IMAGE
DBREGS7  RES       1W              USER REG. 7 IMAGE
*                                                               EBRG-33
BRETLOC  RES       8W              BASE REGISTER SAVE AREA      EBRG-33
BRDBREG  RES       7W              USER BASE REG (0-6) IMAGE    EBRG-33
BRDBR7   RES       1W              USER BASE REG 7 IMAGE        EBRG-33
         BOUND     1F
UM.RSAVE RES       1W              REGISTER SAVE DURING MAPPING
UM.RSAV1 RES       1W
UM.RSAV2 RES       1W
UM.RSAV3 RES       1W
UM.RSAV4 RES       1W
UM.RSAV5 RES       1W
UM.RSAV6 RES       1W
UM.RSAV7 RES       1W
PSW      DATAD     0               USER PSW
PSW2     DATAW     0               USER PSW2                    EDEB-35C
*                                                               EBRG-33
BASEMPX  DATAW     0               BASE MPX LOGICAL START ADDR  EBRG-33
BRFLAG   DATAW     0               BASE REGISTER EXECUTION FLAG EBRG-33
ENDBASE  DATAW     0               BASE MPX LOGICAL END ADDRESS EBRG-33
NOP.FLG  DATAW     0                                            EBRGA04
SAVBASE  REZ       2W              EVENT TRACE BASE ADDR SAVE   EBRGB03
INIT     REZ       1W              INITIALIZED FLAG
FLAG     REZ       1W              STATUS FLAGS
EMFLAG   REZ       1B              EXTENDED MEMORY FLAG         S8501030
SEA.EM   EQU       1               ENTERED IN SEA  MODE         E3G1635A
SEAR.EM  EQU       4               ENTERED IN SEAR MODE         E3G1635
ADBREGS  DATAW     B(DBREGS+8W)    ENDING LOCATION OF DBREGS
ADBRGS   DATAW     B(BRDBREG+8W)   END LOCATION OF BASE REGS    EBRG-33
LW.RDSTS DATAW     0               CPU STATUS FOR LWMAP SUBR    E3G1635A
         BOUND     1W                                           E3G1635A
LW.TABLE DEQU      $               LWMAP OPCODE 0-4 INSTR TABLE E3G1635A
         LW        R5,0W,X2        OPCODE 0 (PHY)               E3G1635A
         STW       R5,0W,X2        OPCODE 1 (PHY)               E3G1635A
         LEA       R5,0W,X2        OPCODE 2 (PHY)               E3G1635A
         LB        R5,0W,X2        OPCODE 3 (PHY)               E3G1635A
         LH        R5,0W,X2        OPCODE 4 (PHY)               E3G1635A
LW.TBLE  EQU       $-LW.TABLE                                   E3G1635A
         LPOOL
         PAGE
DBUGS    M.EIR
*                                                               EBRG-33
         LA        R2,DBUG        DBUG ADDR FOR OPCOM
         STW       R2,C.DEBUG      INITIALIZE C.
         BU        SG.XI
         DATAB     C'(C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION'
         DATAB     C' ALL RIGHTS RESERVED'
         BOUND     1W
SG.XI    EQU       $
         M.XIR     H.DBUG
DENDX    END
