  @  /*~!oscode.c*/  */* Name:  oscode.c Part No.: _______-____r *  *  - * Copyright 1993 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbsamp:oscode.c	1.0"                @  E/* this routine shows how to generate a handler for MPX.  It show how E F * to interact with the system and also how to define SVC's.  All code F H * must be in DSECT.  Use the -H option to nbcc.  Notice use of function H * * and inline assembler to make the calls. *  */     /*  E ******************************************************************** E  *   *  Functional description:   *  -----------------------   *  E *  This module is the interface between client program that talks to E H *  the user, and the tasks running in the system.  A client task places H I *  requests in the static partition, and then go to sleep.  This handler I G *  will wake up on each clock tick and process these requests, then go G  *  to sleep itself.      @   *     The requests are:  * *       get data from a task or partition * ) *       store data in a task or parition ) $ *       wake up another client task $  *       break a task   *   *  Program definition:   *  -------------------   *  D *  H.OSCODE is an MPX system module, and is called via a HAT entry. D @ *  We have the initialization entry point of H.OSCODE share the @  *  real-time clock interrupt.   *   *  Commons:   *  --------  = *  H.OSCODE uses the OSPART common that client programs use. =  *  P ******************************************************************************* P  */     /*  P ******************************************************************************* P                                             @  ( * this is an mpx handler written in 'c' ( P ******************************************************************************* P  */     8asm ("hat dataw 1");            /* sysgen needs a hat */ 8 =asm (" acw sg.ini");            /* tell sysgen where to go */ =    &/* include system table definitions */ & -#define MPX3X		/* this is code for MPX 3.X */ - #include <mosde.h>  #include <cdots.h>  #include <dqe.h>  #include <tsa.h>  #include <smt.h>     #define TRUE    1  #define FALSE   0  #define LOGPADR 0xc0000     /*   * local subroutines   */     static int *xlear();  static int *lear();  static void goumap();  static void gomap();     0#define MAXCL 8		/* maximum number of clients */ 0                         @  #define NodeInactive 0  #define NodeActive 1  #define ShutDown 1     $/* client task communication area */ $ struct client {  )    int taskNum;	/* client task number */ ) %    int nodeNum;	/* node of client */ % $    int Status;		/* client status */ $ -#define stPending 1	/* waiting for request */ - 0#define stBeingProcessed 2 /* being worked on */ 0 +#define stComplete 4	/* request complete */ + #    int ReqCode;	/* request code */ # $#define reqGet 1	/* get task data */ $ $#define reqPut 2	/* put task data */ $ '#define reqWakeup 3	/* wakeup a task */ ' -#define reqBreak 4	/* send break to a task */ - ?    unsigned int TaskNo;  /* requested task/partition number */ ? &    int LogAddr;	/* logical address */ &                                  @  "    int Len;		/* request length */ " $    int Data[8];	/* data I/O area */ $ };     #/* partition layout for our node */ # 
struct node { 
 &    int	NodeNum;	/* our node number */ & &    int Flag;		/* node status flags */ &     int Active;		/* state */  8    struct client client[MAXCL];	/* client structures */ 8 };     /*   * Local variables   */     Jstatic  int     initDone = FALSE; /* set non zero when init is all done */ J 9static  int     nodenum = 0;      /* local node number */ 9 @static  int     ticksx1;          /* clock ticks in 1 seconds */ @ @static  int     ticksx5;          /* clock ticks in 5 seconds */ @ Istatic  int     ticksday;         /* clock ticks in a day (86400 secs) */ I                                        @  <static  int     strtclk = 0;      /* starting clock ticks */ < Bstatic  int     spsave;           /* save sp during resume call */ B >static  int*    realpadr;         /* real partition address */ > /* logical partition address */  4static  struct node *laddr = (struct node *)LOGPADR; 4 Astatic	struct node *nodep;       /* physical partition address */ A Cstatic	struct client *clp;       /* current client table pointer */ C =static  struct dqe * dqeptr;      /* static pointer to dqe */ = 7static  int     dqen;             /* temp dqe number */ 7 =static  struct tsa * tsaptr;      /* static pointer to tsa */ = =static  struct smt * smtptr;      /* static pointer to smt */ =    C/* c defined in cdots.h include file as structure for cdot region*/ C   @  !#define CDOTP ((struct c *)CDOTS) !    H/* t defined in tsa.h include file as structure for task tsa (c.tsad) */ H %#define TSAP (*(struct tsa **)C_TSAD) %    E/* smt defined in smt.h include file as structure for smt (c.smta) */ E %#define SMTP (*(struct smt **)C_SMTA) % /* smt entry size in bytes */  #define SMTS (*(char *)C_SMTS)  /* number of smt entries */  #define SMTN (*(char *)C_SMTN)     A/* dqe defined in dqe.h include file as structure for task dqe */ A 3/* following macro to get dqe addr given dqe num */ 3 1#define DQEP(n) (((struct adat *)C_ADAT)->dqe[n]) 1 </* following macro to get current dqe address from C.CURR */ < -#define CDQE ((struct dqe *)(CDOTP->curr.sf)) -    (/* routine to handle clock interrupts */ (          @  /* entered at each clock int */  rtclk()  {  5  int     progn;           /* client program index */ 5 5  int     index;           /* index to first entry */ 5    <  if (!initDone)return;   /* exit if not ready to run yet */ <    1  /* see if we have been requested to shutdown */ 1   /* if so, go inactive */    if (nodep->Flag & ShutDown) {  7    nodep->Active = NodeInactive;	/* set us inactive */ 7 ;    nodep->Flag &= !ShutDown;		/* shut off shutdown flag */ ; -    for (progn = 0; progn < MAXCL; progn++) { - 4      clp = &nodep->client[progn];	/* curr client */ 4 (      /* see if client assigned to us */ ( 6      if ((clp->nodeNum == nodenum) && clp->taskNum) { 6 -        /* get task number & see if active */ -                             @          /* get dqe addr */  *        dqeptr = DQEP(clp->taskNum >> 24); * )        /* if task executing, abort it */ ) !        if (dqeptr->us >= CURR) { ! <          asm (" stw  sp,_spsave");	/* save stack pointer */ < ;          asm (" ext  S.EXEC18");	/* exec resume routine */ ; <          asm (" lw   r1,_dqeptr");	/* get dqe addr in r2 */ < $          asm (" lw   r5,=C'OSCO'"); $ $          asm (" lw   r6,=C'DEXI'"); $ $          asm (" lw   r7,=C'TING'"); $ 2          asm (" bl   S.EXEC18");	/* go to exec */ 2 9          asm (" lw   sp,_spsave");	/* get back our sp */ 9 	        } 	       }      }      initDone = FALSE;      return;    }       /*     * recover lost entries      */                                               @  +  for (progn = 0; progn < MAXCL; progn++) { + 3    clp = &nodep->client[progn];		/* curr client */ 3 &    /* see if client assigned to us */ & 4    if ((clp->nodeNum == nodenum) && clp->taskNum) { 4 +      /* get task number & see if active */ +       /* get dqe addr */  (      dqeptr = DQEP(clp->taskNum >> 24); ( '      /* if task executing, continue */ ' A      if ((dqeptr->tan != clp->taskNum) || (dqeptr->us < CURR)) { A (        /* task has aborted, clean up */ (         clp->taskNum = 0;        }      }    }       /* handle client requests */     +  for (progn = 0; progn < MAXCL; progn++) { + 3    clp = &nodep->client[progn];		/* curr client */ 3 %    if ((clp->Status == stPending) || %                                              @  *      (clp->Status == stBeingProcessed)) { * '          if(clp->nodeNum == nodenum) { '    ;            /* an entry has been found for me to process */ ; :            int getput = 0;     /* flag for get and put */ :    #            switch (clp->ReqCode) { #                  case reqGet:                  getput = 1;                   case reqPut:  .                /* see if task or partition */ . 1                if (dqen = (clp->TaskNo >> 24)) { 1 -                  /* we have a task number */ - +                  /* data addr map start */ + 0                    int das = (int)clp->LogAddr; 0 +                  /* data addr map start */ + 1                    int dae = das + clp->Len - 1; 1                     int cntr;                 @  (                    dqeptr = DQEP(dqen); ( 3                    if (dqeptr->us < CURR)continue; 3 >                  /* get real tsa address of requested task */ > M                    tsaptr = (struct tsa *)(((int)(dqeptr->msd)) & 0xffe000); M 9                  /* loop for each data byte requested */ 9 ;                    for (cntr=0; cntr < clp->Len; cntr++) { ; 1                    /* calc logical map number */ 1 F                      int curlmap = ((das + cntr) >> 13) - CDOTP->msd; F =                      short * midlptr = (short *)dqeptr->msd; = ,                    /* look for valid map */ , 7/*                    if (midlptr[curlmap] & 0x8000) */ 7 ?                    /* get physical map num & calc real addr */ ?                            @  E                      int phyadr = (((int)(midlptr[curlmap]) << 13) & E =                         0xffe000) | ((das + cntr) & 0x1fff); = !                      if (getput) ! .                    /* get data from memory */ . <                        clp->Data[cntr] = (*(char *)phyadr); <                       else  ,                    /* put data in memory */ , :                        *(char *)phyadr = clp->Data[cntr]; :                     }                  } else {  1                  /* we have a partition index */ 1 +                  /* data addr map start */ + 0                    int das = (int)clp->LogAddr; 0 +                  /* data addr map start */ + 1                    int dae = das + clp->Len - 1; 1                              @                      int cntr;                      int psla;  ;                  /* get smt addr of requested partition */ ; 7                    smtptr = (struct smt *)((int)SMTP + 7 ,                      (SMTS * clp->TaskNo)); , 4                  /* set logical starting address */ 4 .                    psla = smtptr->page << 11; . 9                  /* loop for each data byte requested */ 9 ;                    for (cntr=0; cntr < clp->Len; cntr++) { ; 8                    /* calc logical map offset number */ 8 =                      int mapoff = (das - psla + cntr) >> 13; = ?                    /* get physical map num & calc real addr */ ? I                      int phyadr = (((int)(smtptr->midl[mapoff]) << 13) & I                             @  D                         0xffe000) | ((das - psla + cntr) & 0x1fff); D !                      if (getput) ! .                    /* get data from memory */ . <                        clp->Data[cntr] = (*(char *)phyadr); <                       else  ,                    /* put data in memory */ , :                        *(char *)phyadr = clp->Data[cntr]; :                     }                  }  =                clp->Status = stComplete;  /* all done now */ =                 break;     (    	      /* wakeup a suspended task */ (               case reqWakeup:  "                /* get dqe addr */ " 1                dqeptr = DQEP(clp->TaskNo >> 24); 1 H                /* if task suspended, resume it; else wait till later */ H               @  )                if (dqeptr->us == SUSP) { ) D                  asm (" stw  sp,_spsave");	/* save stack pointer */ D C                  asm (" ext  S.EXEC14");	/* exec resume routine */ C D                  asm (" lw   r2,_dqeptr");	/* get dqe addr in r2 */ D :                  asm (" bl   S.EXEC14");	/* go to exec */ : A                  asm (" lw   sp,_spsave");	/* get back our sp */ A >                  clp->Status = stComplete;	/* all done now */ >                 }                  break;     %    	      /* break specified task */ %               case reqBreak:  "                /* get dqe addr */ " 1                dqeptr = DQEP(clp->TaskNo >> 24); 1 2                /* send break to specified task */ 2                                     @  B                asm (" stw  sp,_spsave");	/* save stack pointer */ B A                asm (" ext  S.EXEC13");		/* exec break routine */ A B                asm (" lw   r2,_dqeptr");	/* get dqe addr in r2 */ B 9                asm (" bl   S.EXEC13");		/* go to exec */ 9 ?                asm (" lw   sp,_spsave");	/* get back our sp */ ? <                clp->Status = stComplete;	/* all done now */ <                 break;                   default:                  break;                 } /* end switch */            } /* if our node */  2      } /* if status pending or being processed */ 2   } /* for each client index */  }     5/* routine to handle svc 1,6 init start processing */ 5  /* r7 has node number to save */   instrt()     @  {     F    nodenum = TSAP->regp->reg[7];   /* get node num from callers r7 */ F ?    initDone = FALSE;               /* set init not done yet */ ? }     /* init done SVC */  8/* routine to handle svc 1,7 init complete processing */ 8 indone()  {      if (initDone == FALSE)  2        initDone = TRUE;		/* show init done now */ 2 J    TSAP->regp->reg[7] = initDone;	/* return initDone status to user r7 */ J 3    strtclk = CDOTP->intc;		/* get starting time */ 3 =    realpadr = lear(laddr);		/* get real partition address */ = D    nodep = (struct node *)realpadr;	/* set OSPART part real addr */ D 4    laddr->Active = NodeActive;		/* set us active */ 4 ;    laddr->Flag &= !ShutDown;		/* shut off shutdown flag */ ; }                        @  4/* routine to handle svc 1,8 Task init processing */ 4 $/* r7 returns current node number */ $ '/* r6 returns timer ticks per second */ '    intask()  {      if (initDone) {  K        TSAP->regp->reg[6] = ticksx1;   /* return ticks per second in r6 */ K G        TSAP->regp->reg[7] = nodenum;   /* return nodenum to user r7 */ G     } else {  K        TSAP->regp->reg[6] = ticksx1;   /* return ticks per second in r6 */ K L        TSAP->regp->reg[7] = FALSE;     /* return FALSE status to user r7 */ L     }  }     /* local subroutines */  */* routine to get real address from tsa */ * static int *xlear(addr)  
int *addr; 
 {      int     mapnum;         /* get map number */                                                          @  9    mapnum = (((int)addr & 0xffffff) >> 13) - CDOTP->msd; 9    &    /* return real variable address */ & 0    return ((int *)(((TSAP->midla[mapnum] << 13) 0 -        | ((int)addr & 0x1fff)) & 0xffffff)); - }     !/* routine to get real address */ ! static int *lear(addr)  
int *addr; 
 {  =    asm (" lw   r1,3W,sp");       /* get old stack pointer */ = =    asm (" lw   r1,8W,r1");       /* get callers parameter */ = 4    asm (" lear r0,0w,r1");       /* make it real */ 4 }     /* routine to go unmapped */  static void goumap()  {      asm ("     lpsd  psd1");      asm ("     bound 1d");  '    asm ("psd1 gen   8/x'84',24/goon"); ' #    asm ("     dataw x'00018000'"); #     asm ("goon equ   $");  }                           @  /* routine to go mapped */  static void gomap()  {      asm ("      lpsd  psd2");      asm ("      bound 1d");  (    asm ("psd2  gen   8/x'84',24/gmon"); ( $    asm ("      dataw x'80018000'"); $     asm ("gmon  equ   $");  }     1/* this is the interface code to the clock int */ 1 +/* it is entered at each clock interrupt */ + 3    asm (" bound 1w");             /* word bound */ 3 .    asm ("clki  equ $");           /* entry */ . 2    asm (" stf  r0,lclstk");       /* save regs */ 2 @    asm (" la   sp,lclstk");       /* get local stack address */ @ E    asm (" bl   _rtclk");          /* call real time clock int rtn */ E 5    asm (" lf   r0,0w,sp");        /* restore regs */ 5                                                             @  F    asm ("rtci  nop");             /* execute replaced h.ipcl instr */ F 9    asm ("reti  bu $-$");          /* return to h.ipcl */ 9 4    asm (" res  8f");              /* local stack */ 4 8    asm ("lclstk res 1f");         /* local save area */ 8    ;/* this is the interface code for svc 1,6 Init start svc */ ; 0/* the svc's use t.fssp stack area in the tsa */ 0 3    asm (" bound 1w");             /* word bound */ 3 .    asm ("svc1_6 equ $");          /* entry */ . ?    asm (" lw   r3,x'a80'");       /* get tsa address C.TSAD */ ? D    asm (" lw   sp,x'5bc',r3");    /* get T.FSSP pointer from tsa */ D >    asm (" bl   _instrt");         /* call init svc routine */ > ;    asm (" ext  S.EXEC20");        /* svc return address */ ;                    @  8    asm (" bu   S.EXEC20");        /* return from svc */ 8    :/* this is the interface code for svc 1,7 Init Done svc */ : 0/* the svc's use t.fssp stack area in the tsa */ 0 3    asm (" bound 1w");             /* word bound */ 3 .    asm ("svc1_7 equ $");          /* entry */ . ?    asm (" lw   r3,x'a80'");       /* get tsa address C.TSAD */ ? D    asm (" lw   sp,x'5bc',r3");    /* get T.FSSP pointer from tsa */ D C    asm (" bl   _indone");         /* call init done svc routine */ C ;    asm (" ext  S.EXEC20");        /* svc return address */ ; 8    asm (" bu   S.EXEC20");        /* return from svc */ 8    9/* this is the interface code for svc 1,8 Taskinit svc */ 9 1/* the svc's uses t.fssp stack area in the tsa */ 1                            @  3    asm (" bound 1w");             /* word bound */ 3 .    asm ("svc1_8 equ $");          /* entry */ . ?    asm (" lw   r3,x'a80'");       /* get tsa address C.TSAD */ ? D    asm (" lw   sp,x'5bc',r3");    /* get T.FSSP pointer from tsa */ D B    asm (" bl   _intask");         /* call taskinit svc routine */ B ;    asm (" ext  S.EXEC20");        /* svc return address */ ; 8    asm (" bu   S.EXEC20");        /* return from svc */ 8    static int tcpb[3] = {0,0,0};     ./* routine to type a message on the console */ . static void typ(str)  
char *str; 
 {  
    int i; 
 !    for(i = 1; str[i] != 0; i++); ! 2        tcpb[0] = i << 20 | 0x00080000 | (int)str; 2     asm(" la  r1,_tcpb");      asm(" svc 1,x'3f'");  }                       @  -/* this is the sysgen initialization entry */ -     asm (" lpool");  ;    /* save regs and use as parameters to function sgent */ ; #    asm ("sg.ini stf r0,stack-1f"); #     asm (" la sp,stack-2f");      asm (" bl _sgent");      asm (" lf r0,stack-1f");      asm (" trsw r0");  '    /* stack space for iniialization */ '     asm (" res 12f");      asm ("stack equ $");     %/* instructions used during sysgen */ % F    asm ("bri bu clki");            /* br instruction put in h.ipcl */ F    .sgent(reg0,reg1,reg2,reg3,reg4,reg5,reg6,reg7) . 3int reg0, reg1, reg2, reg3, reg4, reg5, reg6, reg7; 3 {      /* sysgen init code here */     <    asm (" ext  IPCL.ICB");        /* connect to rtc code */ <                                       @  >    asm (" la   r1,IPCL.ICB");     /* get clock icb address */ > 9    asm (" lw   r1,2w,r1");        /* get new psd wd 1 */ 9 >    asm (" adi  r1,2w");           /* skip abm & stf instrs */ > :    asm (" anmw r1,=x'ffffff'");   /* keep address only */ : ;    asm (" lw   r0,=x'ec000000'"); /* get bu instruction */ ; =    asm (" orr  r1,r0");           /* or in return address */ = >    asm (" adi  r0,1w");           /* location to return to */ > A    asm (" stw  r0,reti");         /* set return instr in code */ A >    asm (" lw   r0,0w,r1");        /* get instr from h.ipcl */ > @    asm (" stw  r0,rtci");         /* put instr in local code */ @ E    asm (" lw   r0,bri");          /* get branch to us instruction */ E                                       @  ;    asm (" stw  r0,0w,r1");        /* put in h.ipcl code */ ;    ;    asm (" lw   r1,x'b00'");       /* get C.SVTA address */ ; B    asm (" la   r0,svc1_6");       /* get svc 1,6 routn address */ B C    asm (" stw  r0,6w,r1");        /* put address in svc 1 table */ C B    asm (" la   r0,svc1_7");       /* get svc 1,7 routn address */ B C    asm (" stw  r0,7w,r1");        /* put address in svc 1 table */ C B    asm (" la   r0,svc1_8");       /* get svc 1,8 routn address */ B C    asm (" stw  r0,8w,r1");        /* put address in svc 1 table */ C    B    asm (" li   r7,1");            /* calculate 1 secs of ticks */ B 7    asm (" mpmw r6,x'adc'");       /* ..times C.MTIM */ 7 <    asm (" dvmw r6,x'ae0'");       /* ..divided by C.NTIM */ <            @  >    asm (" stw  r7,_ticksx1");      /* save ticks in 1 secs */ >    B    asm (" li   r7,5");            /* calculate 5 secs of ticks */ B 7    asm (" mpmw r6,x'adc'");       /* ..times C.MTIM */ 7 <    asm (" dvmw r6,x'ae0'");       /* ..divided by C.NTIM */ < >    asm (" stw  r7,_ticksx5");      /* save ticks in 5 secs */ >    I    asm (" lw   r7,=86400");       /* calc 1 day (86400 secs) of ticks */ I 7    asm (" mpmw r6,x'adc'");       /* ..times C.MTIM */ 7 <    asm (" dvmw r6,x'ae0'");       /* ..divided by C.NTIM */ < =    asm (" stw  r7,_ticksday");     /* save ticks in a day */ =    9        return;                    /* return to SYSGEN */ 9 }                                                                                          