  @     	     NAME 	 0          bsearch - binary search a sorted table 0         SYNTAX            #include <search.h>     A          char *bsearch ((char *) key, (char *) base, nel, sizeof A           (*key), compar)            unsigned nel;            int (*compar)( );          DESCRIPTION  C          Bsearch is a binary search routine generalized from Knuth C A          (6.2.1) Algorithm B.  It returns a pointer into a table A C          indicating where a datum may be found.  The table must be C >          previously sorted in increasing order according to a > >          provided comparison function.  Key points to a datum > A          instance to be sought in the table.  Base points to the A                                           @  A          element at the base of the table.  Nel is the number of A F          elements in the table.  Compar is the name of the comparison F D          function, which is called with two arguments that point to D C          the elements being compared.  The function must return an C >          integer less than, equal to, or greater than zero as > F          accordinly the first argument is to be considered less than, F /          equal to, or greater than the second. /         EXAMPLE  C          The example below searches a table containing pointers to C D          nodes consisting of a string and its length.  The table is D E          ordered alphabetically on the string in the node pointed to E           by each entry.                     @  B          This code fragment reads in strings and either finds the B F          corresponding node and prints out the string and its length, F %          or prints an error message. %    !               #include <stdio.h> ! "               #include <search.h> "    '               #define   TABSIZE   1000 '    K               struct node {            /* these are stored in the table */ K !                    char *string; !                     int length;                 };  G               struct node table[TABSIZE];   /* table to be searched */ G                     .                      .                      .                 {  0                    struct node *node_ptr, node; 0                                                    @  J                    int node_compare( );  /* routine to compare 2 nodes */ J I                    char str_space[20];   /* space to read string into */ I                     .                      .                      .  ,                    node.string = str_space; , =                    while (scanf("%s", node.string) != EOF) { = K                         node_ptr = (struct node *)bsearch((char *)(&node), K 8                                 (char *)table, TABSIZE, 8 D                                 sizeof(struct node), node_compare); D 0                         if (node_ptr != NULL) { 0 J                              (void)printf("string = %20s, length = %d\n", J G                                   node_ptr->string, node_ptr->length); G     @  !                         } else { ! K                              (void)printf("not found: %s\n", node.string); K                          }                      }                 }                 /*  ?                    This routine compares two nodes based on an ? >                    alphabetical ordering of the string field. >                */                 int  )               node_compare(node1, node2) ) *               struct node *node1, *node2; *                {  @                    return strcmp(node1->string, node2->string); @                }     
     NOTES 
 D          The pointers to the key and the element at the base of the D F          table should be of type pointer-to-element, and cast to type F            e@            pointer-to-character.     A          The comparison function need not compare every byte, so A E          arbitrary data may be contained in the elements in addition E '          to the values being compared. '    C          Although declared as type pointer-to-character, the value C ?          returned should be cast into type pointer-to-element. ?    
     SEE ALSO 
 2          hsearch.m, lsearch.m, qsort.m, tsearch.m 2         DIAGNOSTICS  F          A NULL pointer is returned if the key cannot be found in the F           table.               (printed 07/29/92)                                                                                                                                                               