(* "@(#)ppppp.p	5.2	7/2/86" *)
program regress;
type
    errstr = packed array[1..10] of char;
    char20 = packed array[1..20] of char;
var
    errors: integer;
    realfile: file of real;

    procedure fail(err: errstr);
    begin
	writeln('fail ', err);
	errors := errors + 1;
    end;

    procedure p1;
    var
	i: integer;
	c: char;

	procedure p2(var i: integer);
	begin
	end; {p2}

    begin
	p2(i);
	i := 97;
	c := chr(i);
	if (c <> 'a') then
	    fail('p1');
    end;

    procedure p2(s: char20; i: integer);
    begin
	if (i <> 13) or (s <> 'string') then
	    fail('p2');
    end; {p2}

    procedure p3;
    var
	s: packed array[1..20] of char;
    begin
	s := 'stuff';
	if s <> 'stuff               ' then
	    fail('p3');
    end; {p3}

    {3/17/86 fixed in alignment.
     Pascal file vars needed to be double word aligned}
    procedure p4;
    var
	r1,r2,r3,r4: real;
    begin
	r1 := 88.76;
	r2 := -99999.76;
	rewrite(realfile);
	write(realfile, r1,r2);
	reset(realfile);
	read(realfile,r3,r4);
	if (r1 <> r3) or (r2 <> r4) then
	    fail('p4');
    end;

    procedure p5;
    const
	name1 = '/tmp/xx1';
	name2 = '/tmp/xx2';
    var
	f: text;
	str: packed array[1..10] of char;
    begin
	rewrite(f, name1);
	writeln(f, 'junk');
	str := '/tmp/xx'; str[8] := '1'; str[9] := chr(0);
	reset(f, str);
	readln(f, str);
	if (str <> 'junk') then
	    fail('1. p5');

	rewrite(f, name2);
	writeln(f, 'Junk');
	str := '/tmp/xx'; str[8] := '2'; str[9] := chr(0);
	reset(f, str);
	readln(f, str);
	if (str <> 'Junk') then
	    fail('2. p5');
    end; {p5}

    {test Pascal type-casting extension}
    procedure p6;
    type
	intptr = ^integer;
	intset = set of 0..31;
	rec = record
	    ip1, ip2: intptr;
	    ist: array[1..10] of intset;
	end;
    var
	i: array[1..10] of integer;
	ipp: intptr;
	ip: rec;
	iset: rec;
    begin
	i[3] := 1766;
	ip.ip2 := i[3]\intptr;
	ipp := ip.ip2;
	i[4] := ipp\integer;
	iset.ist[5] := i[4]\intset;
	if iset.ist[5] <> [21,22,24,25,26,29,30] then
	    fail('1. p6');
	iset.ist[5] := iset.ist[5] - [25];
	if 0x6a6 <> iset.ist[5]\integer then
	    fail('2. p6');
    end;

begin
    errors := 0;
    p1;
    p2('string', 13);
    p3;
    p4;
    p5;
    p6;
    if errors = 0 then
	writeln('pass');
end.
