/* "@(#)winctrl.h	5.1	6/9/86" */

/*  winctrl.h - window control */
/* must include <sys/graf.h> before */

struct WindowArgs {
		int wID;  /* window ID */
		int wFlags; /* window control flags */
		struct Rectangle wFrame; /* window Frame */
		int wFontID; /* window's font ID */
		struct Point wCharSize; /* character width & height */
		};

struct ControlArgs {
		int wID; /* window ID */
		int cFlags1;
		int cFlags2;
		int cFlags3;
		int cFlags4;
		};

struct PointingArgs {
		int wID; /* window ID */
		int buttons;
		struct Point location;
		};

struct WCtlMsg  {
		int wMsgTag; /* message type - entire struct is passed via "ioctl" */
		union {
			int wID; /* window ID */
			struct WindowArgs wArgs;
			struct PointingArgs pArgs;
			struct ControlArgs cArgs;
		      } wMsg;
		};

				/* bits in WindowArgs.wFlags */
#define WFAwake		000001 	/* window is "awake" allowing I/O */
#define WFRetainGraf	000002	/* window retains graphics */
#define WFCurson	000004	/* text input cursor is shown */
#define WFMode		000070	/* mode bits */
#define WFASCII		000000	/* ASCII, no interpretation of ESC sequences */
#define WFANSIX3_64	000010	/* ANSI X3.64 (VT-100) ESC sequences */
#define WFTek4014	000020	/* Tektronix 4014 ESC sequences */
#define WFCGI		000030	/* Computer Graphics Interface commands */
				/* event mode bits in wFlags */
#define EMButtonMask	001700	/* button bits */
#define EMButtonRShift	     6	/* shift right by this to right-justify */
#define EMRightButton	000100	/* right button */
#define EMMiddleButton	000200	/* middle button */
#define EMLeftButton	000400	/* left button */
#define EMOtherButtons	001000	/* other buttons */
#define EMQueueKB	002000	/* queue keyboard events */
#define EMQueueLoc	004000	/* queue locator events */
#define EMLocCoords	010000	/* window or screen relative locator coords */
#define EMLocMotion	020000	/* only button changes, or any motion */
#define EMSigIOKB	040000	/* signal I/O from keyboard */
#define EMSigIOLoc     0100000	/* signal I/O from locator */
				/* more window flags */
#define WFDeferUpdates 0200000	/* defer screen updates */

				/* wMsgTag values */
#define WMTRegWM	  1	/* register caller as window manager */
#define WMTRegMouse	  2	/* register caller as mouse manager */
#define WMTUnregWM	  3	/* unregister window manager */
#define WMTGetWN	  10	/* get window number */
#define WMTGetA		  11	/* get window's arguments */
#define WMTSetA		  12	/* set window's arguments */
#define WMTEraseW	  13	/* erase window */
#define WMTShowW	  14	/* display window */
#define WMTSelectW	  15	/* select window as current input window */
#define WMTGetWName	  16	/* get window name */
#define WMTCompF	  17	/* complement given frame twice */
#define WMTSetCL	  18	/* set cursor location */
#define WMTRedraw	  19	/* redraw all windows */
#define WMTGetText	  20	/* get text line at given window row */
#define WMTFindW	  21	/* find window containing given point */
#define WMTMenu		  22	/* pop up menu */
#define WMTGetCW	  23	/* get current window number */
#define WMTKillW	  24	/* kill all processes associated with window */
#define WMTUnderW	  25	/* push window under all others */
#define WMTNextW	  26	/* get next window behind given window */
#define WMTDefineFont	  27	/* define font ID with given file name */
#define WMTFontName	  28	/* get file name of given font ID */
#define WMTGetTitle	  29	/* get window's title */
#define WMTSetTitle	  30	/* set window's title */
#define WMTHiliteText	  31	/* highlight text in a window */

#define WMTClearBitsW	 101	/* clear window without updating screen */
#define WMTUpdateScreen	 102	/* update screen by writing entire bitmap */
#define WMTSetPenWidth	 103	/* set window's pen width */
#define WMTSetPenColor	 104	/* set window's pen color */
#define WMTGetPenWidth	 105	/* get window's pen width */
#define WMTGetPenColor	 106	/* get window's pen color */
