/* "@(#)termio.h	5.1	6/9/86" */
/* This include file contains Ridge specific data. */

#include <ros/termio.h>

/*
 *	Control character indexes for termio.c_cc.
 */

#define	NCC		ATT_NCC

#define	VINTR		ATT_VINTR
#define	VQUIT		ATT_VQUIT
#define	VERASE		ATT_VERASE
#define	VKILL		ATT_VKILL
#define	VEOF		ATT_VEOF
#define	VEOL		ATT_VEOL
#define	VEOL2		ATT_VEOL2
#define	VSWTCH		ATT_VSWTCH
#define	VMIN		ATT_VMIN
#define	VTIME		ATT_VTIME

/*
 *	Default control characters
 */

#define	CNUL		ATT_CNUL
#define	CDEL		ATT_CDEL
#define	CESC		ATT_CESC
#define	CSTART		ATT_CSTART	/* cntl	q */
#define	CSTOP		ATT_CSTOP	/* cntl	s */

#define	CINTR		ATT_CINTR	/* DEL */
#define	CQUIT		ATT_CQUIT	/* FS, cntl | */
#define	CERASE		ATT_CERASE	/* control-H */
#define	CKILL		ATT_CKILL	/* control-X */
#define	CEOF		ATT_CEOF	/* cntl	d */
#define CSWTCH		ATT_CSWTCH	/* cntl z */
#define CNSWTCH 	ATT_CNSWTCH


/*
 *	Input modes
 */

#define	IGNBRK		ATT_IGNBRK
#define	BRKINT		ATT_BRKINT
#define	IGNPAR		ATT_IGNPAR
#define	PARMRK		ATT_PARMRK
#define	INPCK		ATT_INPCK
#define	ISTRIP		ATT_ISTRIP
#define	INLCR		ATT_INLCR
#define	IGNCR		ATT_IGNCR
#define	ICRNL		ATT_ICRNL
#define	IUCLC		ATT_IUCLC
#define	IXON		ATT_IXON
#define	IXANY		ATT_IXANY
#define	IXOFF		ATT_IXOFF

/*
 *	Output modes
 */

#define	OPOST		ATT_OPOST
#define	OLCUC		ATT_OLCUC
#define	ONLCR		ATT_ONLCR
#define	OCRNL		ATT_OCRNL
#define	ONOCR		ATT_ONOCR
#define	ONLRET		ATT_ONLRET
#define	OFILL		ATT_OFILL
#define	OFDEL		ATT_OFDEL
#define	NLDLY		ATT_NLDLY
#define	NL0		ATT_NL0
#define	NL1		ATT_NL1
#define	CRDLY		ATT_CRDLY
#define	CR0		ATT_CR0
#define	CR1		ATT_CR1
#define	CR2		ATT_CR2
#define	CR3		ATT_CR3
#define	TABDLY		ATT_TABDLY
#define	TAB0		ATT_TAB0
#define	TAB1		ATT_TAB1
#define	TAB2		ATT_TAB2
#define	TAB3		ATT_TAB3
#define	BSDLY		ATT_BSDLY
#define	BS0		ATT_BS0
#define	BS1		ATT_BS1
#define	VTDLY		ATT_VTDLY
#define	VT0		ATT_VT0
#define	VT1		ATT_VT1
#define	FFDLY		ATT_FFDLY
#define	FF0		ATT_FF0
#define	FF1		ATT_FF1
#define	OCRCRNL		ATT_OCRCRNL

/*
 *	Control modes
 */

#define	CBAUD		ATT_CBAUD
#define	B0		ATT_B0
#define	B50		ATT_B50
#define	B75		ATT_B75
#define	B110		ATT_B110
#define	B134		ATT_B134
#define	B150		ATT_B150
#define	B200		ATT_B200
#define	B300		ATT_B300
#define	B600		ATT_B600
#define	B1200		ATT_B1200
#define	B1800		ATT_B1800
#define	B2400		ATT_B2400
#define	B4800		ATT_B4800
#define	B9600		ATT_B9600
#define	EXTA		ATT_EXTA
#define	EXTB		ATT_EXTB
#define	B19200		ATT_B19200
#define	CSIZE		ATT_CSIZE
#define	CS5		ATT_CS5
#define	CS6		ATT_CS6
#define	CS7		ATT_CS7
#define	CS8		ATT_CS8
#define	CSTOPB		ATT_CSTOPB
#define	CREAD		ATT_CREAD
#define	PARENB		ATT_PARENB
#define	PARODD		ATT_PARODD
#define	HUPCL		ATT_HUPCL
#define	CLOCAL		ATT_CLOCAL
#define	CAUTO		ATT_CAUTO


/*
 *	Modes for line discipline 0
 */

#define	ISIG		ATT_ISIG
#define	ICANON		ATT_ICANON
#define	XCASE		ATT_XCASE
#define	ECHO		ATT_ECHO
#define	ECHOE		ATT_ECHOE
#define	ECHOK		ATT_ECHOK
#define	ECHONL		ATT_ECHONL
#define	NOFLSH		ATT_NOFLSH


/*
 *	Ridge extensions to modes for line discipline 0
 */

#define	LINTRUP		ATT_LINTRUP
#define	ECHOI		ATT_ECHOI

#define	SSPEED		ATT_SSPEED	/* default speed */


/*
 * Ioctl control packet
 */

/* included above in <ros/termio.h> */


#include <ros/ioctl.h>

#define	TCGETA		ATT_TCGETA
#define	TCSETA		ATT_TCSETA
#define	TCSETAW		ATT_TCSETAW
#define	TCSETAF		ATT_TCSETAF
#define	TCSBRK		ATT_TCSBRK
#define	TCXONC		ATT_TCXONC
#define	TCFLSH		ATT_TCFLSH
#define	TCDSET		ATT_TCDSET

#define	LDOPEN		ATT_LDOPEN
#define	LDCLOSE		ATT_LDCLOSE
#define	LDCHG		ATT_LDCHG
#define	LDGETT		ATT_LDGETT
#define	LDSETT		ATT_LDSETT


/*
 * Ioctl codes for Ridge Bit Map Display
 */

#define BCGETSZ 	ROS_BCGETSZ
#define BCCURSON 	ROS_BCCURSON
#define BCSCTL 		ROS_BCSCTL
#define BCRCTL 		ROS_BCRCTL
#define BCVAL 		ROS_BCVAL
#define BCGETTYPE	ROS_BCGETTYPE
#define BCSETCNTLW	ROS_BCSETCNTLW
#define BCINVRT		ROS_BCINVRT


/*
 * Ioctl codes for Ridge Mouse
 */

#define MOUSEGET	ROS_MOUSEGET
#define MOUSESET	ROS_MOUSESET


/*
 * Terminal types
 */
#define	TERM_NONE	ATT_TERM_NONE	/* tty */
#define	TERM_TEC	ATT_TERM_TEC	/* TEC Scope */
#define	TERM_V61	ATT_TERM_V61	/* DEC VT61 */
#define	TERM_V10	ATT_TERM_V10	/* DEC VT100 */
#define	TERM_TEX	ATT_TERM_TEX	/* Tektronix 4023 */
#define	TERM_D40	ATT_TERM_D40	/* TTY Mod 40/1	*/
#define	TERM_H45	ATT_TERM_H45	/* Hewlitt-Packard 45 */
#define	TERM_D42	ATT_TERM_D42	/* TTY Mod 40/2B */


/*
 * Terminal flags
 */

#define	TM_NONE		ATT_TM_NONE	/* use default flags */
#define	TM_SNL		ATT_TM_SNL	/* special newline flag	*/
#define	TM_ANL		ATT_TM_ANL	/* auto	newline	on column 80 */
#define	TM_LCF		ATT_TM_LCF	/* last	col of last row	special	*/
#define	TM_CECHO	ATT_TM_CECHO	/* echo	terminal cursor	control	*/
#define	TM_CINVIS	ATT_TM_CINVIS	/* do not send esc seq to user */
#define	TM_SET		ATT_TM_SET	/* must	be on to set/res flags */


/*
 * structure of	ioctl arg for LDGETT and LDSETT
 */

/* included above in <ros/termio.h> */
