/* "@(#)signal.h	5.1	6/9/86" */

/* System V -- Signals */

#define SIGVBASE 1      /* Base of System V signals                        */
#define SIGVMAX  19     /* Last System V signal                            */
#define	NSIG	 20     /* Number of System 5 signals */

#define	SIGHUP	1	/* hangup                                          */
#define	SIGINT	2	/* interrupt (rubout)                              */
#define	SIGQUIT	3	/* quit (ASCII FS)                                 */
#define	SIGILL	4	/* illegal instruction (not reset when caught)     */
#define	    ILL_RESAD_FAULT	0x0	/* reserved addressing fault */
#define	    ILL_PRIVIN_FAULT	0x1	/* privileged instruction fault */
#define	SIGTRAP	5	/* trap 2,trace trap (not reset when caught)       */
#define	SIGIOT	6	/* Unused signal type                              */
#define	SIGEMT	7	/* trap 3,emulator trap                            */
#define	SIGFPE	8	/* floating point exception                        */
#define	    FPE_INTOVF_TRAP	0x1	/* integer overflow */
#define	    FPE_INTDIV_TRAP	0x2	/* integer divide by zero */
#define	    FPE_FLTOVF_TRAP	0x3	/* floating overflow */
#define	    FPE_FLTDIV_TRAP	0x4	/* floating/decimal divide by zero */
#define	    FPE_FLTUND_TRAP	0x5	/* floating underflow */
#define	    FPE_SUBRNG_TRAP	0x7	/* subscript out of range */
#define	SIGKILL	9	/* kill (cannot be caught or ignored)              */
#define	SIGBUS	10	/* bus error                                       */
#define     BUS_ALIGN_FAULT	0x1	/* data alignment fault */
#define	SIGSEGV	11	/* segmentation violation                          */
#define	    SEG_CODE_SEGMENT	0x00000	/* faulted in code segment */
#define	    SEG_DATA_SEGMENT	0x00001	/* faulted in data segment */
#define	    SEG_OVER_SOFT_LIM	0x10000	/* faulted past soft limit */
#define	    SEG_OVER_HARD_LIM	0x20000	/* faulted past hard limit */
#define	    SEG_CANT_GROW_SEG	0x40000	/* could not grow data file */
#define	    SEG_QUEUE_SEGMENT	0x00002	/* faulted in queue segment */
#define	SIGSYS	12	/* bad argument to system call                     */
#define	SIGPIPE	13	/* write on a pipe with no one to read it          */
#define	SIGALRM	14	/* alarm clock                                     */
#define	SIGTERM	15	/* software termination signal from kill           */
#define	SIGUSR1	16	/* user defined signal 1                           */
#define	SIGUSR2	17	/* user defined signal 2                           */
#define SIGCLD  18      /* death of a child.                 [unsupported] */
#define	SIGPWR	19	/* power-fail restart                [unsupported] */




/* Berkeley 4.2 -- Signals */
#define SIGBERKBASE  50    /* Base of berkeley signals                     */
#define SIGBERKMAX   61    /* Last Berkeley signal                         */

#define SIGURG       50    /* urgent condition on socket     		   */
#define SIGSTOP      51    /* stop                           		   */
#define SIGTSTP      52    /* terminal generated stop        		   */
#define SIGCONT      53    /* continue after stop            		   */
#define SIGCHLD      54    /* child status has changed       		   */
#define SIGTTIN      55    /* background read attempted      		   */
#define SIGTTOU      56    /* background write attempted     		   */
#define SIGIO        57    /* I/O is possible on descriptor                */
#define SIGXCPU      58    /* exceeded CPU time limit        [unsupported] */
#define SIGXFSZ      59    /* exceeded file size limit       [unsupported] */
#define SIGVTALRM    60    /* virtual alarm                  [unsupported] */
#define SIGPROF      61    /* profile timer alarm            [unsupported] */


/* ROS signals */
/* Note: Some of the System V signals control groups of ros signals        */
/*       For example, SIGFPE, controls, SIGREALOVER, SIGREALUNDER, and     */
/*       SIGREALDIVZERO                                                    */

#define SIGROSBASE      100   /* First Ros signal                          */
#define SIGROSMAX       132   /* Last Ros signal                           */
#define SIGRBUG         100   /* trap 0, enter rbug                        */
#define SIGDEBUG        101   /* trap 1, enter program debugger            */
#define SIGTRACE        102   /* trap 2, trace trap                        */
#define SIGEMULATE      103   /* trap 3, emulator trap                     */
#define SIGTRAP4        104   /* trap 4,  unused                           */
#define SIGTRAP5        105   /* trap 5,  unused                           */
#define SIGTRAP6        106   /* trap 6,  unused                           */
#define SIGTRAP7        107   /* trap 7,  unused                           */
#define SIGTRAP8        108   /* trap 8,  unused                           */
#define SIGTRAP9        109   /* trap 9,  unused                           */
#define SIGTRAP10       110   /* trap 10, unused                           */
#define SIGTRAP11       111   /* trap 11, unused                           */
#define SIGTRAP12       112   /* trap 12, unused                           */
#define SIGTRAP13       113   /* trap 13, unused                           */
#define SIGTRAP14       114   /* trap 14, unused                           */
#define SIGTRAP15       115   /* trap 15, unused                           */
#define SIGINTOVER      116   /* trap 16, Integer Overflow                 */
#define SIGINTDIVZERO   117   /* trap 17, divide by Zero                   */
#define SIGREALOVER     118   /* trap 18, real overflow                    */
#define SIGREALUNDER    119   /* trap 19, real underflow                   */
#define SIGREALDIVZERO  120   /* trap 20, read divide by zero              */
#define SIGTRAP21       121   /* trap 21, unused                           */
#define SIGTRAP22       122   /* trap 22, unused                           */
#define SIGTRAP23       123   /* trap 23, unused                           */
#define SIGTRAP24       124   /* trap 24, unused                           */
#define SIGTRAP25       125   /* trap 25, unused                           */
#define SIGTRAP26       126   /* trap 26, unused                           */
#define SIGTRAP27       127   /* trap 27, unused                           */
#define SIGTRAP28       128   /* trap 28, unused                           */
#define SIGTRAP29       129   /* trap 29, unused                           */
#define SIGTRAP30       130   /* trap 30, unused                           */
#define SIGPWRON        131   /* power went back on          [unsupported] */
#define SIGBOUNDS       132   /* Exceeded array bounds       [unsupported] */

/* Signal Actions */
#define	SIG_DFL	(int (*)())0  /* Terminate proc */
#if lint
#define	SIG_IGN	(int (*)())0
#else
#define	SIG_IGN	(int (*)())1  /* ignore signal  */
#endif
#define SIG_DBG (int (*)())3  /* go into debugger (/ros/debug) */


/*
 *	Context from which process state is restored after signal handler returns.
 */

#include <sys/procstate.h>

struct sigcontext {
    int			sc_onstack;		/* onstack flag to be restored */
    int			sc_mask[3];		/* mask array to be restored */
    char		sc_instruction[8];	/* current instruction bytes */
    stateRecord		sc_pstate;		/* process state record */
};
