/* "@(#)ctio.h	5.1	6/9/86" */
/*
    ctio.h
    	structures and definitions for cartridge tape ioctl commands
*/
#include <ros/ioctl.h>

/* 
** structure for CTIOCTOP - cartridge tape op command 
*/
struct	ctop
{
    short ct_op;    	/* operations from list below */
    daddr_t ct_count;	/* how many operations to perform */
};

/* 
** operations 
*/
#define CTWEOF	0   /* write an end of file record */
#define CTFSF	1   /* forward space file */
#define CTFSR	2   /* forward space record */
#define CTREW	3   /* rewind tape */
#define CTEOD	4   /* seek to end of data on tape */
#define CTNOP	5   /* no operation, set status only */
#define CTRET	6   /* perform retention op on tape */

/* 
** structure for CTIOCGET cartridge tape get-status command 
*/
struct ctget
{
    short   ct_type;
    /* these values are device dependent */
    int     ct_soft_er;    /* msb of short error count */
    char    ct_err_cd;	    /* device error codes */
    char    ct_sense_info;  /* device sense info */
    int	    ct_resid;	    /* residual count */
    /* end device-dependent values */
};

/* 
** constant for mt_type 
*/
#define CT_540	1

#define CTIOCTOP    _IOW(c,1,struct ctop)    /* do a cartridge tape op */
#define CTIOCGET    _IOR(c,2,struct ctget)    /* get tape status */

