/* "@(#)physmem.h	5.1	6/9/86" */
CONSTANT(PMFileBuf,	HEX(31000))	/*Start of File buffers */
CONSTANT(PMFDLPCmd,	HEX(3C000))	/*FDLP default command blocks */
CONSTANT(PMHDCmd,	HEX(3C100))	/*HD (ANSI) default command blocks */
CONSTANT(PMRTLInt,	HEX(3C200))	/*'fake' IOIR storage for RTLEMU */
CONSTANT(PMRTLIntEnd,	HEX(3C280))	/*'fake' IOIR storage for RTLEMU end */
CONSTANT(PMHWBoot,	HEX(3C300))	/*headwall:time / boot info(12 bytes) */
CONSTANT(PMHWSwitch,	HEX(3C301))	/*headwall:dip switch settings */
CONSTANT(PMHWYM,	HEX(3C302))	/*headwall:year and month (haflword) */
CONSTANT(PMHWDHMS,	HEX(3C304))	/*headwall:Day, hour, min, sec */
CONSTANT(PMHWBootAux,	HEX(3C308))	/*headwall:Aux boot info */
CONSTANT(PMFCBBase,	HEX(3C800))	/*file control block base */
CONSTANT(PMFCBEnd,	HEX(3C960))	/*file control block ... end */
CONSTANT(PMRBUGStack,	HEX(3CC00))	/*RBUG stack */
CONSTANT(PMRBUGBits,	HEX(3D800))	/*RBUG dispdriver bit map line buffer */
CONSTANT(PMRBUGCode1,	HEX(3E000))	/*RBUG code */
CONSTANT(PMRBUGCode2,	HEX(3F000))	/*RBUG code */
CONSTANT(PMRBUGCode3,	HEX(40000))	/*RBUG code */

/* virtual offset for priv. process real memory mapping */
CONSTANT(VMVirtIOPage,	HEX(80000))	/* .. virtual page number */
CONSTANT(VMVirtIOOffs,	HEX(80000000))	/* .. virtual offset */

/* codes for headwall boot reason byte and aux boot byte */
CONSTANT(PMHWBPowerOn,	HEX(1))		/* power on boot */
CONSTANT(PMHWBSwitchS,	HEX(2))		/* front panel slow boot */
CONSTANT(PMHWBSwitchF,	HEX(3))		/* front panel fast boot */
CONSTANT(PMHWBBO0,	HEX(4))		/* clock command BO [0] */
CONSTANT(PMHWBBO1,	HEX(5))		/* clock command BO 1 */
CONSTANT(PMHWBRE0,	HEX(6))		/* clock command RE [0] */
CONSTANT(PMHWBRE1,	HEX(7))		/* clock command RE 1 */
CONSTANT(PMHWBReq0,	HEX(8))		/* serial (cpu request) command slow */
CONSTANT(PMHWBReq1,	HEX(9))		/* serial (cpu request) command fast */
/* bits in headwall boot reason byte */
/* low bit of boot reason byte is fast / slow indicator */
CONSTANT(PMHWBFast,	HEX(1))		/* fast boot bit */
/* high bit of boot reason byte is diagnostic mode indicator */
CONSTANT(PMHWBDiag,	HEX(80))	/* Diagnostic mode enabled */

/* bits in the headwall switch byte */
CONSTANT(PMHWSwBDMask,	HEX(C0))	/* Mask for boot device */
CONSTANT(PMHWSw8bit,	HEX(20))	/* 8 bits/char (0==>7bits/char) */
CONSTANT(PMHWSwOddPar,	HEX(10))	/* Odd parity (0==>even parity) */
CONSTANT(PMHWSwNoPar,	HEX(08))	/* parity disabled (0==>enabled) */
CONSTANT(PMHWSwSpeed,	HEX(07))	/* speed code */
CONSTANT(PMHWSwSp9600,	HEX(00))	/* 9600 */
CONSTANT(PMHWSwSp300,	HEX(01))	/* 300 */
CONSTANT(PMHWSwSp1200,	HEX(02))	/* 1200 */
CONSTANT(PMHWSwSp2400,	HEX(03))	/* 2400 */
CONSTANT(PMHWSwSp4800,	HEX(04))	/* 4800 */
CONSTANT(PMHWSwSp9600a,	HEX(05))	/* 9600 */
CONSTANT(PMHWSwSp19200,	HEX(06))	/* 19200 */
CONSTANT(PMHWSwSp1200a,	HEX(07))	/* 1200 */
