/* "@(#)nettab.h	5.1	7/2/86" */

/* 
 * Data structures to be used with SIOCGNETTAB ioctl.
 */

#ifndef _ROS_NETTAB_
#define _ROS_NETTAB_

#include <net/route.h>
#include <net/if.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_pcb.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/ip_var.h>
#include <netinet/icmp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_seq.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <machine/param.h>

/*
 * A little bit of information about this ioctl is in order.
 * The intent of the ioctl is to replace the need to read /dev/kmem
 * in a normal BSD 4.2 environment.  To this end, a number of
 * network tables have been identified (by the act of porting route
 * and netstat), which can now be accessed via this call.
 *
 * The datablock passed with the call consists of 3 ints worth of
 * header data, and a variable block.  The header data is as follows:
 *
 * 	On Input:
 *
 *		km_table	The table number to be read
 *		km_key		A possible starting place in the table
 *		km_index	Used with km_key
 *
 *	On Output:
 *
 *		km_numentries	If zero - end of table reached, else
 *				the data is valid.
 *		km_key		Magic handle where you currently read
 *		km_index	Used with km_key.
 *
 * Note that km_key/km_index, while they may at times contain addresses
 * into the running ns, will NEVER be treated as an address.  They are
 * used simply as tokens to locate where in the table you where.  This means
 * that a search of the table is needed each time, but such is the price
 * for a bit of security (and lord knows - its faster than a /dev/kmem read!)
 *
 */

struct kmempagehdr {
	int	km_numentries;
	int	km_key;
	int	km_index;
};

union kmempage {
	struct {
		int	km_table;
		int	km_key;
		int	km_index;
	} writeparm;
	struct {				/* RTHOSTTABLE/RTNETTABLE */
		struct kmempagehdr rp_hdr;
		struct rtentry rp_rtentry;
		struct ifnet rp_ifnet;
		char if_name[16];
	} rtparm;
	struct {				/* RTSTATISTICS */
		struct kmempagehdr rs_hdr;
		struct rtstat rs_entry;
	} rsparm;
	struct {				/* IFTABLE */
		struct kmempagehdr if_hdr;
		struct ifnet if_ifnet;
		char if_name[16];
	} ifparm;
	struct {				/* TCPPCB/UDPPCB */
		struct kmempagehdr pb_hdr;
		struct inpcb pb_blk;
		struct socket pb_socket;
		struct tcpcb pb_tcpblk;
	} pbparm;
	struct {				/* TCPSTATS */
		struct kmempagehdr ts_hdr;
		struct tcpstat ts_stat;
	} tsparm;
	struct {				/* UDPSTATS */
		struct kmempagehdr ud_hdr;
		struct udpstat ud_stat;
	} udparm;
	struct {				/* IPSTATS */
		struct kmempagehdr ip_hdr;
		struct ipstat ip_stat;
	} ipparm;
	struct {				/* ICMPSTATS */
		struct kmempagehdr ic_hdr;
		struct icmpstat ic_stat;
	} icparm;
	char kp_data[PageSize];
};

#define RTHOSTTABLE	1			/* Host table routing entry */
#define RTNETTABLE	2			/* Network routing entry */
#define RTSTATISTICS	3			/* Routing statistics */
#define IFTABLE		4			/* Interface table entry */
#define TCPPCB		5			/* TCP Protocol Blocks */
#define UDPPCB		6			/* UDP Protocol Blocks */
#define	TCPSTATS	7			/* TCP statistics */
#define UDPSTATS	8			/* UDP statistics */
#define IPSTATS		9			/* IP statistics */
#define ICMPSTATS	10			/* ICMP statistics */

#endif	_ROS_NETTAB_
