/* "@(#)ioctl.h	5.2	7/2/86" */

/* THIS HEADER FILE CONTAINS RIDGE SPECIFIC INFORMATION */
/* THIS FILE HAS SOME LOOOONG LINES ... SORRY */

/*
 * 'Complete' ioctl definitions
 */

#ifndef	_ROS_IOCTL_
#define	_ROS_IOCTL_

/*
 * Ioctl's have the command encoded in the lower halfword,
 * and the size of any in or out parameters in the upper
 * halfword.  The high 2 bits of the upper half are used
 * to encode the in/out status of the parameter; for now
 * we restrict parameters to at most 128 bytes.
 */

/*
	characters for ioctl commands are assigned as follows:

	D - ??? LD*
	M - magnetic tape
	T - tty (AT&T)
	U - User Monitor (special cased ioctls - be careful adding new ones
	                  because the old ones are spread all over this file)
	X - ST* (see stermio.h)
	b - display
	d - DR11
	f - fcntls
	i - network (???)
	l - line printer
	m - mouse
	r - network (???)
	s - network (???)
	t - tty (BSD)
	v - Versatec printer/plotter
*/

/*
 *  The following 2 sections are provided for compatability
 *  with past header files.  The use of these symbols to
 *  distinguish an ioctl type is strongly discouraged.
 */

#define LP_LETTER	'l'
#define TC_LETTER	'T'
#define LD_LETTER	'D'
#define B_LETTER	'b'
#define MOUSE_LETTER	'm'
#define VP_LETTER	'v'

#define IOCTYPE		0x0000FF00
#define LPR		(LP_LETTER<<8)
#define TIOC		(TC_LETTER<<8)
#define LDIOC		(LD_LETTER<<8)
#define BIOC		(B_LETTER<<8)
#define MOUSEIOC	(MOUSE_LETTER<<8)
#define VPR		(VP_LETTER<<8)

#define	IOC_IN		(0x80000000)		/* copy in parameters */
#define	IOC_OUT		(0x40000000)		/* copy out parameters */
#define	IOC_NEW		 0x20000000		/* marks this a new style ioctl */
#define IOC_PAGE         0x10000000		/* full page sent or recieved */
#define	IOCPARM_MASK	 0x007f			/* parameters must be < 128 bytes */
#define	IOC_VOID	(0x00000000)		/* no parameters */
#define	IOC_INOUT	(IOC_IN|IOC_OUT)	/* copy parameters both in and out */

#define	_IO(x,y)	(IOC_VOID |IOC_NEW|0                             |('x'<<8)|y)
#define	_IOR(x,y,t)	(IOC_OUT  |IOC_NEW|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
#define	_IOW(x,y,t)	(IOC_IN   |IOC_NEW|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
#define	_IOWR(x,y,t)	(IOC_INOUT|IOC_NEW|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
#define	_IOR_PAGE(x,y)	(IOC_OUT  |IOC_NEW|IOC_PAGE                      |('x'<<8)|y)
#define	_IOW_PAGE(x,y)	(IOC_IN   |IOC_NEW|IOC_PAGE                      |('x'<<8)|y)
#define	_IOWR_PAGE(x,y)	(IOC_INOUT|IOC_NEW|IOC_PAGE                      |('x'<<8)|y)
#define	_IO_IM(x,y,t)	(IOC_VOID |IOC_NEW|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)

#define OLD_IOC_REF	0x00000000
#define OLD_IOC_IMMED	0x80000000

#define _OLD_IO(x,y)		(OLD_IOC_REF  |('x'<<8)|y)
#define _OLD_IO_IMMED1(x,y)	(OLD_IOC_IMMED|('x'<<8)|y)
#define _OLD_IO_IMMED2(x,y)	(            -(('x'<<8)|y))

/*
 * ?????
 */

#define	OLD_LDOPEN		_OLD_IO(D, 0)
#define	OLD_LDCLOSE		_OLD_IO(D, 1)
#define	OLD_LDCHG		_OLD_IO(D, 2)
#define	OLD_LDGETT		_OLD_IO(D, 8)
#define	OLD_LDSETT		_OLD_IO(D, 9)

/*
 * magnetic tape ioctl commands
 */

#define	BSD_MTIOCTOP		_IOW(M, 1, struct mtop)		/* do a mag tape op */
#define	BSD_MTIOCGET		_IOR(M, 2, struct mtget)	/* get tape status */

/*
 * tty ioctl commands
 */

#define	ATT_TCGETA		_IOR(T, 1, struct termio)
#define	ATT_TCSETA		_IOW(T, 2, struct termio)
#define	ATT_TCSETAW		_IOW(T, 3, struct termio)
#define	ATT_TCSETAF		_IOW(T, 4, struct termio)
#define	ATT_TCSBRK		_IO_IM(T, 5, int)
#define	ATT_TCXONC		_IO_IM(T, 6, int)
#define	ATT_TCFLSH		_IO_IM(T, 7, int)

#define	OLD_TCGETA		_OLD_IO(T, 1)
#define	OLD_TCSETA		_OLD_IO(T, 2)
#define	OLD_TCSETAW		_OLD_IO(T, 3)
#define	OLD_TCSETAF		_OLD_IO(T, 4)
#define	OLD_TCSBRK		_OLD_IO_IMMED1(T, 5)
#define	OLD_TCXONC		_OLD_IO_IMMED1(T, 6)
#define	OLD_TCFLSH		_OLD_IO_IMMED1(T, 7)

#define	BSD_TIOCGETD		_IOR(t, 0, int)			/* get line discipline */
#define	BSD_TIOCSETD		_IOW(t, 1, int)			/* set line discipline */
#define	BSD_TIOCHPCL		_IO(t, 2)			/* hang up on last close */
#define	BSD_TIOCMODG		_IOR(t, 3, int)			/* get modem control state */
#define	BSD_TIOCMODS		_IOW(t, 4, int)			/* set modem control state */
#define		BSD_TIOCM_LE		0001			/* line enable */
#define		BSD_TIOCM_DTR		0002			/* data terminal ready */
#define		BSD_TIOCM_RTS		0004			/* request to send */
#define		BSD_TIOCM_ST		0010			/* secondary transmit */
#define		BSD_TIOCM_SR		0020			/* secondary receive */
#define		BSD_TIOCM_CTS		0040			/* clear to send */
#define		BSD_TIOCM_CAR		0100			/* carrier detect */
#define		BSD_TIOCM_CD		TIOCM_CAR
#define		BSD_TIOCM_RNG		0200			/* ring */
#define		BSD_TIOCM_RI		TIOCM_RNG
#define		BSD_TIOCM_DSR		0400			/* data set ready */
#define	BSD_TIOCGETP		_IOR(t, 5,struct sgttyb)	/* get parameters -- gtty */
#define	BSD_TIOCSETP		_IOW(t, 6,struct sgttyb)	/* set parameters -- stty */
#define	BSD_TIOCSETN		_IOW(t, 7,struct sgttyb)	/* as above, but no flushtty */
#define	BSD_TIOCEXCL		_IO(t, 8)			/* set exclusive use of tty */
#define	BSD_TIOCNXCL		_IO(t, 9)			/* reset exclusive use of tty */
#define	BSD_TIOCFLUSH		_IOW(t, 10, int)		/* flush buffers */
#define	BSD_TIOCSETC		_IOW(t, 11,struct tchars)	/* set special characters */
#define	BSD_TIOCGETC		_IOR(t, 12,struct tchars)	/* get special characters */
#define		BSD_TANDEM		0x00000001	/* send stopc on out q full */
#define		BSD_CBREAK		0x00000002	/* half-cooked mode */
#define		BSD_LCASE		0x00000004	/* simulate lower case */
#define		BSD_ECHO		0x00000008	/* echo input */
#define		BSD_CRMOD		0x00000010	/* map \r to \r\n on output */
#define		BSD_RAW			0x00000020	/* no i/o processing */
#define		BSD_ODDP		0x00000040	/* get/send odd parity */
#define		BSD_EVENP		0x00000080	/* get/send even parity */
#define		BSD_ANYP		0x000000c0	/* get any parity/send none */
	/* NOTE: These delay values have been redefined to correspond to System V values  */
	/*       Also not the strange names of the VTDELAY values ... yes, it's right     */
	/*       from the 4.2 source.                                                     */
#define		BSD_NLDELAY		0x00000100	/* \n delay */
#define			BSD_NL0		0x00000000
#define			BSD_NL1		0x00000100	/* tty 37 */
#define			BSD_NL2		0x00000100	/* vt05 */
#define			BSD_NL3		0x00000000
#define		BSD_CRDELAY		0x00000600	/* \r delay */
#define			BSD_CR0		0x00000000
#define			BSD_CR1		0x00000200	/* tn 300 */
#define			BSD_CR2		0x00000400	/* tty 37 */
#define			BSD_CR3		0x00000600	/* concept 100 */
#define		BSD_TBDELAY		0x00001800	/* horizontal tab delay */
#define			BSD_TAB0	0x00000000
#define			BSD_TAB1	0x00000800	/* tty 37 */
#define			BSD_TAB2	0x00001000
#define			BSD_XTABS	0x00001800	/* expand tabs on output */
#define		BSD_BSDELAY		0x00002000	/* \b delay */
#define			BSD_BS0		0x00000000
#define			BSD_BS1		0x00002000
#define		BSD_VTDELAY		0x00004000	/* vertical tab delay */
#define			BSD_FF0		0x00000000
#define			BSD_FF1		0x00004000	/* tty 37 */
#define		ROS_FFDELAY		0x00008000	/* vertical tab delay */
#define			ROS_FF0		0x00000000
#define			ROS_FF1		0x00008000	/* tty 37 */
#define		BSD_ALLDELAY		(BSD_NLDELAY|BSD_CRDELAY|BSD_TBDELAY|BSD_BSDELAY|BSD_VTDELAY|ROS_FFDELAY)
#ifndef ridge
#define		BSD_CRTBS		0x00010000		/* do backspacing for crt */
#define		BSD_PRTERA		0x00020000		/* \ ... / erase */
#define		BSD_CRTERA		0x00040000		/* " \b " to wipe out char */
#define		BSD_TILDE		0x00080000		/* hazeltine tilde kludge */
#define		BSD_MDMBUF		0x00100000		/* start/stop output on carrier */
#define		BSD_LITOUT		0x00200000		/* literal output */
#define		BSD_TOSTOP		0x00400000		/* SIGSTOP on background output */
#define		BSD_FLUSHO		0x00800000		/* flush output to terminal */
#define		BSD_NOHANG		0x01000000		/* no SIGHUP on carrier drop */
#define		BSD_L001000		0x02000000
#define		BSD_CRTKIL		0x04000000		/* kill line with " \b " */
#define		L004000			0x08000000
#define		BSD_CTLECH		0x10000000		/* echo control chars as ^X */
#define		BSD_PENDIN		0x20000000		/* tp->t_rawq needs reread */
#define		BSD_DECCTQ		0x40000000		/* only ^Q starts after ^S */
#define		BSD_NOFLSH		0x80000000		/* no output flush on signal */
#endif
#define	BSD_TIOCLBIS		_IOW(t, 13, int)		/* bis local mode bits */
#define	BSD_TIOCLBIC		_IOW(t, 14, int)		/* bic local mode bits */
#define	BSD_TIOCLSET		_IOW(t, 15, int)		/* set entire local mode word */
#define	BSD_TIOCLGET		_IOR(t, 16, int)		/* get local modes */
#ifdef ridge
#define		BSD_LCRTBS		0x00000001		/* do backspacing for crt */
#define		BSD_LPRTERA		0x00000002		/* \ ... / erase */
#define		BSD_LCRTERA		0x00000004		/* " \b " to wipe out char */
#define		BSD_LTILDE		0x00000008		/* hazeltine tilde kludge */
#define		BSD_LMDMBUF		0x00000010		/* start/stop output on carrier */
#define		BSD_LLITOUT		0x00000020		/* literal output */
#define		BSD_LTOSTOP		0x00000040		/* SIGSTOP on background output */
#define		BSD_LFLUSHO		0x00000080		/* flush output to terminal */
#define		BSD_LNOHANG		0x00000100		/* no SIGHUP on carrier drop */
#define		BSD_LECHOI		0x00000200		/* echo immediate */
#define		BSD_LCRTKIL		0x00000400		/* kill line with " \b " */
#define		BSD_LINTRUP		0x00000800		/* generate SIOGIO as approp. */
#define		BSD_LCTLECH		0x00001000		/* echo control chars as ^X */
#define		BSD_LPENDIN		0x00002000		/* tp->t_rawq needs reread */
#define		BSD_LDECCTQ		0x00004000		/* only ^Q starts after ^S */
#define		BSD_LNOFLSH		0x00008000		/* no output flush on signal */
#define		BSD_LAUTOFLOW		0x00010000		/* use FDLP auto flow control */
#else
#define		BSD_LCRTBS		(BSD_CRTBS>>16)
#define		BSD_LPRTERA		(BSD_PRTERA>>16)
#define		BSD_LCRTERA		(BSD_CRTERA>>16)
#define		BSD_LTILDE		(BSD_TILDE>>16)
#define		BSD_LMDMBUF		(BSD_MDMBUF>>16)
#define		BSD_LLITOUT		(BSD_LITOUT>>16)
#define		BSD_LTOSTOP		(BSD_TOSTOP>>16)
#define		BSD_LFLUSHO		(BSD_FLUSHO>>16)
#define		BSD_LNOHANG		(BSD_NOHANG>>16)
#define		BSD_LCRTKIL		(BSD_CRTKIL>>16)
#define		BSD_LCTLECH		(BSD_CTLECH>>16)
#define		BSD_LPENDIN		(BSD_PENDIN>>16)
#define		BSD_LDECCTQ		(BSD_DECCTQ>>16)
#define		BSD_LNOFLSH		(BSD_NOFLSH>>16)
#endif
#define	BSD_TIOCSBRK		_IO(t, 17)			/* set break bit */
#define	BSD_TIOCCBRK		_IO(t, 18)			/* clear break bit */
#define	BSD_TIOCSDTR		_IO(t, 19)			/* set data terminal ready */
#define	BSD_TIOCCDTR		_IO(t, 20)			/* clear data terminal ready */
#define	BSD_TIOCGPGRP		_IOR(t, 21, int)		/* get pgrp of tty */
#define	BSD_TIOCSPGRP		_IOW(t, 22, int)		/* set pgrp of tty */
#define	BSD_TIOCSLTC		_IOW(t, 23,struct ltchars)	/* set local special chars */
#define	BSD_TIOCGLTC		_IOR(t, 24,struct ltchars)	/* get local special chars */
#define	BSD_TIOCOUTQ		_IOR(t, 25, int)		/* output queue size */
#define	BSD_TIOCSTI		_IOW(t, 26, char)		/* simulate terminal input */
#define	BSD_TIOCNOTTY		_IO(U, 1)			/* void tty association */
#define	BSD_TIOCPKT		_IOW(t, 28, int)		/* pty: set/clear packet mode */
#define		BSD_TIOCPKT_DATA	0x00			/* data packet */
#define		BSD_TIOCPKT_FLUSHREAD	0x01			/* flush packet */
#define		BSD_TIOCPKT_FLUSHWRITE	0x02			/* flush packet */
#define		BSD_TIOCPKT_STOP	0x04			/* stop output */
#define		BSD_TIOCPKT_START	0x08			/* start output */
#define		BSD_TIOCPKT_NOSTOP	0x10			/* no more ^S, ^Q */
#define		BSD_TIOCPKT_DOSTOP	0x20			/* now do ^S ^Q */
#define	BSD_TIOCSTOP		_IO(t, 29)			/* stop output, like ^S */
#define	BSD_TIOCSTART		_IO(t, 30)			/* start output, like ^Q */
#define	BSD_TIOCMSET		_IOW(t, 31, int)		/* set all modem bits */
#define	BSD_TIOCMBIS		_IOW(t, 32, int)		/* bis modem bits */
#define	BSD_TIOCMBIC		_IOW(t, 33, int)		/* bic modem bits */
#define	BSD_TIOCMGET		_IOR(t, 34, int)		/* get all modem bits */
#define	BSD_TIOCREMOTE		_IO(t, 35)			/* remote input editing */
#define ROS_TIOCSIGDEATH	_IOW(t, 36, int)		/* hack for pseudo ttys */

#define	BSD_OTTYDISC	0		/* old, v7 std tty driver */
#define	BSD_NETLDISC	1		/* line discip for berk net */
#define	BSD_NTTYDISC	2		/* new tty discipline */
#define	BSD_TABLDISC	3		/* hitachi tablet discipline */
#define	BSD_NTABLDISC	4		/* gtco tablet discipline */

/*
 * ?????
 */

#define OLD_STGET		_OLD_IO(X, 0)	/* get line options */
#define OLD_STSET		_OLD_IO(X, 1)	/* set line options */
#define	OLD_STTHROW		_OLD_IO(X, 2)	/* throw away queued input */
#define	OLD_STWLINE		_OLD_IO(X, 3)	/* get synchronous line # */

/*
 * display ioctl commands
 */

#define ROS_BCGETSZ		_IOR(b, 1, struct Form)
#define ROS_BCCURSON		_IO_IM(b, 2, int)
#define ROS_BCSCTL		_IOW_PAGE(b, 3)
#define ROS_BCRCTL		_IOWR_PAGE(b, 4)
#define ROS_BCGETTYPE		_IOR(b, 6, int)
#define ROS_BCSETCNTLW          _IO_IM(U, 2, int) /* used to set control window */
#define ROS_BCINVRT		_IO_IM(b, 7, int)

#define OLD_BCGETSZ		_OLD_IO(b, 1)
#define OLD_BCCURSON		_OLD_IO_IMMED2(b, 2)
#define OLD_BCSCTL		_OLD_IO(b, 3)
#define OLD_BCRCTL		_OLD_IO(b, 4)
#define OLD_BCGETTYPE		_OLD_IO(b, 6)

/*
 * DR11 ioctl commands
 */

#define ROS_DR11RESET1		_IO(d, 1)
#define ROS_DR11RESET2		_IO(d, 2)
#define ROS_DR11KICK		_IOW(d, 3, int)

/*
 * fcntl ioctl commands
 */

#define	BSD_FIOCLEX		_IO(U, 3)			/* set close on exec */
#define	BSD_FIONCLEX		_IO(U, 4)			/* reset close on exec */
#define	BSD_FIONREAD		_IOR(f, 127, int)		/* get # bytes to read */
#define	BSD_FIONBIO		_IOW(U, 5, int)			/* set/clear non-blocking i/o */
#define	BSD_FIOASYNC		_IOW(U, 6, int)			/* set/clear async i/o */
#define	BSD_FIOSETOWN		_IOW(U, 7, int)			/* set owner */
#define	BSD_FIOGETOWN		_IOR(U, 8, int)			/* get owner */

#define OLD_FIOCLEX		_OLD_IO(f, 1)
#define OLD_FIONCLEX		_OLD_IO(f, 2)

/*
 * network related ioctl commands
 */

#define	BSD_SIOCSHIWAT		_IOW(s,  0, int)		/* set high watermark */
#define	BSD_SIOCGHIWAT		_IOR(s,  1, int)		/* get high watermark */
#define	BSD_SIOCSLOWAT		_IOW(s,  2, int)		/* set low watermark */
#define	BSD_SIOCGLOWAT		_IOR(s,  3, int)		/* get low watermark */
#define	BSD_SIOCATMARK		_IOR(s,  7, int)		/* at oob mark? */
#define	BSD_SIOCSPGRP		_IOW(s,  8, int)		/* set process group */
#define	BSD_SIOCGPGRP		_IOR(s,  9, int)		/* get process group */

#define	BSD_SIOCADDRT		_IOW(r, 10, struct rtentry)	/* add route */
#define	BSD_SIOCDELRT		_IOW(r, 11, struct rtentry)	/* delete route */

#define	BSD_SIOCSIFADDR		_IOW(i, 12, struct ifreq)	/* set ifnet address */
#define	BSD_SIOCGIFADDR		_IOWR(i,13, struct ifreq)	/* get ifnet address */
#define	BSD_SIOCSIFDSTADDR	_IOW(i, 14, struct ifreq)	/* set p-p address */
#define	BSD_SIOCGIFDSTADDR	_IOWR(i,15, struct ifreq)	/* get p-p address */
#define	BSD_SIOCSIFFLAGS	_IOW(i, 16, struct ifreq)	/* set ifnet flags */
#define	BSD_SIOCGIFFLAGS	_IOWR(i,17, struct ifreq)	/* get ifnet flags */
#define	BSD_SIOCGIFCONF		_IOR_PAGE(i,20)			/* get ifnet list */
#define	ROS_SIOCGNETTAB		_IOWR_PAGE(r,21)		/* get network tables */

/*
 * line printer ioctl commands
 */

#define ATT_LPRGET		_IOR(l, 1, struct lprio)	/* get print paramters */
#define ATT_LPRSET		_IOW(l, 2, struct lprio)	/* set print paramters */
#define	OLD_LPRGET		_OLD_IO(l, 1)
#define	OLD_LPRSET		_OLD_IO(l, 2)

/*
 * mouse ioctl commands
 */

#define ROS_MOUSEGET		_IOR(m, 1, int)
#define ROS_MOUSESET		_IO_IM(m, 2, int)
#define OLD_MOUSEGET		_OLD_IO(m, 1)
#define OLD_MOUSESET		_OLD_IO_IMMED2(m, 2)

/*
 * versatec printer/plotter ioctl commands
 */

#define		BSD_VPRINT		0100
#define		BSD_VPLOT		0200
#define		BSD_VPRINTPLOT		0400

#define		ROS_VPRINT		01
#define		ROS_VPLOT		02
#define		ROS_VPRINTPLOT		04

#define ROS_VPRGET		_IOR(v, 0, struct vprio)	/* get device mode */
#define ROS_VPRSET		_IOW(v, 1, struct vprio)	/* set device mode */
#define	BSD_VGETSTATE		_IOR(v, 2, int)
#define	BSD_VSETSTATE		_IOW(v, 3, int)

#define	OLD_VPRGET		_OLD_IO(v, 0)
#define	OLD_VPRSET		_OLD_IO(v, 1)

#endif
