/* "@(#)emulex.mt01.h	5.1	6/10/86" */
/*
** This header file includes definitions for bits of status and
** sense information returned by the Emulex Titleist cartridge tape
** controller.
*/

/*
** Typedef for Sense Information returned as a result of issuing a
** request sense command to tape drive.
*/
typedef struct
    {
    unsigned	Valid     : 1;
    unsigned	ErrClass  : 3;
    unsigned	ErrCode   : 4;
    Byte	SegmentNum;
    unsigned	FileMark  : 1;
    unsigned	EndMedia  : 1;
    unsigned	Rsvd1     : 2;
    unsigned	SenseKey  : 4;
    Byte	Info[4];
    Byte	AdtlLength;
    unsigned	EErrClass : 4;		/* Emulex specific */
    unsigned	EErrCode  : 4;		/* Emulex specific */
    Byte	RecErrorsMsb;		/* Emulex specific - number of recoverable errors */
    Byte	RecErrorsLsb;		/* Emulex specific - number of recoverable errors */
    }  tTapeSense;
/* 
** Tape drive generated errors returned by requesting 
** extended sense bytes from the controller
*/
#define	VaddMask    0x80    	    /* byte 0 of extended sense data */

#define	FM  	    0x80    	    /* byte 2 */
#define	EOM 	    0x40
#define	ILI 	    0x20
#define	SnsKeyMask  0x0f

/* Sense Key bit definitions */
#define	    SnsOK   	    0x00
#define	    SnsCER  	    0x01
#define	    SnsNotRdy	    0x02
#define	    SnsMediaEr	    0x03
#define	    SnsHER  	    0x04
#define	    SnsIllReq	    0x05
#define	    SnsUnitAttn	    0x06
#define	    SnsDataProt	    0x07
#define	    SnsBlankCk 	    0x08
#define	    SnsVendor	    0x09
#define	    SnsCpyAbort	    0x0a
#define	    SnsAbort	    0x0b    /* retry op */
#define	    SnsRsv1 	    0x0c
#define	    SnsVolOvrfl	    0x0d
#define	    SnsMisCmp	    0x0e
#define	    SnsRsv2 	    0x0f

#define ERCLMask    0xf0
#define	    DriveEr 	0x00
#define	    TargetEr	0x10
#define	    SysEr   	0x20
#define	    VendorEr	0x30

#define	ErrorBits   0x0f
#define	ERCDMask    ErrorBits+ERCLMask  /* this is just 1 byte-not needed */
/*
** tape drive errors
*/
#define	    NoSense	    0x0
#define	    DrvNotRdy	    0x4
#define	    MediaNotLoaded  0x9
#define	    InsuffCap	    0xa
#define	    DriveTimeOut    0xb
/*
** target errors
*/
#define	    HER	    	    0x11
#define	    BlockMissing    0x14
#define	    DMAtimeout	    0x16
#define	    WriteProtect    0x17
#define	    CER	    	    0x18
#define	    BadBlock	    0x19
#define	    FMK	    	    0x1c
#define	    CompErr 	    0x1d    /* verify command only */
/*
** system errors
*/
#define	    InvalidCmd	    0x20
/*
** vendor errors
*/
#define	    UnitAttn	    0x30
#define	    CmdTimeOut	    0x31
#define	    AppendErr	    0x33
#define	    EndOfMedia	    0x34

/* 
** controller status bit fields 
*/
#define	sStatRsvd	0x80	/* 1st bit of status byte is reserved */
#define	sStatVendorMask	0x61	/* 3 bits are Vendor unique */
#define	sStatCodeMask	0x1E	/* status code is remaining 4 bits */
/* 
** controller Status codes 
*/
#define	sStatGood	0x00	/* command completed successfully */
#define	sStatCheckCond	0x02	/* host should issue request sense cmd */
#define	sStatCondMet	0x04	/* search data cmd completed */
#define	sStatBusy	0x08	/* target unable to accept command */
#define	sStatIGood	0x10	/* Intermed./Good - linked cmd completed */
#define	sStatICondMet	0x14	/* linked search completed */
#define	sStatRsvConf	0x18	/* exclusive access violation */
/* 
** Ridge status codes 
*/
#define	sScsiTimeOut	1	/* bus timeout */
#define	sDma2BitErr	2	/* double bit Ridge DMA memory error */
#define	sBusError	3	/* scsi protocol error */
#define	sBusReset	4	/* someone reset scsi bus */
#define	sXferCntErr	5	/* device xfer count did not match request */

/*
** Vendor Unique commands
*/
#define sPrvAlwRemoval	0x1e
