/* "@(#)dirmgrMsgs.h	5.1	6/10/86" */

/*****************************************************************************/
/*                                                                           */
/*  Directory Manager Interface                                              */
/*                                                                           */
/*  This header file defines the messages and constants needed to interface  */
/*  with the directory manager.  Users of this file should also include      */
/*  <ros/msgHeader.h>, .....                                                 */
/*                                                                           */
/*  06-Jan-86  Initial version (mrj)                                         */
/*                                                                           */
/*****************************************************************************/


/* Message header request codes */

#define DMAddDevice   4
#define DMRemDevice   6
#define DMFindDevice  8

#define DMAddDeviceVers1	1
#define DMRemDeviceVers0	0
#define DMFindDeviceVers0	0

/*****************************************************************************/
/*                                Add Device                                 */
/*****************************************************************************/

typedef struct
{
    MsgHdrType	header;		/* DMAddDeviceVers1, DMAddDevice|Request */
    DevType	deviceCode;	/* major/minor device number to be managed */
    ProcessId	procId;		/* pid of managing driver */
    Queue	devQ;		/* requestor's Q for DMAddDevice response */
    Queue	devConQ;	/* driver's Q for open, close, etc. */
    int		capabilities;	/* driver's capabilities - see below */
} DMAddDeviceReqType;

#define DMNoCapabilities	0x0000
#define DMManagesNames		0x0001	/* /dev/x/name allowed */
#define DMRequiresName		0x0002	/* /dev/x not allowed */
#define DMSlowDevice		0x0004	/* read, write, etc. could block user */
#define DMTTYDevice		0x0008	/* supports TTY operations */
#define DMDoesSelect		0x8000	/* supports select */

typedef struct
{
    MsgHdrType	header;		/* DMAddDeviceVers0, DMAddDevice|Response */
    Error	status;		/* ROS error status */
} DMAddDeviceRepType;

/*****************************************************************************/
/*                              Remove Device                                */
/*****************************************************************************/

typedef struct
{
    MsgHdrType	header;		/* DMRemDeviceVers0, DMRemDevice|Request */
    DevType	deviceCode;	/* major/minor device number */
    ProcessId	procId;		/* pid of managing driver */
    Queue	devQ;		/* requestor's Q for DMRemDevice response */
} DMRemDeviceReqType;

typedef struct
{
    MsgHdrType	header;		/* DMRemDeviceVers0, DMRemDevice|Response */
    Error	status;		/* ROS error status */
} DMRemDeviceRepType;

/*****************************************************************************/
/*                               Find Device                                 */
/*****************************************************************************/

typedef struct
{
    MsgHdrType	header;		/* DMFindDeviceVers0, DMFindDevice|Request */
    DevType	deviceCode;	/* major/minor device number */
    ProcessId	procId;		/* NOT USED */
    Queue	devQ;		/* requestor's Q for DMFindDevice response */
} DMFindDeviceReqType;

typedef struct
{
    MsgHdrType	header;		/* DMFindDeviceVers0, DMFindDevice|Response */
    Error	status;		/* ROS error status */
    ProcessId	driverPID;
} DMFindDeviceRepType;
