/*	<@(#)max3.h	22.3	87/01/27>	*/


/******************************************************************************
*
* TITRE       :	max3.h
*
* AUTEUR      :	schiehle
*
* DATE        : 31-07-85
*
* FONCTION    :	structures et constantes utilisees par la methode
*		d'acces x25-3
*
* ENTREE      :	
*
*
* SORTIE      :	
*
*
* REMARQUES   :	
*
******************************************************************************/

/*************************************************************
*   structure d'un descripteur de donnees
*************************************************************/

typedef struct desc {
	char	*adr ;		/* adresse des donnees			*/
unsigned short	lg ;		/* longueur des donnees			*/
unsigned short	depl ;		/* deplacement en debut de chaine	*/
} Tdesc ;

/*************************************************************
*   structure NCB
*************************************************************/

typedef struct ncb {
unsigned char	ident[3] ;	/* identification 'NCB'		*/
unsigned char	version	;	/* version			*/
unsigned long	idsys  ;	/* ident systeme		*/
unsigned long	iduser ;	/* ident utilisateur		*/
unsigned short	signal ;	/* signal recu			*/
unsigned short  indic  ;	/* indicateurs (bits Q,M )	*/
unsigned long	retour ;	/* code retour			*/
unsigned short	type   ;	/* type ( CVC,CVP )		*/
} Tncb ;

/*************************************************************
*   structure UCB
*************************************************************/

typedef struct ucb {
unsigned char	ident	;	/* identification 'U'		*/
unsigned char	version	;	/* version			*/
unsigned short	nbinfo	;	/* lg partie info		*/
unsigned char	nbdescout ;	/* nbre descripteurs en sortie	*/
unsigned char	nbdescin  ;	/* nbre descripteurs en entree	*/
unsigned short	r12 ;
unsigned long	r20 ;
unsigned long	r30 ;
unsigned char	r40 ;
unsigned char	tamd ;		/* unite destinataire		*/
unsigned short	r42 ;
unsigned long	r50 ;
unsigned short	r60 ;
unsigned short	requete ;	/* code requete			*/
unsigned long	retour ;	/* code retour			*/
	Tdesc	desc[8] ;	/* zone des descripteurs	*/
} Tucb ;

/******************************************************************************
* structure de la table de site
******************************************************************************/

typedef struct site_cvc {
unsigned char	type ;		/* type de CV				*/
unsigned char	lgadrl ;	/* longueur adresse locale en demi-octets */
unsigned char	adrl[8] ;	/* adresse locale codee BCD		*/

unsigned char	r2 ;
unsigned char	lgadrd ;	/* longueur adresse distante en demi-octets */
unsigned char	adrd[8] ;	/* adresse distante codee BCD		*/

unsigned char	r3 ;
unsigned char	lgfac ;		/* longueur champ facilites		*/
unsigned char	fac[64] ;	/* champ facilites			*/
} Tsite_cvc ;

typedef struct site_cvp {
unsigned char	type ;		/* type de CV				*/
unsigned char	lgadrl ;	/* longueur adresse locale en demi-octets */
unsigned char	adrl[8] ;	/* adresse locale codee BCD		*/

unsigned char	r2 ;
unsigned char	lgsite ;	/* longueur nom de site			*/
unsigned char	site[8];	/* nom de site global			*/
} Tsite_cvp ;

/* type de connexion	*/
/************************/

#define CVC	0		/* type CVC	*/
#define CVP	1		/* type CVP	*/

/* requetes utilisateurs	*/
/********************************/

#define RQ_OPEN		33	/* ouverture de connexion		*/
#define RQ_WAIT_OPEN	34	/* attente de connexion entrante	*/
#define RQ_ACK_OPEN	35	/* confirmation d'etablissement de connexion */
#define RQ_CLOSE	36	/* fermeture de connexion		*/
#define RQ_RESET	37	/* reinitialisation de connexion	*/
#define RQ_SEND		38	/* emission de message normal		*/
#define RQ_SEND_EXP	39	/* emission de message express		*/
#define RQ_READ		40	/* lecture de signal			*/
#define RQ_TEST		41	/* test de signal			*/

/* signaux transmis a l'utilisateur	*/
/****************************************/

#define SIG_DATA	1	/* message recu				*/
#define SIG_DATA_EXP	2	/* message d'interruption recu		*/
#define SIG_RESET	3	/* reinitialisation du CV		*/
#define SIG_CLOSE	4	/* fermeture du CVC			*/
				/* ou abonnement inactif si CVP		*/

#define IND_M		1	/* indicateur donnees a suivre		*/
#define IND_Q		2	/* indicateur donnees qualifiees	*/
#define IND_D		4	/* indicateur d'attente d'acquittement	*/


/* indice des descripteurs ( par rapport au 1er desc du meme type OUT ou IN */
/****************************************************************************/

#define NCBO	0	/* NCB OUT					*/
#define DATAO	1	/* donnees OUT					*/
#define SITEO	2	/* table de site OUT				*/

#define NCBI	0	/* NCB IN					*/
#define DATAI	1	/* donnees IN					*/
#define SITEI	2	/* table de site IN				*/

/* longueurs de structures ou de chaines	*/
/************************************************/

#define	LGNCB	22	/* lg NCB					*/
#define LGSITE	86	/* lg max table de SITE				*/

/* Codes retour des UCB							     */
/*****************************************************************************/

#define	OK_MAX3		0x36000000	/* requete executee normalement	*/
#define ER_NO_SIG	0x36000002	/* pas de signal en attente	*/
#define ER_CLOSE	0x36000003	/* fermeture en cours		*/
#define ER_RESET	0x36000004	/* reinitialisation en cours	*/
#define ER_OPEN		0x36000005	/* ouverture en cours		*/

#define ER_UCB_IDENT	0x36010010	/* erreur identification UCB	*/
#define ER_UCB_VERSION	0x36010011	/* erreur version UCB		*/

#define ER_NBINFO	0x36010020	/* erreur nbinfo		*/
#define ER_NBDESCOUT	0x36010021	/* erreur nbdescout		*/
#define ER_NBDESCIN	0x36010022	/* erreur nbdescin		*/
#define ER_REQ_UNKNOWN	0x36010023	/* requete inconnue		*/
#define ER_REQ_SAME	0x36010024	/* requete identique en cours	*/

#define ER_NCB_SIZE	0x36010030	/* erreur taille NCB		*/
#define ER_NCB_IDENT	0x36010031	/* erreur identification NCB	*/
#define ER_NCB_VERSION	0x36010032	/* erreur version NCB		*/
#define ER_NCB_TYPE	0x36010033	/* type CV inconnu		*/
#define ER_NCB_IN	0x36010034	/* taille NCB IN trop petite	*/
#define ER_NCB_DEPL	0x36010035	/* deplacement NCB non nul	*/

#define ER_CNX_UNKNOWN	0x36010040	/* connexion inexistante	*/
#define ER_CNX_SAT	0x36010041	/* saturation connexions	*/
#define ER_CTX_SAT	0x36010042	/* saturation contextes		*/

#define ER_SITE_SIZE	0x36010050	/* erreur taille table de site	*/
#define ER_CVP_SIZE	0x36010051	/* erreur longueur nom de CVP	*/
#define ER_CVP_UNKNOWN	0x36010052	/* CVP inconnu ou abn non actif	*/
#define ER_CVP_USED	0x36010053	/* CVP utilise			*/
#define ER_ADR_SIZE	0x36010054	/* erreur longueur adresse	*/
#define ER_FAC_SIZE	0x36010055	/* longueur facilites > 63 	*/
#define ER_DATA_OPEN	0x36010056	/* lg donnees d'appel > 128	*/
#define ER_ABN_UNKNOWN	0x36010057	/* abn inconnu ou non actif	*/
#define ER_NSAP_SIZE	0x36010058	/* lg NSAP > 3			*/
#define ER_SITE_IN	0x36010059	/* table de site trop petite	*/
#define ER_CVC_REFUSED	0x3601005a	/* ouverture CVC refusee	*/

#define ER_DATA_IN	0x36010060	/* taille reception trop petite */
#define ER_DATA_OUT	0x36010061	/* taille emission trop grande	*/
#define ER_DATA_EXP	0x36010062	/* taille IT != [1,32]		*/
#define ER_DATA_DEPL	0x36010063	/* deplacement < 8		*/


/* cause et diagnostic locaux des refus d'ouverture et			*/
/*  des signaux de fermeture						*/
/************************************************************************/

#define FER_OCC		0x0100	/* numero occupe			*/
#define FER_DER		0x0900	/* derangement				*/
#define FER_ERR		0x1300	/* erreur de procedure locale		*/

#define FER_OCC_47	0x0147	/* plus de voie logique libre		*/
#define FER_OCC_48	0x0148	/* collision d'appel			*/

#define FER_DER_99	0x0999	/* liaison fermee			*/
#define FER_DER_9a	0x099a	/* reprise en cours			*/

#define FER_ERR_00	0x1300	/* erreur de procedure			*/
#define FER_ERR_15	0x1315	/* paquet recu a tort dans l'etat p2	*/
#define FER_ERR_16	0x1316	/* paquet recu a tort dans l'etat p3	*/
#define FER_ERR_21	0x1321	/* paquet recu de type inconnu		*/
#define FER_ERR_22	0x1322	/* appel recu sur voie speciale depart	*/
#define FER_ERR_31	0x1331	/* non reponse a indication d'appel	*/
#define FER_ERR_33	0x1333	/* non reponse a indication de reinit	*/

/* cause et diagnostic locaux des signaux de reinitialisation		*/
/************************************************************************/

#define REI_NC		0x0700	/* incident dans le reseau		*/
#define REI_ERR		0x0500	/* erreur de procedure locale		*/

#define REI_ERR_01	0x0501	/* erreur de P(S)			*/
#define REI_ERR_02	0x0502	/* erreur de P(R)			*/
#define REI_ERR_1b	0x051b	/* paquet recu a tort dans l'etat d1	*/
#define REI_ERR_21	0x0521	/* paquet de type inconnu		*/
#define REI_ERR_23	0x0523	/* paquet interdit sur CVP		*/
#define REI_ERR_25	0x0525	/* paquet REJ interdit			*/
#define REI_ERR_27	0x0527	/* paquet trop long			*/
#define REI_ERR_2b	0x052b	/* confirmation d'interruption recu a tort */
#define REI_ERR_2c	0x052c	/* interruption recu a tort		*/
#define REI_ERR_33	0x0533	/* non reponse a indication de reinit	*/

/* cause et diagnostic envoyes dans les paquets de liberation par MAX3	     */
/*****************************************************************************/

#define FER_NO_DEST	0x000e	/* destinataire inconnu (NSAP)		*/
#define FER_NO_WAIT	0x000f	/* pas d'utilisateur en attente		*/
#define FER_HS		0x00ff	/* utilisateur HS			*/

