/*	@(#)matr.h	20.2	*/
/*--------------------------*/
/* codes requetes transport */
/*--------------------------*/

#define OPENQ	49		/* requete d'ouverture de connexion */
#define ACPT	50		/* requete d'attente de connexion   */
#define OPENR	51		/* reponse a indication open        */
#define CLOS	52		/* requete de fermeture de connexion */
#define SEND	53		/* emission message normal          */
#define SENX	54		/* emission message express         */
#define LECSIG	55		/* lecture de signal                */
#define TSTSIG	56		/* test de signal                   */

/*-------------------------*/
/* code des signaux        */
/*-------------------------*/

#define zopen  1
#define zsend  2
#define zsenx  3
#define zclos  4
#define zrese  5

#define ERR_OK	0x46000000

#define WAR_TRONC  0x46000001	/* donnees tronquees		*/
#define WAR_NOSIG  0x46000002	/* pas de signal en attente	*/
#define WAR_CLOSE  0x46000003	/* close en cours   		*/
#define WAR_RESE   0x46000004	/* reset en cours   		*/
#define WAR_CLTQ   0x46000005	/* data tronquees + close en cours*/
#define WAR_RETQ   0x46000006	/* data tronquees + close en cours*/

/*-------------------------*/
/* erreurs niveau 1        */
/*-------------------------*/

#define ER1_UCB   0x4601000a
#define ER1_SIZE  0x4601000b
#define ER1_XCB   0x4601000c
#define ER1_INEX  0x4601000d
#define ER1_EXIS  0x4601000e
#define ER1_IDEM  0x4601000f
#define ER1_OPEN  0x46010010
#define ER1_CLOS  0x46010011
#define ER1_RESE  0x46010012
#define ER1_ENCH  0x46010013
#define ER1_ABON  0x46010014
#define ER1_CVP   0x46010015
#define ER1_PRET  0x46010016
#define ER1_STAT  0x46010017
#define ER1_PRM   0x46010018

/*-------------------------------------------------*/
/* alarme : numero de module - numero de procedure */
/*-------------------------------------------------*/

#define ERR_LIB    0x4601	/* lib_ucb */
#define ERR_TCB    0x4602	/* creat_tcb */
#define ERR_SSIG   0x4603	/* sup_signal */
#define ERR_IICB   0x4604	/* icb_init */
#define ERR_SICB   0x4605	/* sup_icb */
#define ERR_SCTX   0x4606	/* sup_ctx  */
#define ERR_CCTX   0x4607	/* creat_ctxt */
#define ERR_SCHN   0x4608	/* sup_chn */
#define ERR_COPI   0x4609	/* copie */
#define ERR_CTCB   0x4610	/* cop_tcb */
#define ERR_SCRU   0x4611	/* scrut_sig */ 
#define ERR_INIT   0x4612	/* inimat */
#define ERR_MATT   0x4613       /* matt */
#define ERR_QOPE   0x4614       /* mtrq_open */
#define ERR_QACP   0x4615       /* mtrq_acpt */
#define ERR_QROP   0x4616       /* mtrq_rope */
#define ERR_IOPE   0x4617       /* mtin_open */
#define ERR_FOPE   0x4618       /* mtcf_open */
#define ERR_QSND   0x4619       /* mtrq_send */
#define ERR_QSNX   0x4620       /* mtrq_senx */
#define ERR_QCLO   0x4621       /* mtrq_clos */
#define ERR_QRED   0x4622       /* mtrq_read */
#define ERR_IGEN   0x4623       /* mtin_gene */
#define ERR_FGEN   0x4624       /* mtcf_gene */

/*----------------------------*/
/* code complementaire alarme */
/*----------------------------*/

#define ABO_BDC     0x0030	/* Abort acces debut de chaine  */
#define ABO_SDC     0x0031	/* Abort suppression debut chain*/
#define ABO_ADFC    0x0032	/* Abort ajout signal en debut  */
#define ABO_ALOB    0x0033
#define ABO_ALOT    0x0034
#define ABO_DALOT   0x0035
#define ABO_DALOB   0x0036
#define ABO_CHAI    0x0037
#define ABO_DCHAI   0x0038
#define ABO_CDES    0x0039
#define ABO_RDES    0x003a
#define ABO_ADC     0x003b
#define ABO_MVOUT   0x003c
#define ABO_CCC     0x003d
#define ABO_FILE    0x003e
#define ABO_IUTI    0x003f

#define ABO_DEL     0x0040	/* Scratch suppression contexte	     */
#define ABO_RETRI   0x0041	/* Scratch retrouver contexte	     */
#define ABO_CTRL    0x0042	/* Scratch retrouver adresse ucb     */
#define ABO_ABON    0x0043	/* Scratch + de deux abonnements     */
#define ABO_RESN    0x0044	/* Scratch plus de cvp libre         */
#define ABO_RESO    0x0045      /* Scratch sur reset off pas trouve  */
#define ABO_READ    0x0046      /* Scratch sur lecture dans mail box */

#define typet  10



typedef struct Ticb_ {
		char  cst_i    ;
		char  version  ;
		short  nbinfo   ;
		char  nbdescout;
		char  nbdescin ;
		short  canal    ;
		char  *ctxdest ;
		char  *ctxsrce ;
		char  id_dest  ;
		char  un_dest  ;
		char  id_srce  ;
		char  un_srce  ;
		short  ruf1     ;
		short  ruf2     ;
		char  indic1   ;
		char  indic2   ;
		short  norequete;
		char  origine  ;
		char  severite ;
		char  cause    ;
		char  diagno   ;

		char   *c1  ;
		short   l1   ;
		short   d1   ;
		char   *c2  ;
		short   l2   ;
		short   d2   ;
		} Ticb;

/* Definition de la structure du TCB */
/* --------------------------------- */

typedef struct type_tcb {
		char  name [3];
		char  version ;
		char  *nocv   ; 
		char  *nouser ;
		short  signal  ;
                short inutil ;
		char  origine ;
		char  severite;
		char  cause   ;
		char  diagno  ;				
		}			Ttcb;

/* Definition de la structure du UCB */
/* --------------------------------- */

typedef struct Tucb_ {
		char  cst_u    ;
		char  version  ;
		short  nbinfo   ;
		char  nbdescout;
		char  nbdescin ;
		short  ruf0	;
		long  ruf1     ;
		long  ruf2     ;
		short  userid   ;
		short  smbx     ;
		short  systdest ;
		short  systsrce ;
		char  type     ;
		char  type0	;
		unsigned short  norequete;
		long  codere   ;
		Ttcb   *tcbo	;
		short  lgtcbo	;
		short  ixtcbo	;
		} Tucb;

 struct descma {
        long idchain ;
        short lgchain ;
        short index ;
 };


