/* "@(#)fcntl.h	5.1	6/10/86" */
/* Flag values accessible to open(2) and fcntl(2) */
/*  (The first three can only be set by open) */
#define	O_RDONLY 0
#define	O_WRONLY 1
#define	O_RDWR	 2
#define	O_NDELAY 04	/* Non-blocking I/O */
#define	O_APPEND 010	/* append (writes guaranteed at the end) */
#ifdef ridge
#define O_ASYNC  020	/* send SIGIO to pgrp when input is available */
#endif

/* Flag values accessible only to open(2) */
#define	O_CREAT	00400	/* open with file create (uses third open arg)*/
#define	O_TRUNC	01000	/* open with truncation */
#define	O_EXCL	02000	/* exclusive open */

/* fcntl(2) requests */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */
#define F_GETLK 5       /* GEt blocking file locks */
#define F_SETLK 6       /* SEt or clear file locks and fail on busy */
#define F_SETLKW 7      /* Set or clear file locks and wait on busy */
/* file segment locking control structure */
struct flock {
       short l_type ;
       short l_whence;
       long l_start ;
       long l_len   ;
       long l_pid  ;
             };
/* file segment locking types */
#define F_RDLCK 01 /*read lock */
#define F_WRLCK 02 /* write lock */
#define F_UNLCK 03 /* remove locks */
