/* "@(#)ctcat.h	5.1	6/10/86" */
/*
** header file describing the 'ctcat' cartridge tape format
*/

/*
** The following is a sketch of what a ctcat tape looks like
** (file marks are indicated with '======')
**
**	directory #1:
**	    file1.1 entry
**	    file1.2 entry
**	          .
**	          .
**	    file1.n entry
**	=====================
**	file1.1                <-- for a bootable tape, this file will be
**	=====================      by definition, the 'kernel'.
**	file1.2
**	=====================
**                .
**                .
**      =====================
**      file1.n
**
** A tape may have one or more of these directory/file groups.  Each directory
** has entries for files after it on the tape up to the next directory.
**
** The first 32 bytes of a directory make up the directory header.  This 
** is followed by an entry for each file in the directrory/file group.
** The specific formats follow:
*/
   
/*
** Structure of a directory header.  There is one of these at the beginning
** of each directory on the tape.
*/
struct dir_header {
	long 	dir_magic;		/* identifies directory header */
	long 	num_of_entries;		/* number of entries in this dir */
	long	create_time;		/* date this dir/file group written */
	long	mach_id;		/* machine id where tape was written */
	char	filler[16]; 		/* room for future expansion */
};

/*
** Structure of each file entry.  These entries follow the directory header.
** Each one of these entries describes a file which is found following 
** this directory.
*/
struct file_entry {
	char	name[16];		/* name of file */
	long	seq_num;		/* number of file marks between this
					** directory and the file described
					** by this entry. 
					*/ 
	long	size;			/* size of file, in bytes */
	long 	checksum; 		/* checksum of file */
	char 	filler[4]; 		/* room for future expansion */
};


#define DIRMAGIC 	0xCCAA0000
