/* "@(#)utmp.h	5.1	6/6/86" */

/* <sys/types.h> must be included.     */

#define UTMP_FILE "/etc/utmp"
#define WTMP_FILE "/etc/wtmp"

struct utmp
{
   char     ut_name[8];		/* User login name */
   char att_ut_id[4];		/* /etc/lines id(usually line #) */
   char     ut_line[12];	/* device name (console, lnxx) */
   char     ut_host[16];	/* hostname if remote */
   int  att_ut_pid;		/* process id */
   int  att_ut_type;		/* type of entry */
   struct exit_status
   {
     short att_e_termination;	/* Process termination status */
     short att_e_exit;		/* Process exit status */
   }
        att_ut_exit;		/* exit status of a process marked as DEAD_PROCESS */
   long     ut_time;		/* time entry was made */
};

/* Definitions for att_ut_type      */

#define ATT_EMPTY		0
#define ATT_RUN_LVL		1
#define ATT_BOOT_TIME		2
#define ATT_OLD_TIME		3
#define ATT_NEW_TIME		4
#define ATT_INIT_PROCESS	5 /* Process spawned by "init" */
#define ATT_LOGIN_PROCESS	6 /* A "getty" process waiting for login */
#define ATT_USER_PROCESS	7 /* A user process */
#define ATT_DEAD_PROCESS	8
#define ATT_ACCOUNTING		9

#define ATT_UTMAXTYPE ATT_ACCOUNTING /* Largest legal value of ut_type */

/* Special strings or formats used in the "ut_line" field when */
/* accounting for something other than a process.   */
/* No string for the ut_line field can be more than 11 chars + */
/* a NULL in length.      */

#define ATT_RUNLVL_MSG	"run-level %c"
#define ATT_BOOT_MSGs	 "system boot"
#define ATT_OTIME_MSG	"old time"
#define ATT_NTIME_MSG	"new time"
