/* "@(#)types.h	5.1	6/6/86" */

/*
 * Basic system types and major/minor device constructing/busting macros.
 */

#if !defined(_TYPES)||!defined(ridge)
#ifdef ridge
#define _TYPES
#else

/* major part of a device */
#define	major(x)	((int)(((unsigned)(x)>>8)&0377))

/* minor part of a device */
#define	minor(x)	((int)((x)&0377))

/* make a device number */
#define	makedev(x,y)	((dev_t)(((x)<<8) | (y)))
#endif

typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
typedef	unsigned short	ushort;		/* sys III compat */

#ifdef vax
typedef	struct	_physadr { int r[1]; } *physadr;
typedef	struct	label_t	{
	int	val[14];
} label_t;
#endif
#ifdef ridge
typedef	struct _physadr { int r[1]; } *physadr;
typedef	unsigned int	uint;
typedef unsigned int	vers_t;
typedef short		cnt_t;
typedef	int		label_t[10];
typedef	long		paddr_t;
typedef	long		key_t;
#endif
typedef	struct	_quad { long val[2]; } quad;
typedef	long	daddr_t;
typedef	char *	caddr_t;
#ifdef ridge
typedef	unsigned int	ino_t;
#else
typedef	u_long	ino_t;
#endif
typedef	long	swblk_t;
typedef	int	size_t;
#ifdef ridge
typedef	long		time_t;
typedef	unsigned int	dev_t;
typedef	long		off_t;
#else
typedef	int	time_t;
typedef	short	dev_t;
typedef	int	off_t;
#endif

typedef	struct	fd_set { int fds_bits[1]; } fd_set;

#endif					/* ridge */
