BUFFSIZE EQU 16384 ;BUFFER SIZE
TBUF SEGMENT
BUFF1 DB BUFFSIZE DUP(0) ;ALTERNATE BUFFERS TO AVOID DMA ACROSS 64K
BUFF2 DB BUFFSIZE DUP(0)
TBUF ENDS
;
TDATA SEGMENT 'DATA'
 DB 'FORTAPE '
SP_SAVE DW 0
 DD FORTAPE
 DD 0
;
BUFFER DW BUFF1,BUFF2
;
FUNCTAB LABEL WORD
 DW FUNCT  ;00 RETURN STATUS
 DW WRITE  ;01 WRITE A BLOCK
 DW READ   ;02 READ A BLOCK
 DW WRITE  ;03 WRITE IN EDIT MODE
 DW READ   ;04 READ IN REVERSE EDIT MODE
 DW READ   ;05 READ IN REVERSE MODE
 DW FUNCT  ;06 WRITE TAPE MARK
 DW FUNCT  ;07 FORWARD SPACE FILE
 DW FUNCT  ;08 BACK SPACE FILE
 DW FUNCT  ;09 FORWARD SPACE RECORD
 DW FUNCT  ;10 BACK SPACE RECORD
 DW FUNCT  ;11 REWIND
 DW FUNCT  ;12 REWIND & UNLOAD
 DW FUNCT  ;13 SET 1600 BPI
 DW FUNCT  ;14 SET 3200 BPI
 DW FUNCT  ;15 SET FAST SPEED
 DW FUNCT  ;16 SET SLOW SPEED
 DW FUNCT  ;17 SET LONG GAP
 DW FUNCT  ;18 SET SHORT GAP
 DW FUNCT  ;19 ERASE FIXED
 DW FUNCT  ;20 ERASE TO EOT
 DW FUNCT  ;21 SET THE NUMBER OF RETRYS
 DW FUNCT  ;22 RESET ERROR COUNTS
 DW FUNCT  ;23 RETURN READ ERROR COUNT
 DW FUNCT  ;24 RETURN WRITE ERROR COUNT
 DW FUNCT  ;25 TEST FOR TAPE ADAPTER CARD
 DW FUNCT  ;26 TEST FOR UNIT ON LINE
 DW SETADR ;27 SET TAPE ADDRESS 0 - 7
FUNCMAX EQU ($-FUNCTAB)/2
;
TAPEFUNC DW 0
STATADDR DW 0,0
COUNTADR DW 0,0
BUFFADDR DW 0,0
TAPEADDR DW 0020H
;
TDATA ENDS
;
STACK SEGMENT 'STACK'
 DB 256 DUP(?)
STACK ENDS
;
 PUBLIC FORTAPE
TCODE SEGMENT 'CODE'
 ASSUME CS:TCODE,DS:TDATA
 DW SEG TDATA
FORTAPE PROC FAR
 JMP FT00
 DB 'FORTAPE ROUTINE'
FT00:
 MOV AX,TDATA
 MOV DS,AX
 MOV SP_SAVE,SP
 CLD
;
 PUSH DS                ;GET FUNCTION
 LDS SI,DWORD PTR ES:[BX]
 MOV AX,WORD PTR [SI]
 POP DS
 CMP AX,FUNCMAX
 MOV TAPEFUNC,AX
 JBE RS01
 MOV DX,0040H            ;SET COMMAND REJECT
 JMP RS02
RS01:
 SHL AX,1
 MOV SI,AX
 MOV CX,FUNCTAB[SI]       ;ADDRESS OF FUNCTION IN CX
;
 PUSH DS                  ;ADDRESS OF STATUS STRING
 LDS SI,DWORD PTR ES:[BX+4]
 MOV AX,WORD PTR [SI+2]
 MOV DX,WORD PTR [SI+4]
 POP DS
 MOV STATADDR,AX
 MOV STATADDR+2,DX
;
 MOV AX,WORD PTR ES:[BX+8]  ;ADDRESS OF COUNT
 MOV DX,WORD PTR ES:[BX+10]
 MOV COUNTADR,AX
 MOV COUNTADR+2,DX
;
 PUSH DS                  ;ADDRESS OF BUFFER STRING
 LDS SI,DWORD PTR ES:[BX+12]
 MOV AX,WORD PTR [SI+2]
 MOV DX,WORD PTR [SI+4]
 POP DS
 MOV BUFFADDR,AX
 MOV BUFFADDR+2,DX
;
 PUSH DS
 POP ES
 MOV AX,TAPEFUNC
 XCHG AL,AH
 CALL CX         ;CALL THE APPROPRIATE ROUTINE
RS02:            ;COMES BACK W/DX=STATUS
 LES DI,DWORD PTR STATADDR
 MOV CX,16
 OR  DX,DX
RS03:
 MOV AL,'T'
 JS  RS04
 MOV AL,'F'
RS04:
 STOSB
 SHL DX,1
 LOOP RS03
 RET
FORTAPE ENDP
;
WRITE PROC NEAR
 PUSH AX
 CALL CHKBUF
 POP AX
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]  ;GET COUNT INTO CX
 MOV DI,BUFFER
 MOV BX,TBUF
 MOV ES,BX                ;TARGET = ES:DI IN 'TBUF'
 PUSH DS
 LDS SI,DWORD PTR BUFFADDR   ;SOURCE = DS:SI FROM CALLER
 PUSH CX                  ;SAVE COUNT
 REP MOVSB                ;MOVE DATA TO OUR BUFFER
 POP CX
 POP DS
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H                  ;GO TO THE TAPE ROUTINE
 POP ES                   ;RESTORE ES
 RET
WRITE ENDP
;
READ PROC NEAR
 PUSH AX
 CALL CHKBUF
 POP AX
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]
 CMP CX,BUFFSIZE
 JBE RD01
 MOV CX,BUFFSIZE
RD01:
 MOV BX,TBUF
 MOV ES,BX
 MOV BX,BUFFER
 MOV DX,TAPEADDR
 INT 13H                   ;GO READ TAPE DATA
 LES SI,DWORD PTR COUNTADR
 MOV WORD PTR ES:[SI],CX   ;RETURN COUNT TO CALLER
 LES DI,DWORD PTR BUFFADDR ;GET ADDRESS OF CALLER'S BUFFER (ES:DI)
 PUSH DS
 MOV SI,BUFFER
 MOV AX,TBUF
 MOV DS,AX                 ;SOURCE = DS:SI
 REP MOVSB                 ;MOVE DATA BACK TO CALLER
 POP DS
 POP ES
 RET
READ ENDP
;
FUNCT PROC NEAR
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]
 POP ES
 MOV DX,TAPEADDR
 INT 13H
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV WORD PTR ES:[SI],CX   ;RETURN COUNT TO CALLER
 POP ES
 RET
FUNCT ENDP
;
SETADR PROC NEAR
 PUSH ES
 LES SI,DWORD PTR COUNTADR
 MOV CX,WORD PTR ES:[SI]
 POP ES
 CMP CX,7
 JA  STA01
 ADD CX,20H
 MOV TAPEADDR,CX
STA01:
 MOV AH,0
 CALL FUNCT
 RET
SETADR ENDP
;
CHKBUF PROC NEAR
 MOV AX,TBUF
 MOV CX,16
 MUL CX
 ADD AX,BUFFER
 ADC DX,0
 ADD AX,BUFFSIZE
 JZ  CKB01 ;OK
 JNC CKB01 ;OK
 MOV AX,BUFFER
 XCHG BUFFER+2,AX
 MOV BUFFER,AX
CKB01:
 RET
CHKBUF ENDP
;
TCODE ENDS
 END
