/*
**	menu.h:
**
**	This is the header file containing all of the declaration of
**	the major data structures.
**	This is part of the Menu system for the Perfect Software
**	line of Products.
*/
/*
**	Note that this system is a third generation of the Perfect Doc.
**	System. Eventuall progression of this system is intended to
**	evolve it into the third (fourth ?) generation of PDoc.
*/
#include "defs.h"

/*
**	lo_menu:
**	This controls the screen atributes for each element,
**	in the main menu.
*/
look	lo_menu[] = {
	{	/* look element zero (0) */
		LO_HIGHL,
		"Select",
		0,
		NULL
	}, {	/* look element one (1) */
		LO_HIGHL,
		"Edit",
		0,
		NULL
	}, {	/* look element two (2) */
		LO_HIGHL,
		"Format",
		0,
		NULL
	}, {	/* look element three (3) */
		LO_HIGHL,
		"Print",
		0,
		NULL
	}, {	/* look element four (4) */
		LO_HIGHL,
		"Spell",
		0,
		NULL
	}, {	/* look element five (5) */
		LO_HIGHL,
		"Quit",
		0,
		NULL
	}
};

/*
**	ac_menu:
**	This contains the information pertaining to execution of
**	actions (in the main menu).
*/
action	ac_menu[] = {
	{	/* action element zero (0) */
		fn_select
	}, {	/* action element one (1) */
		fn_edit
	}, {	/* action element two (2) */
		fn_format
	}, {	/* action element three (3) */
		fn_print
	}, {	/* action element four (4) */
		fn_spell
	}, {	/* action element five (5) */
		fn_quit
	}
};

#define COLUMN(n)	(n * 10)
/*
**	ob_menu:
**	this is the main menu which resides at the bottom of the
**	screen, since the chosen number of commands to be displayed
**	is seven, that allows sixteen characters of space to express
**	each command. Leaving room for edging this allows fourteen
**	characters max per name.
*/
object ob_menu[] = {
	{	/* menu element zero (0) */
		23,	COLUMN(0),
		OB_ACTION,
		&lo_menu[0],
		&ac_menu[0],
		&ob_menu[1],
		&ob_menu[5]
	}, {	/* menu element one (1) */
		23,	COLUMN(1),
		OB_ACTION,
		&lo_menu[1],
		&ac_menu[1],
		&ob_menu[2],
		&ob_menu[0]
	}, {	/* menu element two (2) */
		23,	COLUMN(2),
		OB_ACTION,
		&lo_menu[2],
		&ac_menu[2],
		&ob_menu[3],
		&ob_menu[1]
	}, {	/* menu element three (3) */
		23,	COLUMN(3),
		OB_ACTION,
		&lo_menu[3],
		&ac_menu[3],
		&ob_menu[4],
		&ob_menu[2]
	}, {	/* menu element four (4) */
		23,	COLUMN(4),
		OB_ACTION,
		&lo_menu[4],
		&ac_menu[4],
		&ob_menu[5],
		&ob_menu[3]
	}, {	/* menu element five (5) */
		23,	COLUMN(5),
		OB_ACTION,
		&lo_menu[5],
		&ac_menu[5],
		&ob_menu[0],
		&ob_menu[4]
	}
};

object	*gb_objp = NULL;
