/* SCREENS.C - Screen definitions for Config

	(C) 1982, 1983 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

	This file contains the screen layout routines, which are also
the entry and display routines for Config. */

#include "pfconfig.h"

int
SumPrnt()				/* Summarize printer description */
{
	int cnt;

	cnt=DSummary(
		"Paper  width:  ",
		MICATYPE,&printrec.dwidth,

		NONLNEXT,"Paper height: ",
		MICATYPE,&printrec.dheight,

		"Character width: ",
		MICATYPE,&printrec.stdhoriz,

		NONLNEXT,"Line height: ",
		MICATYPE,&printrec.stdvert,

		"Smallest horizontal movement: ",
		MICATYPE,&printrec.micahoriz,

		"Smallest vertical movement: ",
		MICATYPE,&printrec.micavert,

		"Proportionally-spaced font/printwheel? ",
		FLAGTYPE,&printrec.isprop,

		NULL);
	if (printrec.isprop) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Width table number: ",
		BRANGE,&printrec.fontnum,

		NULL);
	else cnt++;
	cnt=DSummary(
		SETNUM,cnt,

		"Generate online-readable output? ",
		FLAGTYPE,&printrec.isfile,

		NULL);
	if (printrec.isfile) return(cnt);
	cnt=DSummary(
		SETNUM,cnt,

		"Initial paper offset: ",
		MICATYPE,&printrec.paperoffset,

		"Special printer code: ",
		BRANGE,&printrec.prtcode,

		"Use Control-H for backspace? ",
		FLAGTYPE,&printrec.backspace,

		"Use Carriage Return (Control-M) for bare carriage return? ",
		FLAGTYPE,&printrec.barecr,

		"Use Form Feed (Control-L) for form feed? ",
		FLAGTYPE,&printrec.formfeed,

		"Type of synchronization protocol: ",
		BRANGE,&printrec.synctype,

		"Translate characters on output? ",
		FLAGTYPE,&printrec.needtran,

		NULL);
	if (printrec.needtran) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Translation table to use: ",
		BRANGE,&printrec.trannum,

		NULL);
	else ++cnt;
	cnt=DSummary(
		SETNUM,cnt,

		"Initialization string: ",
		STRING,&instr,

		"Reset string: ",
		STRING,&fnstr,

		"New line string: ",
		STRING,&nlstr,

		"Boldface on string: ",
		STRING,&bonstr,

		NULL);
	if (bonstr[0]) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Boldface off string: ",
		STRING,&boffstr,

		NULL);
	else cnt++;
	cnt=DSummary(
		SETNUM,cnt,

		"Italics on string: ",
		STRING,&ionstr,

		NULL);
	if (ionstr[0]) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Italics off string: ",
		STRING,&ioffstr,

		NULL);
	else cnt++;
	cnt=DSummary(
		SETNUM,cnt,

		"Font 1 on string: ",
		STRING,&f1onstr,

		NULL);
	if (f1onstr[0]) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Font 1 off string: ",
		STRING,&f1offstr,

		NULL);
	else cnt++;
	cnt=DSummary(
		SETNUM,cnt,

		"Font 2 on string: ",
		STRING,&f2onstr,

		NULL);
	if (f2onstr[0]) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Font 2 off string: ",
		STRING,&f2offstr,

		NULL);
	else cnt++;
	cnt=DSummary(
		SETNUM,cnt,

		"Font 3 on string: ",
		STRING,&f3onstr,

		NULL);
	if (f3onstr[0]) cnt=DSummary(
		SETNUM,cnt,

		NONLNEXT,"Font 3 off string: ",
		STRING,&f3offstr,

		NULL);

	return(cnt);
	}

FLAG
EntSty(field)			/* Enter a field of style paramiters */
	int field;
{
	int from, to;
	FLAG tflag;
	char tstring[7];
	int cnt;

	if (field==ALL) {
		from=1;
		to=18;
		}
	else from=to=field;
	for (; from<=to; ++from)  {
		switch (from) {

		case 1:
			if (DEnter(
				"How much space would you like between the top of the page and",
				"the page heading <1/2 inch: 1270 micas, 1 inch: 2540 micas>?",
				"Top margin in micas: ",
				MICATYPE,&scribrec.stop,
				NULL)) return(FALSE);
			break;
		case 2:
			if (DEnter(
				"How much space would you like between the page footing and the",
				"bottom of the page <1/2 inch: 1270 micas, 1 inch: 2540 micas>?",
				"Bottom margin in micas: ",
				MICATYPE,&scribrec.sbottom,
				NULL)) return(FALSE);
			break;
		case 3:
			if (DEnter(
				"How much space would you like between the left edge of the page",
				"and the text <1/2 inch: 1270 micas, 1 inch: 2540 micas>?",
				"Left margin in micas: ",
				MICATYPE,&scribrec.sleft,
				NULL)) return(FALSE);
			break;
		case 4:
			if (DEnter(
				"How much space would you like between the text and the right",
				"edge of the page <1/2 inch: 1270 micas, 1 inch: 2540 micas>?",
				"Right margin in micas: ",
				MICATYPE,&scribrec.sright,
				NULL)) return(FALSE);
			break;
		case 5:
			if (DEnter(
				"How much space would you like between the page heading and the",
				"beginning of the text <1/2 inch: 1270 micas, 1 inch: 2540 micas>",
				"Heading space in micas: ",
				MICATYPE,&scribrec.headerspace,
				NULL)) return(FALSE);
			break;
		case 6:
			if (DEnter(
				"How much space would you like between the bottom of the text",
				"and the page footing <1/2 inch: 1270 micas, 1 inch: 2540 micas>",
				"Footing space in micas: ",
				MICATYPE,&scribrec.footerspace,
				NULL)) return(FALSE);
			break;
		case 7:
			if (DEnter(
				"What is the default line spacing <single spacing: 10; double",
				"spacing: 20>?",
				"Line spacing in tenths: ",
				RANGE,5,50,&scribrec.linespacing,
				NULL)) return(FALSE);
			break;
		case 8:
			if (DEnter(
				"How much additional space would you like between paragraphs",
				"<1/6 inch: 423>?  Spacing in micas: ",
				MICATYPE,&scribrec.spread,
				NULL)) return(FALSE);
			break;
		case 9:
			if (DEnter(
				"How much should the first line of each paragraph be indented",
				"Indentation in multiples of the standard charater width: ",
				MICATYPE,&scribrec.indent,
				NULL)) return(FALSE);
			break;
		case 10:
			if (DEnter(
				"Tab stops are initially set at multiples of the tab spacing.",
				"Tab characters are only relevant within certain environments,",
				"such as Verbatim, that preserve whitespace. If you choose to ",
				"run Perfect Format with Verbatim as the top level environment",
				"most of the time then you should set this to the same value you",
				"use in Perfect Writer. <usually 8>",
				"Tab spacing: ",
				RANGE,1,132,&scribrec.tabcolums[0],
				NULL)) return(FALSE);
			for (cnt=1; cnt<MAXTABS; ++cnt) scribrec.tabcolumns[cnt]=
				scribrec.tabcolumns[cnt-1]+scribrec.tabcolumns[0];
			break;
		case 11:
			if (DEnter(
				"Do you want justification (even right margin)? ",
				FLAGTYPE,&tflag,
				NULL)) return(FALSE);
			scribrec.prefjust=(tflag?'b':'l');
			break;
		case 12:
			if (DEnter(
				"The @foot command can place notes at the bottom of the page, at",
				"the end of the document, or inline (parenthesized at the point",
				"of reference).",
				"Type of foot notes (Bottom, End, Inline): ",
				STRING,7,&tstring,
				NULL)) return(FALSE);
			scribrec.footstyle=tolower(tstring[0]);
			break;
		case 13:
			if (DEnter(
				"Footnote references can be printed as superscripts or bracketed.",
				"Use superscripts for footnote numbers? ",
				FLAGTYPE,&scribrec.footpush,
				NULL)) return(FALSE);
			break;
		case 14:
			if (DEnter(
				"Subscripts from one line and superscripts from the next line",
				"can run together unless extra space is left.  However, such",
				"extra space can be visually distracting.  Space is always left",
				"on devices that cannot half-linefeed.",
				"Allow extra vertical space? ",
				FLAGTYPE,&scribrec.scriptpush,
				NULL)) return(FALSE);
			break;
		case 15:
			if (DEnter(
				"There are two styles of sectioning commands available.  The",
				"simple form provides three levels of sectioning starting with",
				"the section command while the full form provides four levels",
				"of sectioning starting with the chapter command.",
				"Use four level sectioning? ",
				FLAGTYPE,&scribrec.ischapter,
				NULL)) return(FALSE);
			break;
		case 16:
			if (DEnter(
				"How much vertical space would you like above each enviroment",
				"<1/6 inch: 423>? Height in micas: ",
				MICATYPE,&scribrec.above,
				NULL)) return(FALSE);
			break;
		case 17:
			if (DEnter(
				"How much vertical space would you like below each enviroment",
				"<1/6 inch: 423>? Height in micas: ",
				MICATYPE,&scribrec.below,
				NULL)) return(FALSE);
			break;
		case 18:
			if (DEnter(
				"The endspace is the area reserved for storing endnotes,",
				"table of contents and index information <1000 bytes>.",
				"Amount of endspace in bytes: ",
#ifdef CPM
				RANGE,0,20000,&scribrec.endsize,
#else
				RANGE,0,(unsigned) 65535,&scribrec.endsize,
#endif
				NULL)) return(FALSE);
			}
		}
	return(TRUE);
	}

int
SumSty()				/* Summarize style paramiters */
{
	int cnt;
	char tstring[7];
	FLAG tflag;

	tflag=(scribrec.prefjust=='b');
	switch (scribrec.footstyle) {

	case 'i':
		strcpy(tstring,"Inline");
		break;
	case 'b':
		strcpy(tstring,"Bottom");
		break;
	case 'e':
		strcpy(tstring,"End");
		break;
		}
	cnt=DSummary(
		TITLE, "Perfect Format default style parameters",

		"Top of page margin: ",
		MICATYPE,&scribrec.stop,

		"Bottom of page margin: ",
		MICATYPE,&scribrec.sbottom,

		"Left margin: ",
		MICATYPE,&scribrec.sleft,

		"Right margin: ",
		MICATYPE,&scribrec.sright,

		"Space between heading and top of text: ",
		MICATYPE,&scribrec.headerspace,

		"Space between bottom of text and footing: ",
		MICATYPE,&scribrec.footerspace,

		"Line spacing (in 1/10 line): ",
		RANGE,&scribrec.linespacing,

		"Space between paragraphs: ",
		MICATYPE,&scribrec.spread,

		"Amount to indent first line of paragraphs in characters: ",
		RANGE,&scribrec.indent,

		"Tab spacing in characters: ",
		RANGE,&scribrec.tabcolums[0],

		"Justify right margin? ",
		FLAGTYPE,&tflag,

		"Type of foot notes: ",
		STRING,&tstring,

		"Use superscripts for footnote numbers? ",
		FLAGTYPE,&scribrec.footpush,

		"Allow extra vertical space for super/sub scripts? ",
		FLAGTYPE,&scribrec.scriptpush,

		"Allow full four level sectioning? ",
		FLAGTYPE,&scribrec.ischapter,

		"Vertical space to leave above an environment: ",
		MICATYPE,&scribrec.above,

		"Vertical space to leave below an environment: ",
		MICATYPE,&scribrec.below,

		"Amount of space to reserve for end data: ",
		RANGE,&scribrec.endsize,

		NULL);
	return(cnt);
	}

/* END OF SCREENS.C - Config entry and display routines */
                                                                                                             