/* CONFIG.H - Global declarations for Config

	Copyright (c) 1982, 1983 by Perfect Software

	These are the global declarations for the Configuration program. */

/* Universal constants */

#include "date.c"

/* #define UNIX	1		*/	/* Pick one of these only */
/* #define CPM	1		*/
#define LATTICE

#ifdef LATTICE
#include "a:stdio.h"
#include "a:ctype.h"
#undef	putchar
#endif

#define TRUE	(-1)
#define FALSE	0
#define NULL	0
#define FLAG	char
#define MICA	unsigned

#ifdef CPM
#define INPUT	0
#define OUTPUT	1
#define UPDATE	2
#endif

#ifdef LATTICE
#define INPUT	0x8000
#define	OUTPUT	0x8001
#define UPDATE	0x8002
#endif

#ifdef UNIX
#define INPUT	0
#define	OUTPUT	1
#define UPDATE	2
#endif

#define ABS	0
#define repeat	while (1)

#ifdef CPM
#define RECSIZE	1
#else
#define RECSIZE	128
#endif

#define NUL	'\0'
#define BELL	'\07'
#define CANCEL	'\07'
#define BS	'\b'
#define TAB	'\t'
#define LF	'\n'
#define NL	'\n'
#define CR	'\r'
#define QUOTE	'\021'
#define ESC	'\033'
#define DEL	'\177'

#ifdef CPM
#define MAXMICA	48000	/* largest possible mica measurement */
#else
#define MAXMICA ((unsigned)48000)	/* largest possible mica measurement */
#endif

/* Config globals */

#define DATABASE	"pf.dat"
#define ALL		(-1)

	FLAG smartp;			/* Smart terminal mode? */
	int fd;				/* data file, file descriptor */
	char tsect[128];		/* temporary sector data */


/* Display globals */

#define TABINCR	8

	int pcol;				/* Current cursor column */

	/* data types */
#define FLAGTYPE	1
#define HEXBYTE	2
#define MICATYPE	3
#define RANGE		4
#define BRANGE		5
#define STRING		6

#define TITLE		7
#define SETNUM		8

#define NONLNEXT 9

/* Config file utilities globals */

#define SCRIBBLE	1
#define PORT		2
#define TERM		3
#define PRINT		4
#define MICRO		5
#define TRAN		6


/* The Master data section */

struct header {
			/* Input/output port descriptions */
	int fport;			/* the first port record */
	int coninp;			/* console input port */
	int conoutp;			/* console output port */
	int prtinp;			/* Printer input(??) port */
	int prtoutp;			/* printer output port */
	int modinp;			/* modem input port */
	int modoutp;			/* modem output port */
			/* Terminal type descriptions */
	int fterm;			/* first terminal record */
	int ourterm;			/* the default terminal type */
	int simterm;			/* terminal type to simulate */
			/* Printer descriptions */
	int fprint;			/* first printer record */
	int ourprint;			/* the default printer type */
	int conprint;			/* the printer type of the console */
			/* Character width tables */
	int fmicro;			/* the first micro-spacing table record */
	int maxmicro;			/* the number of micro spacing records */
			/* Character translation tables */
	int ftran;			/* the first translation record */
			/* The size of the data file */
	int hmax;				/* number of records including header */

	int cpuspeed;			/* cpu speed in 100KHz */
	char verse[16];		/* version number */
	} hdr;

#define MAXTABS	32		/* max # of tabs */
struct {
	MICA tabcolumns[MAXTABS];/* where tabs are */
	MICA headerspace;		/* vertical space to leave after header */
	MICA footerspace;		/* and before footer */
	char prefjust;			/* preferred justification style
							'b' both  or  'l' left */
	char footstyle;		/* where footnotes go:  'i' inline,
							'b' bottom, 'e' end */
	MICA indent;			/* amount to indent paragraphs */
	MICA spread;			/* number of lines between paragraphs */
	MICA linespacing;
	FLAG footpush;			/* footnote references */
	FLAG scriptpush;		/* do super/sub scripts get more space */
	FLAG ischapter;		/* does @chapter command exist */
	MICA stop;			/* margins */
	MICA sleft;
	MICA sright;
	MICA sbottom;
	MICA above;			/* space to leave before an environment */
	MICA below;			/* space to leave after an environment */
	FLAG levindent;		/* do nested Level environments indent? */
	FLAG levhang;			/* are Level paragraphs outdented? */
	int endsize;			/* space to reserve for enddata */
	} scribrec;

struct portdesc {
	char pname[16];		/* Zero terminated port name */
	FLAG dbiosp;			/* Use the bios call numbered by the data
							port if non-zero */
	char dataport;			/* Data port, or bios call number */
	char datamask;			/* Mask to AND data with */
	FLAG sbiosp;			/* Use the bios call numbered by the status
							port if non-zero */
	char statport;			/* Status port, or bios call number */
	char readymask;		/* Mask to AND status with */
	char polarity;			/* (Status AND mask == <this>) if ready */
	} portrec;

#define SSPACE	128-66
struct printdesc {		/* describes the output device */
	char dname[16];		/* name of the device */
	MICA dwidth;			/* width of the printing surface */
	MICA dheight;			/* height of the print surface */
	MICA micahoriz;		/* size of smallest horizontal increment */
	MICA micavert;			/* size of smallest vertical increment */
	FLAG isprop;			/* does it have a proportional width font? */
	char fontnum;			/* if isprop, which width table to use */
	MICA stdhoriz;			/* width of a canonical character */
	MICA stdvert;			/* height of a single spaced line */
	FLAG isfile;			/* do plain file output? */
	char prtcode;			/* printer type code for crayon */
	MICA paperoffset;		/* height paper is assumed to start at */
	FLAG backspace;		/* Does backspace work */
	FLAG barecr;			/* does bare CR work */
	FLAG formfeed;			/* does form feed work */
	char synctype;			/* Type of waiting to do: NONE, ETX/ACK, ^S^Q */
	FLAG needtran;			/* Do character translation on output? */
	char trannum;			/* Translation table number */
	struct str {			/* Various strings to send */
		char idx;					/* index into space */
		char len;					/* length */
		} initstr,			/* ... set things up */
			finistr,			/* ... clean up after */
			donewline,		/* ... do a newline */
			boldon,			/* ... turn on boldface */
			boldoff,			/* turn off boldface */
			italon,			/* turn on italics */
			italoff,			/* turn off italics */
			f1on,			/* Font one on */
			f1off,			/* font one off */
			f2on,			/* font 2 on */
			f2off,			/* font2 off */
			f3on,			/* font3 on */
			f3off;			/* font3 off */
	char strspc[SSPACE];	/* where strings are stored */
	} printrec;

struct widdesc {			/* Character width table record */
	MICA cwid[128];
	} widrec;

struct trandesc {			/* Character translation table record */
	char trantbl[128];
	} tranrec;

/* String storage temporary variables */

	char instr[20];		/* initstr entry temp */
	char fnstr[20];		/* finistr entry temp */
	char nlstr[20];		/* donewline entry temp */
	char bonstr[20];		/* bold on entry temp */
	char boffstr[20];		/* bold off entry temp */
	char ionstr[20];		/* italic on entry temp */
	char ioffstr[20];		/* italic off entry temp */
	char f1onstr[20];		/* f1 on entry temp */
	char f1offstr[20];		/* f1 off entry temp */
	char f2onstr[20];		/* f2 on entry temp */
	char f2offstr[20];		/* f2 off entry temp */
	char f3onstr[20];		/* f3 on entry temp */
	char f3offstr[20];		/* f3 off entry temp */

#ifdef UNIX
#define isupper(tchar) (tchar>='A' && tchar<='Z')
#define islower(tchar) (tchar>='a' && tchar<='z')
#define tolower(tchar) (isupper(tchar)?tchar-'A'+'a':tchar)
#define toupper(tchar) (islower(tchar)?tchar-'a'+'A':tchar)
#define isdigit(tchar) (tchar>='0' && tchar<='9')
#define isalpha(tchar) (isupper(tchar) || islower(tchar))
#endif

#ifdef LATTICE
#define seek(file,offset,mode)	lseek((file), (long) (offset), (mode))
#endif


/* END OF CONFIG.H - Config program global declarataf1ons */
