/* $NetBSD: lca_pci.c,v 1.13 1997/09/02 13:19:35 thorpej Exp $ */

/*
 * Copyright (c) 1995, 1996 Carnegie-Mellon University.
 * All rights reserved.
 *
 * Author: Chris G. Demetriou
 * 
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND 
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */

#include <sys/cdefs.h>			/* RCS ID & Copyright macro defns */

__KERNEL_RCSID(0, "$NetBSD: lca_pci.c,v 1.13 1997/09/02 13:19:35 thorpej Exp $");

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/device.h>
#include <vm/vm.h>

#include <dev/pci/pcireg.h>
#include <dev/pci/pcivar.h>
#include <alpha/pci/lcareg.h>
#include <alpha/pci/lcavar.h>

void		lca_attach_hook __P((struct device *, struct device *,
		    struct pcibus_attach_args *));
int		lca_bus_maxdevs __P((void *, int));
pcitag_t	lca_make_tag __P((void *, int, int, int));
void		lca_decompose_tag __P((void *, pcitag_t, int *, int *,
		    int *));
pcireg_t	lca_conf_read __P((void *, pcitag_t, int));
void		lca_conf_write __P((void *, pcitag_t, int, pcireg_t));

void
lca_pci_init(pc, v)
	pci_chipset_tag_t pc;
	void *v;
{

	pc->pc_conf_v = v;
	pc->pc_attach_hook = lca_attach_hook;
	pc->pc_bus_maxdevs = lca_bus_maxdevs;
	pc->pc_make_tag = lca_make_tag;
	pc->pc_decompose_tag = lca_decompose_tag;
	pc->pc_conf_read = lca_conf_read;
	pc->pc_conf_write = lca_conf_write;
}

void
lca_attach_hook(parent, self, pba)
	struct device *parent, *self;
	struct pcibus_attach_args *pba;
{
}

int
lca_bus_maxdevs(cpv, busno)
	void *cpv;
	int busno;
{

	if (busno == 0)
		return 16;
	else
		return 32;
}

pcitag_t
lca_make_tag(cpv, b, d, f)
	void *cpv;
	int b, d, f;
{

	return (b << 16) | (d << 11) | (f << 8);
}

void
lca_decompose_tag(cpv, tag, bp, dp, fp)
	void *cpv;
	pcitag_t tag;
	int *bp, *dp, *fp;
{

	if (bp != NULL)
		*bp = (tag >> 16) & 0xff;
	if (dp != NULL)
		*dp = (tag >> 11) & 0x1f;
	if (fp != NULL)
		*fp = (tag >> 8) & 0x7;
}

pcireg_t
lca_conf_read(cpv, tag, offset)
	void *cpv;
	pcitag_t tag;
	int offset;
{
	struct lca_config *lcp = cpv;
	pcireg_t *datap, data;
	int s, secondary, device, ba;

	s = 0;					/* XXX gcc -Wuninitialized */

	/* secondary if bus # != 0 */
	alpha_pci_decompose_tag(&lcp->lc_pc, tag, &secondary, &device, 0);
	if (secondary) {
		s = splhigh();
		alpha_mb();
		REGVAL(LCA_IOC_CONF) = 0x01;
		alpha_mb();
	} else {
		/*
		 * on the LCA, must frob the tag used for
		 * devices on the primary bus, in the same ways
		 * as is used by type 1 configuration cycles
		 * on PCs.
		 */
		tag = (1 << (device + 11)) | (tag & 0x7ff);
	}

	datap = (pcireg_t *)ALPHA_PHYS_TO_K0SEG(LCA_PCI_CONF |
	    tag << 5UL |					/* XXX */
	    (offset & ~0x03) << 5 |				/* XXX */
	    0 << 5 |						/* XXX */
	    0x3 << 3);						/* XXX */
	data = (pcireg_t)-1;
	if (!(ba = badaddr(datap, sizeof *datap)))
		data = *datap;

	if (secondary) {
		alpha_mb();
		REGVAL(LCA_IOC_CONF) = 0x00;
		alpha_mb();
		splx(s);
	}

#if 0
	printf("lca_conf_read: tag 0x%lx, reg 0x%lx -> %x @ %p%s\n", tag, reg,
	    data, datap, ba ? " (badaddr)" : "");
#endif

	return data;
}

void
lca_conf_write(cpv, tag, offset, data)
	void *cpv;
	pcitag_t tag;
	int offset;
	pcireg_t data;
{
	struct lca_config *lcp = cpv;
	pcireg_t *datap;
	int s, secondary, device;

	s = 0;					/* XXX gcc -Wuninitialized */

	/* secondary if bus # != 0 */
	alpha_pci_decompose_tag(&lcp->lc_pc, tag, &secondary, &device, 0);
	if (secondary) {
		s = splhigh();
		alpha_mb();
		REGVAL(LCA_IOC_CONF) = 0x01;
		alpha_mb();
	} else {
		/*
		 * on the LCA, must frob the tag used for
		 * devices on the primary bus, in the same ways
		 * as is used by type 1 configuration cycles
		 * on PCs.
		 */
		tag = (1 << (device + 11)) | (tag & 0x7ff);
	}

	datap = (pcireg_t *)ALPHA_PHYS_TO_K0SEG(LCA_PCI_CONF |
	    tag << 5UL |					/* XXX */
	    (offset & ~0x03) << 5 |				/* XXX */
	    0 << 5 |						/* XXX */
	    0x3 << 3);						/* XXX */
	*datap = data;

	if (secondary) {
		alpha_mb();
		REGVAL(LCA_IOC_CONF) = 0x00;	
		alpha_mb();
		splx(s);
	}

#if 0
	printf("lca_conf_write: tag 0x%lx, reg 0x%lx -> 0x%x @ %p\n", tag,
	    reg, data, datap);
#endif
}
