.\" $XConsortium: Xamiga.man,v 0.0 00/00/00 00:00:00 nobody Exp $
.TH XAMIGA 1 "Release 6.3" "X Version 11"
.SH NAME
Xamiga \- NetBSD/Amiga server for X Version 11
.SH SYNOPSIS
.B Xamiga
[ option ] ...
.SH DESCRIPTION
.I Xamiga
is the server for Version 11 of the X window system on Amiga systems
running NetBSD.
It will normally be started by the \fIxdm(1)\fP daemon or by a script
that runs the program \fIxinit(1)\fP.
.SH CONFIGURATIONS
.PP
Xamiga
support the follwing graphic modes:
.PP
.nf
Amiga CustomChips Color/Monochrome (ECS/AGA)
General Gfx Board (Dumb Chunky Framebuffer)
GFX accelerator for the RetinaZ3 and the Altais Graphics boards
Cirrus based Graphics Board (Picollo, Picollo SD64, Spectrum,
    PicassoII, II+ and IV)
GFX accelerator for the CyberVision64 Graphics board
Dumb Chunky Framebuffer for the CyberVision64/3D Graphics board
.PP
.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXamiga\fP accepts the following command line switches:

.SH GENERAL OPTIONS (all devices)
.TP 8
.B "\-ar1 \fImilliseconds\fP"
This option specifies amount of time in milliseconds before which a pressed
key should begin to autorepeat.
.TP 8
.B "\-ar2\fP \fImilliseconds\fP"
This option specifies the internal in milliseconds between autorepeats of
pressed keys.
.TP 8
.B \-debug
This option indicates that the server is being run from a debugger,
and that it should \fBnot\fP
put its standard input, output and error files into non-blocking mode.
.TP 8
.B "\-dev \fIfn[:fn][:fn]\fP"
This option specifies the graphics devices which the server shall use for
displaying (e.g. /dev/grf0 for Amiga Chipset, /dev/grf2 for RetinaZ3,
/dev/grf3 for Cirrus based boards (Picollo, Picollo SD64, Spectrum,
PicassoII, II+ and IV), /dev/grf5 for CyberVision64, /dev/grf6 for
Tseng ET4000 based boards (oMniBus, Domnio, Merlin), /dev/grf7 for
CyberVision64/3D). Multiple devices must be seperated with a colon.
Default are all available devices. 
.TP 8
.B \-mouse \fImousedevice\fP
This option specifies the mouse device (default: /dev/mouse0).
You can use any firm-event producing pointing device (as of the NetBSD-1.2
kernel, an Amiga mouse connected to /dev/mouse0 or /dev/mouse1 only), or a
serial mouse on any tty device which produces the "Microsoft" mouse protocol
with an optional 3rd button byte.
Firm event producing devices will be autodetected; else Microsoft mouse
protocol is assumed.
.TP 8
.B \-emulatemiddle, -2
With this option turned on, the middle mouse button is emulated by 
pressing left and right button together. Useful for 2-Button mice. 
.TP 8
.B \-emulateright, -3
Similar to -emulatemiddle, except that the right mousebutton is emulated. 
.TP 8
.B \-flipPixels
Switch colors 0 and 1. This is to avoid the ugly white bar at the right
on CyberVision64 and CyberVision64/3D boards.
.TP 8
.B \-mono
This option is used to force monocrome mode (not supported on gfx boards).
.TP 8
.B \-nozap, -nopanickeys
This option disables the CTRL-ALT-BACKSPACE key sequence which will terminate the server
immediately unless it is hung and not processing input events.

.SH OPTIONS FOR AMIGA CUSTOM CHIP DISPLAY

These options are only used if the display is on the Amiga Custom Chips, i.e.
-dev /dev/grf0 is specified at the command line.

.TP 8
.B "\-width \fIint\fP," "\-W \fIint\fP
Set the display width to <int> pixels.
.TP 8
.B "\-height \fIint\fP," "\-H \fIint\fP"
Set the display height to <int> pixels.
.TP 8
.B "\-depth \fIint\fP," "\-D \fIint\fP"
Set the display depth to <int> planes.
.TP 8
.B "\-X \fIint\fP"
Set the display X offset to <int> pixels. 
.TP 8
.B "\-Y \fIint\fP"
Set the display Y offset to <int> pixels.

.SH COMMON OPTIONS FOR ALL GFX BOARDS

.TP 8
.B "\-mode \fInum\fP"
This option specifies the videomode to use on the display. See also the
manpage for \fIgrfconfig(8)\fP on how to set videomodes for /dev/grf[356].
The RetinaZ3 (/dev/grf2) has its videomodes in the kernel and can therefore
not be changed with \fIgrfconfig(8)\fP. Default is the last mode used.
.TP 8
.B \-noGX
Do not use an existing accellerated Gfx driver for /dev/grf[235].
.TP 8
.B \-useHWC
Use the hardware cursor for displaying the mouse pointer.
The hardware cursor is disabled by default, because there are some
problems on Gfx Boards:
.nf
- Some Chip Revisions of the RetinaZ3 VGA chip have
  problems with the mouse pointer.
- The mouse pointer on 1MB Ciruss Gfx Boards are
  corrupt, thats a problem in the NetBSD kernel
  which needs to be fixed.

.SH OPTIONS FOR CyberVision64
These options are only used if the display is on the CyberVision64, i.e.
-dev /dev/grf5 is specified at the command line.

.TP 8
.B "\-virtualW \fIint\fP"
Set the virtual screen width to <int> pixels. So one is able to use
bigger screens than the display size. Allowed values are 
640, 800, 1024, 1152, 1280 or 1600, this is due to a limitation of the
S3Trio64 chip.
.TP 8
.B "\-virtualH \fIint\fP"
Set the virtual screen height to <int> pixels.
The only limit here is the size of the graphics memory.

.SH ADDITIONAL NOTES TO CyberVision64 USERS
.PP 
-If you have defined a continuous range of videomodes with the same depth
you can switch between them with "ctrl"-"alt"-"Keypad+" and
"ctrl"-"alt"-"Keypad-". (The idea is "stolen" from xfree86).

-The screenmodes are defined with \fIgrfconfig(8)\fP (read the manpage,
if you haven't already!). A tool (ReadCVMonitor1.0) for converting
CybergraphX modes to \fIgrfconfig(8)\fP format can be found on
ftp.uni-regensburg.de in the /pub/NetBSD-Amiga/tools directory. 

.SH "SEE ALSO"
.PP
X(1), Xserver(1), xdm(1), xinit(1), grfconfig(8), grfcl(4),  grfcv(4),
grfcv3d(4),  grfet(4), grfrh(4),  grfrt(4),  grful(4)
.SH BUGS
.PP
The Cirrus accelerator part works only in 8bit.
.SH AUTHORS
.TP 8
U. C. Berkeley
Adam de Boor.
.TP 8
Sun Microsystems
David Rosenthal,  Stuart Marks,  Robin Schaufler,  Mike Schwartz,
Frances Ho,  Geoff Lee,  and Mark Opperman.
.TP 8
MIT Laboratory for Computer Science
.br
Bob Scheifler, Keith Packard
.TP 8 
Amiga Custom Chip work by 
Eduardo Horvath and Andy Heffernan
.TP 8 
Retina support by 
Markus Wild
.TP 8
CyberVision64 support and manpage by 
Michael Teske
.TP 8  
"Unification" of the former three Amiga servers by 
Michael Teske and Bernd Ernesti
.TP 8
Support of serial mice by
Ignatios Souvatzis
