.LP
.in |1.0i
.na
.nr PS 10
.nr VS 14
.DA "29 March 1990"
.TL
X Display Management from an Inaccessible Host
.DS C
Describing an experiment with \fIxdm\fP
.br
Donn Cave
University Computing Services
University of Washington
.DE
.LP
This report briefly describes an experimental modification of the MIT
X11 Release 4 \fIxdm\fP display manager.  The purpose of the experiment
is to develop a display management system that is more reliable and
more flexible.
.SH
The System
.LP
The MIT \fIxdm\fP was split into two separate programs.  \fIPhase I\fP
conducts all the XDMCP dialog, and \fIPhase II\fP checks the user's name
and password and initializes the session.
.SH
Phase I
.LP
This program, which may as well continue to be called \fIxdm\fP, runs on
a reliable host.  The network location of such hosts is purely a matter
of convenience and network efficiency, since the general user population
isn't expected to know anything about them.
.LP
When contacted by an
XDMCP-speaking server, \fIxdm\fP creates a SelectHost window on its
display 0, and then attempts to contact the \fIPhase II\fP server on the
selected host.  If \fIPhase II\fP reports that it has succeeded in starting
a session, \fIxdm\fP creates a Logout window.
.LP
When the Logout window is selected, \fIxdm\fP terminates the session.  While
waiting for this event, it continues its half of the XDMCP dialog,
and is responsible for terminating a session should the server become defunct.
.SH
Phase II
.LP
This is a login server, that runs on the kind of
hosts where users have their accounts.
The program might be called \fIxlogind\fP.  It accepts
connections on a well-known port, and in response to a request delivered
over such a connection, forks off and starts a session.
.LP
The first step is to present the XLogin window, collect the user's name
and password, and check to see that they are legitimate.
.LP
\fIxlogin\fP reports back to \fIxdm\fP with the user name.  If the user
failed login, the user name is null.  If the login succeeded, xlogind
then runs the session startup script(s), just as the MIT \fIxdm\fP would.
The only difference is that \fIxlogind\fP can be allowed to exit without
ending the session, so the last command in the script doesn't have to be
run in the foreground.
.SH
Results
.LP
This system has been running on ``Uniform Access'' UNIX mainframes for over
half a year, serving a small population of NCD X terminals.  Our NCD users
are still largely in-house staff whose activities are spread out fairly
evenly over the mainframes, with the X login host supporting the window
manager plus terminal emulator clients for hosts without X.  We haven't
yet put in an X terminal lab, which would be the most obvious application
of this idea.
.LP
There are a couple of minor problems.  The \fIxdm\fP client windows take some
memory, depending on how complex they are; perhaps it should be rewritten so
that the first window runs as a separate client, which would leave only the
little Logout window to compete with regular clients.
.LP
There is some extra inconvenience in having to select the X login host and
wait for the XLogin window, and it probably would be easier to explain the
terminal's various dependencies if the xdm server and the X login server
were the same.
