#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>

#include "dm.h"
#ifdef stand_alone
#include <stdio.h>
#define LogError printf
void Debug () {printf ("...\n");}
#define Debug printf
#endif

extern XtAppContext context;
extern Widget toplevel;
extern Display *dpy;

static XtIntervalId pingTimeout;


static void
LogoutPingServer (closure, intervalId)
     XtPointer closure;
     XtIntervalId *intervalId;
{
  struct display *d;

  d = (struct display *) closure;
#ifndef stand_alone
  if (!PingServer (d, XtDisplay (toplevel))) SessionExit (d, RESERVER_DISPLAY);
#endif
  pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				 LogoutPingServer, (closure));
}

static int done;
static void
LogoutDone (w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  Debug ("LogoutDone\n");
  done = 1;
}

#ifdef comment
static void
LogoutDestroyed (w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  Debug ("LogoutDestroyed\n");
  done = -1;
}
#endif

#ifdef stand_alone
static int Margc;
static char **Margv;
main (argc, argv) int argc; char *argv[]; {
	struct display d;

	Margv = argv;
	Margc = argc;
	d.name = 0;
	d.pingInterval = 0;
	Init (&d);
	WaitForLogout (&d);
	WaitForLogout (&d);
	Debug ("I'm through.\n");
}
#else
#define Margc argc
#define Margv argv
#endif

int
WaitForLogout (d)
     struct display *d;
{
  Arg arglist[10];
  XtCallbackRec callbacks[2];
  Widget popupShell;
  Widget command;
  XEvent event;
  int i;

  popupShell = XtCreatePopupShell ("logout", topLevelShellWidgetClass,
		toplevel, NULL, 0);

  i = 0;
  callbacks[0].callback = (XtCallbackProc) LogoutDone;
  callbacks[0].closure = (caddr_t) 0;
  callbacks[1].callback = (XtCallbackProc) 0;
  callbacks[1].closure = (caddr_t) 0;
  XtSetArg (arglist[i], XtNcallback, callbacks); ++i;
  command = XtCreateManagedWidget ("command", commandWidgetClass, popupShell,
				   arglist, i);

  XtPopup (popupShell, XtGrabNone);

  if (d->pingInterval) {
    pingTimeout = XtAppAddTimeOut (context, d->pingInterval * 60 * 1000,
				   LogoutPingServer, (XtPointer) d);
  }

  done = 0;
  while (!done) {
    XtAppNextEvent (context, &event);
    XtDispatchEvent (&event);
  }
  XFlush (XtDisplay (toplevel));
  Debug ("Logout done = %d\n", done);
  return done > 0;
}
