#include <sys/types.h>
#include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
#include <sys/ioctl.h>
/*#include <sys/wait.h>*/
#include "dm.h"

void
CommitToXdmSocket ()
{
  struct sockaddr_in name;
  int sock;
  int len;

  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    Debug ("Couldn't open listener socket\n");
    exit (1);
  }
  name.sin_family = AF_INET;
  name.sin_addr.s_addr = INADDR_ANY;
  {unsigned short hport = 5383;
  name.sin_port = htons (hport);
  }

  if (bind (sock, (struct sockaddr *) &name, sizeof (name)) < 0) {
    Debug ("Couldn't bind listener socket\n");
    exit (1);
  }
  listen (sock, 5);
  len = sizeof (name);
  for (;;) {
	int pid, g, nb;

	g = accept (sock, (struct sockaddr *) &name, &len);
	if (g < 0) {
		break;
	}
	pid = fork ();
	if (pid) {
		close (g);
	}
	else {
		close (sock);
		StartSession (g);
	}
	/* check for any dying processes */
	/* waitpid (-1, NULL, WNOHANG); */
	wait3 (0, WNOHANG, 0);
  }
}

int
ReadRemote (sock, buffer, size)
	int sock;
	char *buffer;
	int size;
{
	int nb;

	nb = recv (sock, buffer, size, 0);
	if (nb < 0) {
		LogError ("Error reading socket %d\n", sock);
		nb = 0;
	}
	buffer[nb] = (char) 0;
	return nb;
}

void
ReturnRemote (sock, string)
	int sock;
	char *string;
{
	unsigned char len;

	len = strlen (string) + 0x30;
	Debug ("sending count prefix 0x%02x\n", len);
	send (sock, &len, 1, 0);
	Debug ("sending string \"%s\"\n", string);
	send (sock, string, len, 0);
	LogInfo ("Remote session validated: %s\n", string);
	close (sock);
}

void
AckRemote (sock)
     int sock;
{
  static char data = 0x31;
  if (send (sock, &data, 1, 0) < 0) LogError ("error sending ack on %d\n", sock);
}  





