/************************************************************************
Copyright 1990 by Network Computing Devices, Inc.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of NCD not be used in advertising or
publicity pertaining to distribution of the software without specific
prior written permission.  NCD makes no representation about the
suitability of this software for any purpose. It is provided "as is"
without any express or implied warranty.

NCD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
OR PERFORMANCE OF THIS SOFTWARE.

************************************************************************/

#ident "@(#)XncdSie.c	15.3	91/01/09"

#define NEED_EVENTS
#define NEED_REPLIES
#include "Xlibint.h"
#include "Xext.h"			/* in ../include */
#include "extutil.h"			/* in ../include */
#include "ncdsiestr.h"			/* in ../include */

static XExtensionInfo*		sieInfo;
static /* const */ char*	sieExtensionName= SIENAME;

#define SieCheckExtension(dpy, i, val)					\
  XextCheckExtension (dpy, i, sieExtensionName, val)

#define SieSimpleCheckExtension(dpy, i)					\
  XextSimpleCheckExtension (dpy, i, sieExtensionName)


/***********************************************************************\
|			   private utility routines			|
\***********************************************************************/

static int CloseDisplay ();

static /* const */ XExtensionHooks sieExtensionHooks =
{
    NULL,				/* create_gc */
    NULL,				/* copy_gc */
    NULL,				/* flush_gc */
    NULL,				/* free_gc */
    NULL,				/* create_font */
    NULL,				/* free_font */
    CloseDisplay,			/* close_display */
    NULL,				/* wire_to_event */
    NULL,				/* event_to_wire */
    NULL,				/* error */
    NULL,				/* error_string */
};

static XEXT_GENERATE_FIND_DISPLAY (FindDisplay, sieInfo,
				   sieExtensionName, 
				   &sieExtensionHooks,
				   SieNumberEvents, NULL)

/* ARGSUSED */
static XEXT_GENERATE_CLOSE_DISPLAY (CloseDisplay, sieInfo)

/***********************************************************************\
|			    Sie public interfaces			|
\***********************************************************************/

Bool
XSieQueryExtension (dpy, event_base_return, error_base_return)
  Display*	dpy;
  int*		event_base_return;
  int*		error_base_return;
{
    XExtDisplayInfo*	info;

    info = FindDisplay (dpy);
    if (XextHasExtension (info))
    {
	*event_base_return = info->codes->first_event;
	*error_base_return = info->codes->first_error;
	return (True);
    }
    return (False);
}


Status
XSieQueryVersion (dpy, major_version_return, minor_version_return)
  Display*	dpy;
  int*		major_version_return;
  int*		minor_version_return;
{
    XExtDisplayInfo*		info;
    xSieQueryVersionReq*	req;
    xSieQueryVersionReply	reply;

    info = FindDisplay (dpy);
    SieCheckExtension (dpy, info, (Status) 0);

    LockDisplay (dpy);
    GetReq (SieQueryVersion, req);
    req->reqType = info->codes->major_opcode;
    req->sieReqType = X_SieQueryVersion;
    if (!_XReply (dpy, (xReply*) &reply, 0, xTrue))
    {
	UnlockDisplay (dpy);
	SyncHandle ();
	return ((Status) 0);
    }
    *major_version_return = reply.majorVersion;
    *minor_version_return = reply.minorVersion;
    UnlockDisplay (dpy);
    SyncHandle ();
    return ((Status) 1);
}

Pixmap
XSieCreateImage (dpy, drawable, widthHint, heightHint,
		 compression, data, length)
  Display*		dpy;
  XID			drawable;
  unsigned int		widthHint, heightHint;
  int			compression;
  unsigned char*	data;
  unsigned long		length;
{
    XExtDisplayInfo*	info;
    xSieCreateImageReq	request;
    xSieCreateImageReq*	req;
    unsigned long	max_bytes;
    unsigned long	nbytes;

    info = FindDisplay (dpy);
    SieCheckExtension (dpy, info, (Pixmap) 0);

    if ((data == (unsigned char*) 0) || (length == 0))
	return ((Pixmap) 0);

    LockDisplay (dpy);
    request.reqType = info->codes->major_opcode;
    request.sieReqType = X_SieCreateImage;
    request.length = (SIZEOF (xSieCreateImageReq)) >> 2;
    request.drawable = drawable;
    request.pid = XAllocID(dpy);
    request.widthHint = widthHint;
    request.heightHint = heightHint;
    request.compression = compression;

    /*
     * If we need to break the image into pieces, best results when the
     * image pieces are all the same size (except for possibly the last one).
     * If we can't fit the request in the remaining space in the buf
     * then  flush it.  Then send the image in pieces of size max_bytes.
     */
    max_bytes = ((65536 < dpy->max_request_size) ? (65536 << 2)
	: (dpy->max_request_size << 2) - SIZEOF (xSieCreateImageReq));
    request.count = length / max_bytes;
    if (request.count > 0)
	request.count++;
    if (length > max_bytes)
	_XFlush (dpy);
    while (length)
    {
	GetReq (SieCreateImage, req);
	bcopy ((char*) &request, (char*) req, SIZEOF (xSieCreateImageReq));
	nbytes = (length > max_bytes ? max_bytes : length);
	req->length += (nbytes + 3) >> 2;
        Data (dpy, (char*) data, nbytes);
	length -= nbytes;
	data += nbytes;
	request.count--;
    }
    UnlockDisplay (dpy);
    SyncHandle ();
    return ((Pixmap) request.pid);
}

void
XSieSendImage (dpy, dstDrawable, gc, widthHint,
    srcX, srcY, srcWidth, srcHeight,
    dstX, dstY, dstWidth, dstHeight,
    rotation, compression, data, length)
  Display*		dpy;
  Drawable		dstDrawable;
  GC			gc;
  unsigned int		widthHint;
  int			srcX, srcY;
  unsigned int		srcWidth, srcHeight;
  int			dstX, dstY;
  unsigned int		dstWidth, dstHeight;
  int			rotation;
  int			compression;
  unsigned char*	data;
  unsigned long		length;
{
    XExtDisplayInfo*	info;
    xSieSendImageReq	request;
    xSieSendImageReq*	req;
    unsigned long	max_bytes;
    unsigned long	nbytes;

    info = FindDisplay (dpy);
    SieSimpleCheckExtension (dpy, info);

    if ((data == (unsigned char*) 0) || (length == 0))
	return;

    LockDisplay (dpy);
    request.reqType = info->codes->major_opcode;
    request.sieReqType = X_SieSendImage;
    request.length = (SIZEOF (xSieSendImageReq)) >> 2;
    request.dstDrawable = dstDrawable;
    request.gc = gc->gid;
    request.widthHint = widthHint;
    request.srcX = srcX;
    request.srcY = srcY;
    request.srcWidth = srcWidth;
    request.srcHeight = srcHeight;
    request.dstX = dstX;
    request.dstY = dstY;
    request.dstWidth = dstWidth;
    request.dstHeight = dstHeight;
    request.compression = compression;
    request.rotation = rotation;

    /*
     * If we need to break the image into pieces, best results when the
     * image pieces are all the same size (except for possibly the last one).
     * If we can't fit the request in the remaining space in the buf
     * then  flush it.  Then send the image in pieces of size max_bytes.
     */
    max_bytes = ((65536 < dpy->max_request_size) ? (65536 << 2)
	: (dpy->max_request_size << 2) - SIZEOF (xSieSendImageReq));
    request.count = length / max_bytes;
    if (request.count > 0)
	request.count++;
    if (length > max_bytes)
	_XFlush (dpy);
    while (length)
    {
	GetReq (SieSendImage, req);
	bcopy ((char*) &request, (char*) req, SIZEOF (xSieSendImageReq));
	nbytes = (length > max_bytes ? max_bytes : length);
	req->length += (nbytes + 3) >> 2;
        Data (dpy, (char*) data, nbytes);
	length -= nbytes;
	data += nbytes;
	request.count--;
    }
    UnlockDisplay (dpy);
    SyncHandle ();
}

void
XSieCopyImage (dpy, srcDrawable, dstDrawable, gc,
    srcX, srcY, srcWidth, srcHeight,
    dstX, dstY, dstWidth, dstHeight,
    planeMask, rotation)
  Display*	dpy;
  Drawable	srcDrawable;
  Drawable	dstDrawable;
  GC		gc;
  int		srcX, srcY;
  unsigned int	srcWidth, srcHeight;
  int		dstX, dstY;
  unsigned int	dstWidth, dstHeight;
  unsigned long	planeMask;
  int		rotation;
{
    XExtDisplayInfo*	info;
    xSieCopyImageReq*	req;

    info = FindDisplay (dpy);
    SieSimpleCheckExtension (dpy, info);

    LockDisplay (dpy);
    FlushGC (dpy, gc);
    GetReq (SieCopyImage, req);
    req->reqType = info->codes->major_opcode;
    req->sieReqType = X_SieCopyImage;
    req->srcDrawable = srcDrawable;
    req->dstDrawable = dstDrawable;
    req->gc = gc->gid;
    req->srcX = srcX;
    req->srcY = srcY;
    req->srcWidth = srcWidth;
    req->srcHeight = srcHeight;
    req->dstX = dstX;
    req->dstY = dstY;
    req->dstWidth = dstWidth;
    req->dstHeight = dstHeight;
    req->planeMask = planeMask;
    req->rotation = rotation;
    UnlockDisplay (dpy);
    SyncHandle ();
}

unsigned char*
XSieFetchImage (dpy, srcDrawable,
    srcX, srcY,
    srcWidth, srcHeight,
    dstWidth, dstHeight,
    planeMask, rotation, compression,
    length_return)
  Display*		dpy;
  Drawable		srcDrawable;
  int			srcX, srcY;
  unsigned int		srcWidth, srcHeight;
  unsigned int		dstWidth, dstHeight;
  unsigned long		planeMask;
  int			rotation;
  int			compression;
  unsigned long*	length_return;
{
    XExtDisplayInfo*	info;
    xSieFetchImageReply	reply;
    xSieFetchImageReq*	req;
    unsigned long	nbytes;
    unsigned char*	data;

    info = FindDisplay (dpy);
    SieCheckExtension (dpy, info, (unsigned char*) 0);

    LockDisplay (dpy);
    GetReq (SieFetchImage, req);
    req->reqType = info->codes->major_opcode;
    req->sieReqType = X_SieFetchImage;
    req->srcDrawable = srcDrawable;
    req->srcX = srcX;
    req->srcY = srcY;
    req->srcWidth = srcWidth;
    req->srcHeight = srcHeight;
    req->dstWidth = dstWidth;
    req->dstHeight = dstHeight;
    req->planeMask = planeMask;
    req->rotation = rotation;
    req->compression = compression;

    if (_XReply (dpy, (xReply*) &reply, 0, xFalse))
    {
	nbytes = (unsigned long) reply.imageLength;
	if (data = (unsigned char*) Xmalloc ((unsigned) nbytes))
	{
	    _XReadPad (dpy, data, nbytes);
	    *length_return = nbytes;
	}
	else
	{
	    _XEatData (dpy, nbytes);
	    *length_return = 0;
	}
    }
    else
    {
	data = (unsigned char*) 0;
	*length_return = 0;
    }
    UnlockDisplay (dpy);
    SyncHandle ();
    return (data);
}
