     REM: COMPUTE THE TIME IN SECONDS SINCE JAN 1, 1978
     DEF FN.JTIME (DATE, HOURS%, MINUTES%, SECONDS%)
          FN.JTIME = ((DATE * 24.0 + HOURS%) *  \
                     60.0 + MINUTES%) * 60.0 + SECONDS%
          RETURN
     FEND

     DIM MONTH%(11)

     REM: OPEN THE ARCHIVED HISTORY FILE.
     REM: IF NOT FOUND THEN DISPLAY A MESSAGE AND EXIT
     IF END #3 THEN 1
     OPEN "HISTORY.SYS" AS 3
     IF END #3 THEN 10

     REM: ALLOCATE AN VARIABLE FOR EACH OF THE MEGABUS UNITS
     DIM UNIT.ONTIME(255), UNIT.USERID$(255)

     PRINT "DATE      TIME      USER ID   UNIT EVENT        ELASPED TIME"
     PRINT "=======  =======  =======  ==  ==============  ========="

     WHILE 1
          READ #3; RECORDTYPE$, USERID$, UNITNO%,      \
                           DATE, HOURS%, MINUTES%, SECONDS%
          JTIME = FN.JTIME (DATE, HOURS%, MINUTES%, SECONDS%)
          IF RECORDTYPE$ <> "LOGON" THEN GOTO 200
               IF UNIT.USERID$(UNITNO%) = USERID$ THEN GOTO 300
               IF UNIT.USERID$(UNITNO%) <> "" THEN GOSUB 2000
110            GOSUB 3000
               GOTO 300

200       IF RECORDTYPE$ <> "LOGOFF" THEN GOTO 300
               IF UNIT.USERID$(UNITNO%) = "" THEN GOTO 300
                    GOSUB 2000
300
     WEND

10   CLOSE 3
     STOP

1    REM: NO LOG FILE, DISPLAY ERROR MESSAGE
     PRINT "THE FILE 'HISTORY.SYS' WAS NOT FOUND ON THE DEFAULT DRIVE."
     PRINT "JOB TERMINATED."

     STOP

1000 REM PRINT DATA RECORD
     X1 = DATE
     GOSUB 4000  REM FORMAT X1 TO Y2,M,X1
     Y2 = Y2 - 1900
     FORM$ = "##/##/##  ##:##:##  /....../  ###  /............/  "
     PRINT USING FORM$; M, X1, Y2, HOURS%, MINUTES%, SECONDS%, USERID$, UNITNO%, RECORDTYPE$; 
     RETURN

2000 REM PRINT LOGOFF RECORD
     RECORDTYPE$ = "LOGOFF"
     GOSUB 1000
     ELASPED.TIME% = JTIME-UNIT.ONTIME(UNITNO%)
     ELASPED.HOURS% = ELASPED.TIME% / 3600
     ELASPED.MINS% = (ELASPED.TIME%-ELASPED.HOURS%*3600) / 60
     ELASPED.SECS% = (ELASPED.TIME%-ELASPED.HOURS%*3600-ELASPED.MINS%*60)
     FORM$ = "###:##:##"
     PRINT USING FORM$; ELASPED.HOURS%, ELASPED.MINS%, ELASPED.SECS%
     UNIT.USERID$(UNITNO%) = ""
     RETURN

3000 REM PRINT LOGON RECORD
     RECORDTYPE$ = "LOGON"
     UNIT.USERID$(UNITNO%) = USERID$
     UNIT.ONTIME(UNITNO%) = JTIME
     GOSUB 1000
     PRINT
     RETURN

4000 REM FORMAT X1 INTO X2, M, X1
     MONTH%(0) = 31
     MONTH%(1) = 28
     MONTH%(2) = 31
     MONTH%(3) = 30
     MONTH%(4) = 31
     MONTH%(5) = 30
     MONTH%(6) = 31
     MONTH%(7) = 31
     MONTH%(8) = 30
     MONTH%(9) = 31
     MONTH%(10) = 30
     MONTH%(11) = 31
     X1 = X1 - 1
     Y2 = 1978
     M = 0
4030 LYEAR% = Y2 / 4
     IF Y2 = LYEAR% * 4 THEN NDAYS = 366 \
                       ELSE NDAYS = 365
     IF X1 < NDAYS THEN GOTO 4040
     X1 = X1 - NDAYS
     Y2 = Y2 + 1
     GOTO 4030

4040 MONTH%(1) = 28
     IF Y2 = LYEAR%*4 THEN MONTH%(1) = 29
4041 IF X1 < MONTH%(M) THEN GOTO 4050
     X1 = X1 - MONTH%(M)
     M = M + 1
     GOTO 4041

4050 M = M + 1
     X1 = X1 + 1
     RETURN

     END

