{ COLOR0.PAS  - program to display MINDSET basic (eg. RGB) color palette	}
{				Pressing any key will exit the program.						}
program color0(input,output);

	const
		COLOR		= 15;				{ 0-15 colors in MINDSET RGB palette}

	type
		COLORS =						{ ascending order of colors by RGB	} 
		 (BLACK, DKBLUE, DKGREEN, DKCYAN, DKRED, DKMAGENTA, DKYELLOW, DKWHITE,
  		  DKGRAY,  BLUE,   GREEN,   CYAN,   RED,   MAGENTA,   YELLOW,   WHITE);

		POINTS = array [0..1] of word;   
										{ definition of (x,y) point			}
		{$include:'bios.typ'}
										{ MINDSET register definitions		}

	var
		kb_scan:		byte;			{ variable used to get keyboard scan}
		kb_char:		char;			{ variable used to get keyboard char}
		data_offset:	word;			{ BX for variable in get_word_addr	}
		data_segment:	word;			{ ES for variable in get_word_addr	}
		ptr_palette:	ADS OF word;  	{ basic color palette for MINDSET	}
		palette:		array [0..COLOR] of word;   
										{ MINDSET basic COLORS palette		}
		even_color:		byte;			{ even numbered pixel color  		}
		odd_color:		byte;			{ odd numbered pixel color			}
		x,y:			integer;		{ loop variables for x_ & y_org		}
		x_org:			integer;		{ x-coordinate of point to display	}
		y_org:			integer;		{ y-coordinate of point to display	}
		ptr_square:		ADS OF word;	{ pointer to square definition		}
		square:			array [0..3] of POINTS;
										{ definition of square POINTS array	}
		ptr_outline:	ADS OF word;	{ pointer to outline array			}
		outline:		array [0..6] of POINTS;
										{ definition of outline array		}
		{$include:'bios.ext'}
										{ MINDSET BIOS procedure definitions}

{*************************** C O L O R 0 . P A S ***************************}
	begin								{ start of main COLOR0.PAS program	}

		ptr_square		:= ADS square;	{ set pointer to square				}
										{ store corner points of square		}
		square[0][0]	:= 00;			{ square point [0] at (00,00)		}
		square[0][1]	:= 00;			{ square point [0] at (00,00)		}

		square[1][0]	:= 40;			{ square point [1] at (40,00)		}
		square[1][1]	:= 00;			{ square point [1] at (40,00)		}

		square[2][0]	:= 40;			{ square point [2] at (40,60)		}
		square[2][1]	:= 50;			{ square point [2] at (40,50)		}

		square[3][0]	:= 00;			{ square point [3] at (00,50)		}
		square[3][1]	:= 50;			{ square point [3] at (00,50)		}
		

		ptr_outline		:= ADS outline;	{ set pointer to outline			}

		outline[0][0]	:= 000;			{ outline point [0] at (000,000)	}
		outline[0][1]	:= 000;			{ outline point [0] at (000,000)	}
	
		outline[1][0]	:= 319;			{ outline point [1] at (319,000)	}
		outline[1][1]	:= 000;			{ outline point [1] at (319,000)	}

		outline[2][0]	:= 319;			{ outline point [2] at (319,100)	}
		outline[2][1]	:= 100;			{ outline point [2] at (319,100)	}

		outline[3][0]	:= 000;			{ outline point [3] at (000,100)	}
		outline[3][1]	:= 100;			{ outline point [3] at (000,100)	}

		outline[4][0]	:= 000;			{ outline point [4] at (000,000)	}
		outline[4][1]	:= 000;			{ outline point [4] at (000,000)	}

		outline[5][0]	:= 000;			{ outline point [5] at (000,050)	}
		outline[5][1]	:= 050;			{ outline point [5] at (000,050)	}

		outline[6][0]	:= 319;			{ outline point [6] at (319,050)	}
		outline[6][1]	:= 050;			{ outline point [6] at (319,050)	}


		ptr_palette			:= ADS palette;
										{ set up pointer to palette			}
										{ store MINDSET RGB palette values	}
		palette[ord(BLACK)]		:= 16#0000;
		palette[ord(DKBLUE)]	:= 16#1000;
		palette[ord(DKGREEN)]	:= 16#2000;
		palette[ord(DKCYAN)]	:= 16#3000;
		palette[ord(DKRED)]		:= 16#4000;
		palette[ord(DKMAGENTA)]	:= 16#5000;
		palette[ord(DKYELLOW)]	:= 16#6000;
		palette[ord(DKWHITE)]	:= 16#7000;
		palette[ord(DKGRAY)]	:= 16#8000;
		palette[ord(BLUE)]		:= 16#9000;
		palette[ord(GREEN)]		:= 16#A000;
		palette[ord(CYAN)]		:= 16#B000;
		palette[ord(RED)]		:= 16#C000;
		palette[ord(MAGENTA)]	:= 16#D000;
		palette[ord(YELLOW)]	:= 16#E000;
		palette[ord(WHITE)]		:= 16#F000;

		set_screen_mode(2);				{ MINDSET mode 320x200x16 color mode}

		fill_dest_buffer(ord(BLACK));	{ erase screen by writing all BLACK	}

		get_word_addr(ptr_palette^,data_offset,data_segment);
										{ get ES:BX for palette				}
		set_palette(ord(BLACK),ord(BLACK),COLOR,data_offset,data_segment);
										{ set MINDSET palette on machine	}


		get_word_addr(ptr_square^,data_offset,data_segment);
										{ get ES:BX for square     			}

		even_color	:= ord(BLACK);		{ even numbered pixels initially	}
		odd_color	:= ord(BLACK);		{ odd numbered pixels initially		}

		x_org		:= 40;				{ set up x & y increment values 	}
		y_org		:= 50;
										{ draw 16 colors in boxes on display}
		for y := 0 to 1 do				{ two rows of eight colors each		}
			for x := 0 to 7 do

			begin
				blt_polygon(0,4,even_color,odd_color,x*x_org,y*y_org,
							data_offset,data_segment);
										{ data_offset & segment for square	}
				even_color 	:= even_color + 1;
				odd_color	:= odd_color + 1;
			end;


		x_org		:= 0;				{ start outline display at (0,0)	}
		y_org		:= 0;
		get_word_addr(ptr_outline^,data_offset,data_segment);
										{ get ES:BX for outline				}
		blt_polyline(0,7,ord(WHITE),chained,x_org,y_org,
					data_offset,data_segment);
										{ outline palette with white lines	}

		get_kb_char(kb_char,kb_scan);	{ wait for user to press any key	}

		set_screen_mode(3);				{ MINDSET mode 640x200 for 80 column}

		set_ibm_mode(2);				{ set IBM character mode with cursor}

	end.								{ end of COLOR0.PAS program			}

